/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.InventoryPanelContainer;
import crazypants.enderio.machine.invpanel.client.CraftingHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.gui.ingredients.IGuiIngredient;
import mezz.jei.transfer.BasicRecipeTransferHandler;
import mezz.jei.transfer.BasicRecipeTransferInfo;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class InventoryPanelRecipeTransferHandler
implements IRecipeTransferHandler {
    private final IRecipeTransferHandler recipeTransferHelper = new BasicRecipeTransferHandler((IRecipeTransferInfo)new BasicRecipeTransferInfo(InventoryPanelContainer.class, "minecraft.crafting", InventoryPanelContainer.FIRST_RECIPE_SLOT, InventoryPanelContainer.NUM_RECIPE_SLOT, InventoryPanelContainer.FIRST_INVENTORY_SLOT, InventoryPanelContainer.NUM_INVENTORY_SLOT));

    public static void register(IModRegistry registry) {
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler((IRecipeTransferHandler)new InventoryPanelRecipeTransferHandler());
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockInventoryPanel), new String[]{"minecraft.crafting"});
    }

    private InventoryPanelRecipeTransferHandler() {
    }

    public Class<? extends Container> getContainerClass() {
        return InventoryPanelContainer.class;
    }

    public String getRecipeCategoryUid() {
        return "minecraft.crafting";
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@Nonnull Container container, @Nonnull IRecipeLayout recipeLayout, @Nonnull EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        if (container instanceof InventoryPanelContainer) {
            InventoryPanelContainer invPanelContainer = (InventoryPanelContainer)container;
            IRecipeTransferError transferResult = this.recipeTransferHelper.transferRecipe((Container)invPanelContainer, recipeLayout, player, maxTransfer, doTransfer);
            if (transferResult == null) {
                return null;
            }
            if (invPanelContainer.clearCraftingGrid()) {
                ItemStack[][] ingredients = new ItemStack[9][];
                IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
                Map guiIngredients = itemStacks.getGuiIngredients();
                for (int i = 0; i < 9; ++i) {
                    if (guiIngredients.containsKey(i + 1)) {
                        IGuiIngredient guiIngredient = (IGuiIngredient)guiIngredients.get(i + 1);
                        List allIngredients = guiIngredient.getAllIngredients();
                        if (!allIngredients.isEmpty()) {
                            ingredients[i] = allIngredients.toArray(new ItemStack[0]);
                            continue;
                        }
                        ingredients[i] = null;
                        continue;
                    }
                    ingredients[i] = null;
                }
                new CraftingHelper(ingredients).refill(invPanelContainer, maxTransfer ? 64 : 1);
            }
        }
        return null;
    }
}

