/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.jei;

import crazypants.enderio.EnderIO;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.jei.RecipeHandler;
import crazypants.enderio.jei.RecipeWrapper;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.machine.recipe.IRecipe;
import crazypants.enderio.machine.slicensplice.ContainerSliceAndSplice;
import crazypants.enderio.machine.slicensplice.GuiSliceAndSplice;
import crazypants.enderio.machine.slicensplice.SliceAndSpliceRecipeManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SliceAndSpliceRecipeCategory
extends BlankRecipeCategory {
    @Nonnull
    public static final String UID = "SliceNSPlice";
    private int xOff = 34;
    private int yOff = 10;
    @Nonnull
    private final IDrawable background;
    @Nonnull
    protected final IDrawableAnimated arror;
    private SliceAndSpliceRecipe currentRecipe;

    public static void register(IModRegistry registry, IGuiHelper guiHelper) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SliceAndSpliceRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new RecipeHandler<SliceAndSpliceRecipe>(SliceAndSpliceRecipe.class, UID)});
        registry.addRecipeClickArea(GuiSliceAndSplice.class, 155, 42, 16, 16, new String[]{UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)EnderIO.blockSliceAndSplice), new String[]{UID});
        ArrayList<SliceAndSpliceRecipe> result = new ArrayList<SliceAndSpliceRecipe>();
        for (IRecipe iRecipe : SliceAndSpliceRecipeManager.getInstance().getRecipes()) {
            result.add(new SliceAndSpliceRecipe(iRecipe));
        }
        registry.addRecipes(result);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerSliceAndSplice.class, UID, ContainerSliceAndSplice.FIRST_RECIPE_SLOT, ContainerSliceAndSplice.NUM_RECIPE_SLOT, ContainerSliceAndSplice.FIRST_INVENTORY_SLOT, ContainerSliceAndSplice.NUM_INVENTORY_SLOT);
    }

    public SliceAndSpliceRecipeCategory(IGuiHelper guiHelper) {
        ResourceLocation backgroundLocation = EnderIO.proxy.getGuiTexture("sliceAndSplice");
        this.background = guiHelper.createDrawable(backgroundLocation, this.xOff, this.yOff, 125, 70);
        IDrawableStatic flameDrawable = guiHelper.createDrawable(backgroundLocation, 177, 14, 22, 16);
        this.arror = guiHelper.createAnimatedDrawable(flameDrawable, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        String localizedName = EnderIO.blockSliceAndSplice.func_149732_F();
        return localizedName != null ? localizedName : "ERROR";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawAnimations(@Nonnull Minecraft minecraft) {
        this.arror.draw(minecraft, 104 - this.xOff, 49 - this.yOff);
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.currentRecipe == null) {
            return;
        }
        String energyString = PowerDisplayUtil.formatPower(this.currentRecipe.getEnergyRequired()) + " " + PowerDisplayUtil.abrevation();
        minecraft.field_71466_p.func_175065_a(energyString, (float)(108 - this.xOff), (float)(72 - this.yOff), 0x808080, false);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper) {
        this.currentRecipe = recipeWrapper instanceof SliceAndSpliceRecipe ? (SliceAndSpliceRecipe)recipeWrapper : null;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, false, 53 - this.xOff, 15 - this.yOff);
        guiItemStacks.init(1, false, 71 - this.xOff, 15 - this.yOff);
        guiItemStacks.init(2, true, 43 - this.xOff, 39 - this.yOff);
        guiItemStacks.init(3, true, 61 - this.xOff, 39 - this.yOff);
        guiItemStacks.init(4, true, 79 - this.xOff, 39 - this.yOff);
        guiItemStacks.init(5, true, 43 - this.xOff, 57 - this.yOff);
        guiItemStacks.init(6, true, 61 - this.xOff, 57 - this.yOff);
        guiItemStacks.init(7, true, 79 - this.xOff, 57 - this.yOff);
        guiItemStacks.init(8, false, 133 - this.xOff, 48 - this.yOff);
        guiItemStacks.setFromRecipe(0, this.getAxes());
        guiItemStacks.setFromRecipe(1, this.getShears());
        List inputs = recipeWrapper.getInputs();
        int slot = 2;
        for (Object input : inputs) {
            if (input != null) {
                guiItemStacks.setFromRecipe(slot, input);
            }
            ++slot;
        }
        Object output = recipeWrapper.getOutputs().get(0);
        if (output != null) {
            guiItemStacks.setFromRecipe(8, output);
        }
    }

    @Nonnull
    private List<ItemStack> getAxes() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(new ItemStack(Items.field_151053_p));
        res.add(new ItemStack(Items.field_151036_c));
        res.add(new ItemStack(Items.field_151006_E));
        res.add(new ItemStack(Items.field_151056_x));
        res.add(new ItemStack((Item)DarkSteelItems.itemDarkSteelAxe));
        return res;
    }

    @Nonnull
    private List<ItemStack> getShears() {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        res.add(new ItemStack((Item)Items.field_151097_aZ));
        res.add(new ItemStack((Item)DarkSteelItems.itemDarkSteelShears));
        return res;
    }

    public static class SliceAndSpliceRecipe
    extends RecipeWrapper {
        public SliceAndSpliceRecipe(IRecipe recipe) {
            super(recipe);
        }
    }
}

