/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine;

import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.render.EnumRenderMode;
import crazypants.enderio.render.EnumRenderPart;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.ICacheKey;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.dummy.BlockMachineBase;
import crazypants.enderio.render.pipeline.ItemQuadCollector;
import crazypants.enderio.render.pipeline.QuadCollector;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class MachineRenderMapper
implements IRenderMapper.IBlockRenderMapper,
IRenderMapper.IItemRenderMapper.IItemStateMapper {
    protected final EnumRenderPart body;

    public MachineRenderMapper(EnumRenderPart body) {
        this.body = body;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
        TileEntity tileEntity = state.getTileEntity();
        Block block = state.func_177230_c();
        if (tileEntity instanceof AbstractMachineEntity && block instanceof AbstractMachineBlock) {
            return this.render(state.getState(), world, pos, blockLayer, (AbstractMachineEntity)tileEntity, (AbstractMachineBlock)block);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    protected List<IBlockState> render(IBlockState state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, AbstractMachineEntity tileEntity, AbstractMachineBlock<?> block) {
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        EnumFacing facing = tileEntity.getFacing();
        if (facing == null) {
            facing = EnumFacing.SOUTH;
        }
        boolean active = tileEntity.isActive();
        if (this.body != null) {
            states.add(BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)this.body.rotate(facing))));
        }
        if (active) {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT_ON.rotate(facing))));
        } else {
            states.add(state.func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT.rotate(facing))));
        }
        return states;
    }

    @SideOnly(value=Side.CLIENT)
    protected EnumMap<EnumFacing, IOMode.EnumIOMode> renderIO(@Nonnull AbstractMachineEntity tileEntity, @Nonnull AbstractMachineBlock<?> block) {
        EnumMap<EnumFacing, IOMode.EnumIOMode> result = new EnumMap<EnumFacing, IOMode.EnumIOMode>(EnumFacing.class);
        for (EnumFacing face : EnumFacing.values()) {
            IoMode ioMode = tileEntity.getIoMode(face);
            if (ioMode == IoMode.NONE) continue;
            IOMode.EnumIOMode iOMode = block.mapIOMode(ioMode, face);
            result.put(face, iOMode);
        }
        return result.isEmpty() ? null : result;
    }

    @SideOnly(value=Side.CLIENT)
    protected EnumMap<EnumFacing, IOMode.EnumIOMode> renderPaintIO(@Nonnull AbstractMachineEntity tileEntity, @Nonnull AbstractMachineBlock<?> block) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<Pair<IBlockState, ItemStack>> mapItemRender(Block block, ItemStack stack, ItemQuadCollector itemQuadCollector) {
        ArrayList<Pair<IBlockState, ItemStack>> states = new ArrayList<Pair<IBlockState, ItemStack>>();
        if (this.body != null) {
            states.add(Pair.of((Object)BlockMachineBase.block.func_176223_P().func_177226_a(EnumRenderPart.SUB, (Comparable)((Object)this.body)), (Object)stack));
        }
        states.add(Pair.of((Object)block.func_176203_a(stack.func_77960_j()).func_177226_a(EnumRenderMode.RENDER, (Comparable)((Object)EnumRenderMode.FRONT)), (Object)stack));
        return states;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
        TileEntity tileEntity = state.getTileEntity();
        Block block = state.func_177230_c();
        if (tileEntity instanceof AbstractMachineEntity && block instanceof AbstractMachineBlock) {
            if (isPainted) {
                return this.renderPaintIO((AbstractMachineEntity)tileEntity, (AbstractMachineBlock)block);
            }
            return this.renderIO((AbstractMachineEntity)tileEntity, (AbstractMachineBlock)block);
        }
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ICacheKey getCacheKey(@Nonnull Block block, @Nonnull ItemStack stack, @Nonnull ICacheKey cacheKey) {
        return cacheKey;
    }
}

