/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPowerConsumerEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.buffer.BufferType;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.power.IInternalPowerHandler;
import crazypants.enderio.power.PowerDistributor;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileBuffer
extends AbstractPowerConsumerEntity
implements IInternalPowerHandler,
IPaintable.IPaintableTileEntity {
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    private boolean hasPower;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    private boolean hasInventory;
    @Store(value={Store.StoreFor.CLIENT, Store.StoreFor.SAVE})
    private boolean isCreative;
    private PowerDistributor dist;
    @Store
    private int maxOut;
    @Store
    private int maxIn;

    public TileBuffer() {
        super(new SlotDefinition(9, 0, 0), CapacitorKey.BUFFER_POWER_INTAKE, CapacitorKey.BUFFER_POWER_BUFFER, null);
        this.maxIn = this.maxOut = Config.powerConduitTierThreeRF;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return BufferType.get(this).getUnlocalizedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!redstoneCheck || this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.dist == null) {
            this.dist = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        int transmitted = this.dist.transmitEnergy(this.field_145850_b, Math.min(this.getMaxOutput(), this.getEnergyStored()));
        if (!this.isCreative()) {
            this.setEnergyStored(this.getEnergyStored() - transmitted);
        }
        return false;
    }

    @Override
    public void setIoMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        super.setIoMode(faceHit, mode);
        if (this.dist != null) {
            this.dist.neighboursChanged();
        }
    }

    @Override
    public void clearAllIoModes() {
        super.clearAllIoModes();
        if (this.dist != null) {
            this.dist.neighboursChanged();
        }
    }

    @Override
    public void writeToItemStack(ItemStack stack) {
        super.writeToItemStack(stack);
        stack.func_77964_b(BufferType.get(this).ordinal());
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack var2, EnumFacing side) {
        return this.hasInventory() && this.getIoMode(side).canRecieveInput() && this.isMachineItemValidForSlot(slot, var2);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        return this.hasInventory() && this.getIoMode(side).canOutput() && this.canExtractItem(slot, itemstack);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.hasPower;
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return this.maxIn;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.hasPower() && this.getIoMode(from).canRecieveInput() ? super.receiveEnergy(from, maxReceive, simulate || this.isCreative()) : 0;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        if (this.isCreative()) {
            ItemStack[] invCopy = new ItemStack[this.inventory.length];
            for (int i = 0; i < this.inventory.length; ++i) {
                invCopy[i] = this.inventory[i] == null ? null : this.inventory[i].func_77946_l();
            }
            boolean ret = super.doPull(dir);
            this.inventory = invCopy;
            return ret;
        }
        return super.doPull(dir);
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        if (dir == null || !this.shouldDoWorkThisTick(20)) {
            return false;
        }
        BlockCoord loc = this.getLocation().getLocation(dir);
        TileEntity te = this.field_145850_b.func_175625_s(loc.getBlockPos());
        if (this.isCreative()) {
            ItemStack[] invCopy = new ItemStack[this.inventory.length];
            for (int i = 0; i < this.inventory.length; ++i) {
                invCopy[i] = this.inventory[i] == null ? null : this.inventory[i].func_77946_l();
            }
            boolean ret = super.doPush(dir, te, this.slotDefinition.minInputSlot, this.slotDefinition.maxInputSlot);
            this.inventory = invCopy;
            return ret;
        }
        return super.doPush(dir, te, this.slotDefinition.minInputSlot, this.slotDefinition.maxInputSlot);
    }

    public boolean hasInventory() {
        return this.hasInventory;
    }

    public void setHasInventory(boolean hasInventory) {
        this.hasInventory = hasInventory;
    }

    @Override
    public boolean hasPower() {
        return this.hasPower;
    }

    @Override
    public boolean displayPower() {
        return this.hasPower;
    }

    public void setHasPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    public void setCreative(boolean isCreative) {
        this.isCreative = isCreative;
        if (isCreative) {
            this.setEnergyStored(this.getMaxEnergyStored() / 2);
        }
    }

    public void setIO(int in, int out) {
        this.maxIn = in;
        this.maxOut = out;
    }

    public int getMaxInput() {
        return this.maxIn;
    }

    public int getMaxOutput() {
        return this.maxOut;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.hasPower ? super.getMaxEnergyStored() : 0;
    }
}

