/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.capbank.BlockItemCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.ContainerCapBank;
import crazypants.enderio.machine.capbank.GuiCapBank;
import crazypants.enderio.machine.capbank.InfoDisplayType;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.machine.capbank.network.NetworkUtil;
import crazypants.enderio.machine.capbank.packet.PacketGuiChange;
import crazypants.enderio.machine.capbank.packet.PacketNetworkEnergyRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkEnergyResponse;
import crazypants.enderio.machine.capbank.packet.PacketNetworkIdRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkIdResponse;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateRequest;
import crazypants.enderio.machine.capbank.packet.PacketNetworkStateResponse;
import crazypants.enderio.machine.capbank.render.CapBankBlockRenderMapper;
import crazypants.enderio.machine.capbank.render.CapBankItemRenderMapper;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.render.EnumMergingBlockRenderMode;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.ISmartRenderAwareBlock;
import crazypants.enderio.render.SmartModelAttacher;
import crazypants.enderio.render.TextureRegistry;
import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.tool.ToolUtil;
import crazypants.enderio.waila.IWailaInfoProvider;
import crazypants.util.NullHelper;
import info.loenwind.autosave.Reader;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCapBank
extends BlockEio<TileCapBank>
implements IGuiHandler,
IAdvancedTooltipProvider,
IWailaInfoProvider,
IRedstoneConnectable,
ISmartRenderAwareBlock {
    @SideOnly(value=Side.CLIENT)
    private static CapBankItemRenderMapper CAPBANK_RENDER_MAPPER;
    public static final TextureRegistry.TextureSupplier gaugeIcon;
    public static final TextureRegistry.TextureSupplier infoPanelIcon;

    public static BlockCapBank create() {
        PacketHandler.INSTANCE.registerMessage(PacketNetworkStateResponse.class, PacketNetworkStateResponse.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkStateRequest.class, PacketNetworkStateRequest.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkIdRequest.class, PacketNetworkIdRequest.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkIdResponse.class, PacketNetworkIdResponse.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkEnergyRequest.class, PacketNetworkEnergyRequest.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketNetworkEnergyResponse.class, PacketNetworkEnergyResponse.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketGuiChange.class, PacketGuiChange.class, PacketHandler.nextID(), Side.SERVER);
        BlockCapBank res = new BlockCapBank();
        res.init();
        return res;
    }

    protected BlockCapBank() {
        super(ModObject.blockCapBank.getUnlocalisedName(), TileCapBank.class);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO)).func_177226_a(CapBankType.KIND, (Comparable)((Object)CapBankType.NONE)));
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemCapBank(this, this.getName());
    }

    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(142, this);
        this.func_149713_g(255);
        SmartModelAttacher.register((Block)this, EnumMergingBlockRenderMode.RENDER, EnumMergingBlockRenderMode.DEFAULTS, EnumMergingBlockRenderMode.AUTO);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EnumMergingBlockRenderMode.RENDER, CapBankType.KIND});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(CapBankType.KIND, (Comparable)((Object)CapBankType.getTypeFromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return CapBankType.getMetaFromType((CapBankType)((Object)state.func_177229_b(CapBankType.KIND)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state.func_177226_a(EnumMergingBlockRenderMode.RENDER, (Comparable)((Object)EnumMergingBlockRenderMode.AUTO));
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state != null && world != null && pos != null) {
            CapBankBlockRenderMapper renderMapper = new CapBankBlockRenderMapper(state, world, pos);
            BlockStateWrapperBase blockStateWrapper = new BlockStateWrapperBase(state, world, pos, renderMapper);
            blockStateWrapper.addCacheKey(state.func_177229_b(CapBankType.KIND));
            blockStateWrapper.addCacheKey(renderMapper);
            TileCapBank tileEntity = (TileCapBank)this.getTileEntity(world, pos);
            if (tileEntity != null) {
                for (EnumFacing face : EnumFacing.values()) {
                    blockStateWrapper.addCacheKey((Object)tileEntity.getIoMode(NullHelper.notnullJ(face, "Enum.values()")));
                    blockStateWrapper.addCacheKey((Object)tileEntity.getDisplayType(face));
                }
            }
            blockStateWrapper.bakeModel();
            return blockStateWrapper;
        }
        return state;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item p_149666_1_, CreativeTabs p_149666_2_, List<ItemStack> list) {
        for (CapBankType type : CapBankType.types()) {
            if (type.isCreative()) {
                list.add(BlockItemCapBank.createItemStackWithPower(CapBankType.getMetaFromType(type), type.getMaxEnergyStored() / 2));
                continue;
            }
            list.add(BlockItemCapBank.createItemStackWithPower(CapBankType.getMetaFromType(type), 0));
            list.add(BlockItemCapBank.createItemStackWithPower(CapBankType.getMetaFromType(type), type.getMaxEnergyStored()));
        }
    }

    public int func_180651_a(IBlockState st) {
        return this.func_176201_c(st);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    @SideOnly(value=Side.CLIENT)
    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        ItemStack[] stacks;
        list.add(PowerDisplayUtil.formatStoredPower(PowerHandlerUtil.getStoredEnergyForItem(itemstack), CapBankType.getTypeFromMeta(itemstack.func_77952_i()).getMaxEnergyStored()));
        NBTTagCompound tagCompound = itemstack.func_77978_p();
        if (tagCompound != null && (stacks = Reader.readField(tagCompound, ItemStack[].class, "inventory", new ItemStack[4])) != null) {
            int count = 0;
            for (ItemStack stack : stacks) {
                if (stack == null) continue;
                ++count;
            }
            if (count > 0) {
                String msg = EnderIO.lang.localizeExact("tile.blockCapBank.tooltip.hasItems");
                list.add(TextFormatting.GOLD + MessageFormat.format(msg, count));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        SpecialTooltipHandler.addDetailedTooltipFromResources(list, (ItemStack)itemstack);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing faceHit, float hitX, float hitY, float hitZ) {
        if (world != null && pos != null && state != null && entityPlayer != null && hand != null && faceHit != null) {
            TileCapBank tcb = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
            if (tcb == null) {
                return false;
            }
            if (entityPlayer.func_70093_af() && entityPlayer.func_184586_b(hand) == null && faceHit.func_96559_d() == 0) {
                InfoDisplayType newDisplayType = tcb.getDisplayType(faceHit).next();
                if (newDisplayType == InfoDisplayType.NONE) {
                    tcb.setDefaultIoMode(faceHit);
                } else {
                    tcb.setIoMode(faceHit, IoMode.DISABLED);
                }
                tcb.setDisplayType(faceHit, newDisplayType);
                return true;
            }
            if (!entityPlayer.func_70093_af() && ToolUtil.isToolEquipped(entityPlayer, hand)) {
                IoMode ioMode = tcb.getIoMode(faceHit);
                if (faceHit.func_96559_d() == 0) {
                    if (ioMode == IoMode.DISABLED) {
                        InfoDisplayType newDisplayType = tcb.getDisplayType(faceHit).next();
                        tcb.setDisplayType(faceHit, newDisplayType);
                        if (newDisplayType == InfoDisplayType.NONE) {
                            tcb.toggleIoModeForFace(faceHit);
                        }
                    } else {
                        tcb.toggleIoModeForFace(faceHit);
                    }
                } else {
                    tcb.toggleIoModeForFace(faceHit);
                }
                IBlockState bs = world.func_180495_p(pos);
                if (world.field_72995_K) {
                    world.func_184138_a(pos, bs, bs, 3);
                } else {
                    BlockCapBank blockCapBank2 = EnderIO.blockCapBank;
                    if (blockCapBank2 != null) {
                        world.func_175685_c(pos, (Block)blockCapBank2);
                    }
                    world.func_184138_a(pos, bs, bs, 3);
                }
                return true;
            }
        }
        return super.func_180639_a(world, pos, state, entityPlayer, hand, heldItem, faceHit, hitX, hitY, hitZ);
    }

    public boolean doNormalDrops(IBlockAccess world, BlockPos pos) {
        return false;
    }

    protected boolean openGui(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        EnderIO instance2;
        if (!world.field_72995_K && (instance2 = EnderIO.instance) != null) {
            entityPlayer.openGui((Object)instance2, 142, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileCapBank te = (TileCapBank)this.getTileEntity((IBlockAccess)NullHelper.notnullF(world, "getServerGuiElement() was called without a world"), new BlockPos(x, y, z));
        if (te != null) {
            return new ContainerCapBank(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileCapBank te = (TileCapBank)this.getTileEntity((IBlockAccess)NullHelper.notnullF(world, "getClientGuiElement() was called without a world"), new BlockPos(x, y, z));
        if (te != null) {
            return new GuiCapBank((Entity)player, player.field_71071_by, te);
        }
        return null;
    }

    public boolean isSideSolid(IBlockState bs, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public boolean func_176225_a(IBlockState bs, IBlockAccess par1IBlockAccess, BlockPos pos, EnumFacing side) {
        Block i1 = par1IBlockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c();
        return i1 == this ? false : super.func_176225_a(bs, par1IBlockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getGaugeIcon() {
        return gaugeIcon.get(TextureAtlasSprite.class);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getInfoPanelIcon() {
        return infoPanelIcon.get(TextureAtlasSprite.class);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileCapBank) {
            TileCapBank te = (TileCapBank)tile;
            te.onNeighborBlockChange(neighborBlock);
        }
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        super.func_180633_a(world, pos, state, player, stack);
        if (world != null && pos != null && stack != null) {
            Collection<TileCapBank> neigbours;
            TileCapBank cb = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
            if (cb == null) {
                return;
            }
            if (stack.func_77978_p() != null) {
                cb.readContentsFromNBT(stack.func_77978_p());
            }
            if ((neigbours = NetworkUtil.getNeigbours(cb)).isEmpty()) {
                if (player != null) {
                    int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                    EnumFacing dir = this.getDirForHeading(heading);
                    cb.setDisplayType(dir, InfoDisplayType.LEVEL_BAR);
                }
            } else {
                boolean modifiedDisplayType = this.setDisplayToVerticalFillBar(cb, (TileCapBank)this.getTileEntity((IBlockAccess)world, NullHelper.notnullM(pos.func_177977_b(), "EnumFacing.down()")));
                if (modifiedDisplayType |= this.setDisplayToVerticalFillBar(cb, (TileCapBank)this.getTileEntity((IBlockAccess)world, NullHelper.notnullM(pos.func_177984_a(), "EnumFacing.up()")))) {
                    cb.validateDisplayTypes();
                }
            }
            if (world.field_72995_K) {
                return;
            }
            IBlockState bs = world.func_180495_p(pos);
            world.func_184138_a(pos, bs, bs, 3);
        }
    }

    protected boolean setDisplayToVerticalFillBar(TileCapBank cb, TileCapBank capBank) {
        boolean modifiedDisplayType = false;
        if (capBank != null) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir.func_96559_d() != 0 || capBank.getDisplayType(dir) != InfoDisplayType.LEVEL_BAR || capBank.getType() != cb.getType()) continue;
                cb.setDisplayType(dir, InfoDisplayType.LEVEL_BAR);
                modifiedDisplayType = true;
            }
        }
        return modifiedDisplayType;
    }

    protected EnumFacing getDirForHeading(int heading) {
        switch (heading) {
            case 0: {
                return EnumFacing.values()[2];
            }
            case 1: {
                return EnumFacing.values()[5];
            }
            case 2: {
                return EnumFacing.values()[3];
            }
        }
        return EnumFacing.values()[4];
    }

    public boolean removedByPlayer(IBlockState bs, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileCapBank te;
        if (world != null && pos != null && player != null && !world.field_72995_K && !player.field_71075_bZ.field_75098_d && (te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos)) != null) {
            te.moveInventoryToNetwork();
        }
        return super.removedByPlayer(bs, world, pos, player, willHarvest);
    }

    protected void processDrop(IBlockAccess world, BlockPos pos, @Nullable TileCapBank te, ItemStack drop) {
        drop.func_77982_d(new NBTTagCompound());
        if (te != null) {
            te.writeContentsToNBT(drop.func_77978_p());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileCapBank te;
        if (world != null && pos != null && !world.field_72995_K && (te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos)) != null) {
            te.onBreakBlock();
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public AxisAlignedBB func_180640_a(IBlockState bs, World world, BlockPos pos) {
        if (world == null || pos == null) {
            return super.func_180640_a(bs, world, pos);
        }
        TileCapBank tr = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos);
        if (tr == null) {
            return super.func_180640_a(bs, world, pos);
        }
        ICapBankNetwork network = tr.getNetwork();
        if (!tr.getType().isMultiblock() || network == null) {
            return super.func_180640_a(bs, world, pos);
        }
        Vector3d min = new Vector3d(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        Vector3d max = new Vector3d(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        for (TileCapBank bc : network.getMembers()) {
            int x = bc.func_174877_v().func_177958_n();
            int y = bc.func_174877_v().func_177956_o();
            int z = bc.func_174877_v().func_177952_p();
            min.x = Math.min(min.x, (double)x);
            max.x = Math.max(max.x, (double)(x + 1));
            min.y = Math.min(min.y, (double)y);
            max.y = Math.max(max.y, (double)(y + 1));
            min.z = Math.min(min.z, (double)z);
            max.z = Math.max(max.z, (double)(z + 1));
        }
        return new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public boolean func_149740_M(IBlockState bs) {
        return true;
    }

    public int func_180641_l(IBlockState bs, World world, BlockPos pos) {
        TileCapBank te;
        if (world != null && pos != null && (te = (TileCapBank)this.getTileEntity((IBlockAccess)world, pos)) != null) {
            return te.getComparatorOutput();
        }
        return 0;
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileCapBank cap;
        TileEntity te = world.func_175625_s(new BlockPos(x, y, z));
        if (te instanceof TileCapBank && (cap = (TileCapBank)te).getNetwork() != null) {
            if (world.field_72995_K && this.shouldDoWorkThisTick(world, new BlockPos(x, y, z), 20)) {
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketNetworkStateRequest(cap));
            }
            ICapBankNetwork nw = cap.getNetwork();
            if (world.field_72995_K) {
                ((CapBankClientNetwork)nw).requestPowerUpdate(cap, 2);
            }
            if (SpecialTooltipHandler.showAdvancedTooltips()) {
                String format = Util.TAB + Util.ALIGNRIGHT + TextFormatting.WHITE;
                String suffix = Util.TAB + Util.ALIGNRIGHT + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr();
                tooltip.add(String.format("%s : %s%s%s", EnderIO.lang.localize("capbank.maxIO"), format, PowerDisplayUtil.formatPower(nw.getMaxIO()), suffix));
                tooltip.add(String.format("%s : %s%s%s", EnderIO.lang.localize("capbank.maxIn"), format, PowerDisplayUtil.formatPower(nw.getMaxInput()), suffix));
                tooltip.add(String.format("%s : %s%s%s", EnderIO.lang.localize("capbank.maxOut"), format, PowerDisplayUtil.formatPower(nw.getMaxOutput()), suffix));
                tooltip.add("");
            }
            long stored = nw.getEnergyStoredL();
            long max = nw.getMaxEnergyStoredL();
            tooltip.add(String.format("%s%s%s / %s%s%s %s", TextFormatting.WHITE, PowerDisplayUtil.formatPower(stored), TextFormatting.RESET, TextFormatting.WHITE, PowerDisplayUtil.formatPower(max), TextFormatting.RESET, PowerDisplayUtil.abrevation()));
            int change = Math.round(nw.getAverageChangePerTick());
            String color = TextFormatting.WHITE.toString();
            if (change > 0) {
                color = TextFormatting.GREEN.toString() + "+";
            } else if (change < 0) {
                color = TextFormatting.RED.toString();
            }
            tooltip.add(String.format("%s%s%s", color, PowerDisplayUtil.formatPowerPerTick(change), " " + TextFormatting.RESET.toString()));
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 4;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, EnumFacing from) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public CapBankItemRenderMapper getItemRenderMapper() {
        if (CAPBANK_RENDER_MAPPER == null) {
            CAPBANK_RENDER_MAPPER = new CapBankItemRenderMapper();
        }
        return CAPBANK_RENDER_MAPPER;
    }

    @SideOnly(value=Side.CLIENT)
    public IOMode.EnumIOMode mapIOMode(InfoDisplayType displayType, IoMode mode) {
        switch (displayType) {
            case IO: {
                return IOMode.EnumIOMode.CAPACITORBANK;
            }
            case LEVEL_BAR: {
                switch (mode) {
                    case NONE: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANKINPUTSMALL;
                    }
                    case PUSH: {
                        return IOMode.EnumIOMode.CAPACITORBANKOUTPUTSMALL;
                    }
                    case PUSH_PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case DISABLED: {
                        return IOMode.EnumIOMode.CAPACITORBANKLOCKEDSMALL;
                    }
                }
            }
            case NONE: {
                switch (mode) {
                    case NONE: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANKINPUT;
                    }
                    case PUSH: {
                        return IOMode.EnumIOMode.CAPACITORBANKOUTPUT;
                    }
                    case PUSH_PULL: {
                        return IOMode.EnumIOMode.CAPACITORBANK;
                    }
                    case DISABLED: {
                        return IOMode.EnumIOMode.CAPACITORBANKLOCKED;
                    }
                }
            }
        }
        throw new RuntimeException("Hey, leave our enums alone!");
    }

    static {
        gaugeIcon = TextureRegistry.registerTexture("blocks/capacitorBankOverlays");
        infoPanelIcon = TextureRegistry.registerTexture("blocks/capBankInfoPanel");
    }
}

