/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank;

import crazypants.enderio.config.Config;
import crazypants.util.NullHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.util.IStringSerializable;

public enum CapBankType implements IStringSerializable
{
    CREATIVE("CREATIVE", "tile.blockCapBank.creative", 500000, Config.capacitorBankTierTwoMaxStorageRF, false, true),
    SIMPLE("SIMPLE", "tile.blockCapBank.simple", Config.capacitorBankTierOneMaxIoRF, Config.capacitorBankTierOneMaxStorageRF, true, false),
    ACTIVATED("ACTIVATED", "tile.blockCapBank.activated", Config.capacitorBankTierTwoMaxIoRF, Config.capacitorBankTierTwoMaxStorageRF, true, false),
    VIBRANT("VIBRANT", "tile.blockCapBank.vibrant", Config.capacitorBankTierThreeMaxIoRF, Config.capacitorBankTierThreeMaxStorageRF, true, false),
    NONE("NONE", "tile.blockCapBank.none", 0, 0, false, true);

    @Nonnull
    public static final PropertyEnum<CapBankType> KIND;
    @Nonnull
    private final String uid;
    @Nonnull
    private final String unlocalizedName;
    private final int maxIO;
    private final int maxStored;
    private final boolean isMultiblock;
    private final boolean isCreative;

    @Nonnull
    public static List<CapBankType> types() {
        ArrayList<CapBankType> result = new ArrayList<CapBankType>();
        for (CapBankType capBankType : CapBankType.values()) {
            if (capBankType == NONE) continue;
            result.add(capBankType);
        }
        return result;
    }

    public static int getMetaFromType(CapBankType type) {
        return type == null ? 0 : type.ordinal();
    }

    @Nonnull
    public static CapBankType getTypeFromMeta(int meta) {
        return NullHelper.notnullJ(CapBankType.values()[meta >= 0 && meta < CapBankType.values().length ? meta : 0], "Enum.values()");
    }

    @Nonnull
    public static CapBankType getTypeFromUID(String uid) {
        for (CapBankType type : CapBankType.values()) {
            if (!type.uid.equals(uid)) continue;
            return type;
        }
        return ACTIVATED;
    }

    private CapBankType(String uid, String unlocalizedName, int maxIO, int maxStored, boolean isMultiblock, boolean isCreative) {
        this.uid = uid;
        this.unlocalizedName = unlocalizedName;
        this.maxIO = maxIO;
        this.maxStored = maxStored;
        this.isMultiblock = isMultiblock;
        this.isCreative = isCreative;
    }

    public int getMaxIO() {
        return this.maxIO;
    }

    public int getMaxEnergyStored() {
        return this.maxStored;
    }

    public boolean isMultiblock() {
        return this.isMultiblock;
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    @Nonnull
    public String getUid() {
        return this.uid;
    }

    @Nonnull
    public String func_176610_l() {
        return NullHelper.notnullJ(this.name().toLowerCase(Locale.ENGLISH), "String.toLowerCase()");
    }

    static {
        KIND = NullHelper.notnullM(PropertyEnum.func_177709_a((String)"kind", CapBankType.class), "PropertyEnum.create()");
    }
}

