/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.packet;

import crazypants.enderio.machine.capbank.network.ClientNetworkManager;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketNetworkEnergyResponse
implements IMessage,
IMessageHandler<PacketNetworkEnergyResponse, IMessage> {
    private int id;
    private long energyStored;
    private float avgInput;
    private float avgOutput;

    public PacketNetworkEnergyResponse() {
    }

    public PacketNetworkEnergyResponse(ICapBankNetwork network) {
        this.id = network.getId();
        this.energyStored = network.getEnergyStoredL();
        this.avgInput = network.getAverageInputPerTick();
        this.avgOutput = network.getAverageOutputPerTick();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeLong(this.energyStored);
        buf.writeFloat(this.avgInput);
        buf.writeFloat(this.avgOutput);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.energyStored = buf.readLong();
        this.avgInput = buf.readFloat();
        this.avgOutput = buf.readFloat();
    }

    public IMessage onMessage(PacketNetworkEnergyResponse message, MessageContext ctx) {
        ClientNetworkManager.getInstance().updateEnergy(message.id, message.energyStored, message.avgInput, message.avgOutput);
        return null;
    }
}

