/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.client.render.VertexRotationFacing;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.machine.capbank.BlockCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.InfoDisplayType;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.network.ICapBankNetwork;
import crazypants.enderio.render.HalfBakedQuad;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class FillGaugeBakery {
    private static final Double px = 0.0625;
    private static final Vector3d CENTER = new Vector3d(8.0 * px, 8.0 * px, 8.0 * px);
    private CapBankType bankType;
    private int height;
    private int myOffset;
    private double localFillLevel;
    private boolean connectUp;
    private boolean connectDown;
    private final IBlockAccess world;
    private final BlockPos pos;
    private final EnumFacing face;
    private final TextureAtlasSprite tex;
    private HalfBakedQuad.HalfBakedList buffer;
    private HalfBakedQuad.HalfBakedList litBuffer;

    public FillGaugeBakery(TextureAtlasSprite tex, double fillLevel) {
        this(null, null, EnumFacing.NORTH, tex, fillLevel);
    }

    public FillGaugeBakery(IBlockAccess world, BlockPos pos, EnumFacing face, TextureAtlasSprite tex, double fillLevel) {
        this.world = world;
        this.pos = pos;
        this.face = face;
        this.tex = tex;
        this.localFillLevel = fillLevel * 10.0 + 3.0;
        this.connectDown = false;
        this.connectUp = false;
        this.mkQuads();
    }

    public FillGaugeBakery(IBlockAccess world, BlockPos pos, EnumFacing face, TextureAtlasSprite tex) {
        this.world = world;
        this.pos = pos;
        this.face = face;
        this.tex = tex;
        IBlockState bs = world.func_180495_p(pos.func_177972_a(face));
        if (bs.func_177230_c().isSideSolid(bs, world, pos.func_177972_a(face), face.func_176734_d())) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof BlockCapBank)) {
            return;
        }
        this.bankType = (CapBankType)((Object)state.func_177229_b(CapBankType.KIND));
        if (!this.bankType.isMultiblock()) {
            this.height = 1;
            this.myOffset = 0;
            this.connectDown = false;
            this.connectUp = false;
        } else {
            this.countNeighbors();
        }
        if (this.bankType.isCreative()) {
            this.localFillLevel = 8.0;
        } else {
            this.calculateFillLevel();
        }
        this.mkQuads();
    }

    private void mkQuads() {
        VertexRotationFacing rot = new VertexRotationFacing(this.face);
        rot.setCenter(CENTER);
        rot.setRotation(EnumFacing.NORTH);
        this.buffer = new HalfBakedQuad.HalfBakedList();
        double upperBound = (double)(this.connectUp ? 16 : 13) * px;
        double lowerBound = (double)(this.connectDown ? 0 : 3) * px;
        double full_out = -0.5 * px;
        double half_out = full_out / 2.0;
        double quarter_out = full_out / 4.0;
        double bit_in = 0.01 * px;
        BoundingBox border1 = new BoundingBox(6.0 * px, lowerBound, full_out, 7.0 * px, upperBound, bit_in);
        this.buffer.add(border1, EnumFacing.NORTH, 15.01 * px, 15.99 * px, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border1, EnumFacing.EAST, 15.01 * px, 15.49 * px, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border1, EnumFacing.WEST, 15.99 * px, 15.51 * px, lowerBound, upperBound, this.tex, null);
        BoundingBox border2 = new BoundingBox(9.0 * px, lowerBound, full_out, 10.0 * px, upperBound, bit_in);
        this.buffer.add(border2, EnumFacing.NORTH, 12.01 * px, 12.99 * px, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border2, EnumFacing.EAST, 12.01 * px, 12.49 * px, lowerBound, upperBound, this.tex, null);
        this.buffer.add(border2, EnumFacing.WEST, 12.99 * px, 12.51 * px, lowerBound, upperBound, this.tex, null);
        BoundingBox back = new BoundingBox(6.0 * px, (double)(this.connectDown ? 0 : 2) * px, full_out, 10.0 * px, (double)(this.connectUp ? 16 : 14) * px, bit_in);
        this.buffer.add(back, EnumFacing.SOUTH, 4.01 * px, 7.99 * px, (double)(this.connectDown ? 0 : 2) * px, (double)(this.connectUp ? 16 : 14) * px, this.tex, null);
        if (!this.connectDown) {
            BoundingBox border3 = new BoundingBox(6.0 * px, lowerBound - 1.0 * px, full_out, 10.0 * px, 3.0 * px, bit_in);
            this.buffer.add(border3, EnumFacing.NORTH, 0.005 * px, 3.995 * px, 13.01 * px, 13.99 * px, this.tex, null);
            this.buffer.add(border3, EnumFacing.UP, 0.005 * px, 3.995 * px, 13.5 * px, 13.99 * px, this.tex, null);
            this.buffer.add(border3, EnumFacing.DOWN, 0.005 * px, 3.995 * px, 13.5 * px, 13.99 * px, this.tex, null);
            this.buffer.add(border3, EnumFacing.WEST, 3.01 * px, 3.49 * px, 13.01 * px, 13.99 * px, this.tex, null);
            this.buffer.add(border3, EnumFacing.EAST, 0.99 * px, 0.51 * px, 13.01 * px, 13.99 * px, this.tex, null);
        }
        if (!this.connectUp) {
            BoundingBox border4 = new BoundingBox(6.0 * px, 13.0 * px, full_out, 10.0 * px, upperBound + 1.0 * px, bit_in);
            this.buffer.add(border4, EnumFacing.NORTH, 0.005 * px, 3.995 * px, 2.01 * px, 2.99 * px, this.tex, null);
            this.buffer.add(border4, EnumFacing.UP, 0.005 * px, 3.995 * px, 2.01 * px, 2.5 * px, this.tex, null);
            this.buffer.add(border4, EnumFacing.DOWN, 0.005 * px, 3.995 * px, 2.01 * px, 2.5 * px, this.tex, null);
            this.buffer.add(border4, EnumFacing.WEST, 3.01 * px, 3.49 * px, 2.01 * px, 2.99 * px, this.tex, null);
            this.buffer.add(border4, EnumFacing.EAST, 0.99 * px, 0.51 * px, 2.01 * px, 2.99 * px, this.tex, null);
        }
        BoundingBox bg = new BoundingBox(6.5 * px, (this.connectDown ? 0.0 : 2.5) * px, quarter_out, 9.5 * px, (this.connectUp ? 16.0 : 13.5) * px, bit_in);
        this.buffer.add(bg, EnumFacing.NORTH, 12.5 * px, 15.5 * px, (this.connectDown ? 0.0 : 2.5) * px, (this.connectUp ? 16.0 : 13.5) * px, this.tex, null);
        this.buffer.transform(new VertexTransform[]{rot});
        if (this.localFillLevel > 0.001) {
            BoundingBox fg = new BoundingBox(6.5 * px, (this.connectDown ? 0.0 : 2.99) * px, half_out, 9.5 * px, this.localFillLevel * px, bit_in);
            this.litBuffer = new HalfBakedQuad.HalfBakedList();
            this.litBuffer.add(fg, EnumFacing.NORTH, 8.55 * px, 11.45 * px, (this.connectDown ? 0.0 : 2.99) * px, this.localFillLevel * px, this.tex, null);
            this.litBuffer.transform(new VertexTransform[]{rot});
        }
    }

    private void calculateFillLevel() {
        TileEntity tileEntity = this.world.func_175625_s(this.pos);
        if (!(tileEntity instanceof TileCapBank)) {
            this.localFillLevel = 0.0;
            return;
        }
        ICapBankNetwork network = ((TileCapBank)tileEntity).getNetwork();
        if (!(network instanceof CapBankClientNetwork)) {
            this.localFillLevel = 0.0;
            return;
        }
        ((CapBankClientNetwork)network).requestPowerUpdate((TileCapBank)tileEntity, 20);
        double ratio = Math.min(((CapBankClientNetwork)network).getEnergyStoredRatio(), 1.0);
        this.localFillLevel = Math.max(0.0, Math.min(ratio * (double)(this.height * 16 - 6) - (double)(this.myOffset * 16), 13.0) + 3.0);
    }

    private void countNeighbors() {
        TileEntity tileEntity;
        IBlockState infrontOfOther;
        boolean isCovered;
        IBlockState state;
        this.height = 1;
        this.myOffset = 0;
        BlockPos other = this.pos;
        while ((state = this.world.func_180495_p(other = other.func_177984_a())).func_177230_c() instanceof BlockCapBank && state.func_177229_b(CapBankType.KIND) == this.bankType && !(isCovered = (infrontOfOther = this.world.func_180495_p(other.func_177972_a(this.face))).isSideSolid(this.world, other.func_177972_a(this.face), this.face.func_176734_d())) && (tileEntity = this.world.func_175625_s(other)) instanceof TileCapBank && ((TileCapBank)tileEntity).getDisplayType(this.face) == InfoDisplayType.LEVEL_BAR) {
            ++this.height;
            this.connectUp = true;
        }
        other = this.pos;
        while ((state = this.world.func_180495_p(other = other.func_177977_b())).func_177230_c() instanceof BlockCapBank && state.func_177229_b(CapBankType.KIND) == this.bankType && !(isCovered = (infrontOfOther = this.world.func_180495_p(other.func_177972_a(this.face))).isSideSolid(this.world, other.func_177972_a(this.face), this.face.func_176734_d())) && (tileEntity = this.world.func_175625_s(other)) instanceof TileCapBank && ((TileCapBank)tileEntity).getDisplayType(this.face) == InfoDisplayType.LEVEL_BAR) {
            ++this.height;
            ++this.myOffset;
            this.connectDown = true;
        }
    }

    public void render() {
        if (this.canRender()) {
            int i = this.world.func_175626_b(this.pos.func_177972_a(this.face), 0);
            int j = i % 65536;
            int k = i / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtil.bindBlockTexture();
            VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
            tes.func_181668_a(7, DefaultVertexFormats.field_181712_l);
            this.buffer.render(tes);
            if (this.litBuffer != null) {
                this.litBuffer.render(tes);
            }
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    public boolean canRender() {
        return this.buffer != null;
    }

    public void bake(List<BakedQuad> quads) {
        this.buffer.bake(quads);
        if (this.litBuffer != null) {
            this.litBuffer.bake(quads);
        }
    }
}

