/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnder;
import crazypants.enderio.Log;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.TileEnchanter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerEnchanter
extends ContainerEnder<TileEnchanter> {
    public static int FIRST_RECIPE_SLOT = 0;
    public static int NUM_RECIPE_SLOT = 3;
    public static int FIRST_INVENTORY_SLOT = 4;
    public static int NUM_INVENTORY_SLOT = 36;

    public ContainerEnchanter(EntityPlayer player, InventoryPlayer playerInv, TileEnchanter te) {
        super(playerInv, (IInventory)te);
    }

    protected void addSlots(InventoryPlayer playerInv) {
        final TileEnchanter te = (TileEnchanter)this.getInv();
        this.func_75146_a(new Slot((IInventory)te, 0, 16, 35){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(@Nullable ItemStack itemStack) {
                return te.func_94041_b(0, itemStack);
            }

            public void func_75218_e() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.func_75146_a(new Slot((IInventory)te, 1, 65, 35){

            public boolean func_75214_a(@Nullable ItemStack itemStack) {
                return te.func_94041_b(1, itemStack);
            }

            public void func_75218_e() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.func_75146_a(new Slot((IInventory)te, 2, 85, 35){

            public boolean func_75214_a(@Nullable ItemStack itemStack) {
                return te.func_94041_b(2, itemStack);
            }

            public void func_75218_e() {
                ContainerEnchanter.this.updateOutput();
            }
        });
        this.func_75146_a(new Slot((IInventory)te, 3, 144, 35){

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(@Nullable ItemStack itemStack) {
                return false;
            }

            public void func_82870_a(EntityPlayer player, ItemStack stack) {
                if (!player.field_71075_bZ.field_75098_d) {
                    player.func_82242_a(-te.getCurrentEnchantmentCost());
                }
                EnchantmentData enchData = te.getCurrentEnchantmentData();
                EnchanterRecipe recipe = te.getCurrentEnchantmentRecipe();
                ItemStack curStack = te.func_70301_a(1);
                if (recipe == null || enchData == null || curStack == null) {
                    Log.error("Enchanting yielded result without resources");
                } else {
                    te.func_70298_a(2, recipe.getLapizForStackSize(curStack.field_77994_a));
                    te.func_70298_a(1, recipe.getItemsPerLevel() * enchData.field_76303_c);
                    te.func_70296_d();
                }
                te.func_70299_a(0, null);
                if (!te.func_145831_w().field_72995_K) {
                    te.func_145831_w().func_175718_b(1030, te.func_174877_v(), 0);
                    te.func_145831_w().func_175718_b(2005, te.func_174877_v().func_177984_a(), 0);
                }
            }

            public boolean func_82869_a(EntityPlayer player) {
                return ContainerEnchanter.this.playerHasEnoughLevels(player);
            }
        });
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        slots.add((GhostSlot)new GhostBackgroundItemSlot(Items.field_151099_bA, (Slot)this.field_75151_b.get(0)));
        slots.add((GhostSlot)new GhostBackgroundItemSlot(Blocks.field_150368_y, (Slot)this.field_75151_b.get(2)));
    }

    public boolean playerHasEnoughLevels(EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        return player.field_71068_ca >= ((TileEnchanter)this.getInv()).getCurrentEnchantmentCost();
    }

    private void updateOutput() {
        ItemStack output = null;
        EnchantmentData enchantment = ((TileEnchanter)this.getInv()).getCurrentEnchantmentData();
        if (enchantment != null) {
            output = new ItemStack((Item)Items.field_151134_bR);
            Items.field_151134_bR.func_92115_a(output, enchantment);
        }
        ((TileEnchanter)this.getInv()).setOutput(output);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
        ItemStack copyStack = null;
        Slot slot = (Slot)this.field_75151_b.get(par2);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            copyStack = origStack.func_77946_l();
            if (par2 <= 3 ? !this.func_75135_a(origStack, 4, this.field_75151_b.size(), true) : !(((TileEnchanter)this.getInv()).func_94041_b(0, origStack) && this.func_75135_a(origStack, 0, 1, false) || ((TileEnchanter)this.getInv()).func_94041_b(1, origStack) && this.func_75135_a(origStack, 1, 2, false) || ((TileEnchanter)this.getInv()).func_94041_b(2, origStack) && this.func_75135_a(origStack, 2, 3, false))) {
                return null;
            }
            if (origStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            slot.func_82870_a(par1EntityPlayer, origStack);
        }
        return copyStack;
    }
}

