/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.darksteel.DarkSteelItems;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class FarmStationContainer
extends AbstractMachineContainer<TileFarmStation> {
    private static final List<ItemStack> slotItemsStacks1 = new ArrayList<ItemStack>();
    private static final List<ItemStack> slotItemsStacks2 = new ArrayList<ItemStack>();
    private static final List<ItemStack> slotItemsStacks3 = new ArrayList<ItemStack>();
    public static final List<ItemStack> slotItemsSeeds = new ArrayList<ItemStack>();
    public static final List<ItemStack> slotItemsProduce = new ArrayList<ItemStack>();
    public static final List<ItemStack> slotItemsFertilizer = new ArrayList<ItemStack>();
    private static final Random rand;
    private static final int ROW_TOOLS = 19;
    private static final int ROW_IO = 44;
    private static final int COL_TOOLS = 44;
    private static final int COL_INPUT = 53;
    private static final int COL_FERTILIZER = 116;
    private static final int COL_OUTPUT = 107;
    private static final int SLOT_SIZE = 18;
    private static final int ONE = 0;
    private static final int TWO = 18;
    private static final int THREE = 36;
    private static final SlotPoint[] points;

    public FarmStationContainer(InventoryPlayer inventory, TileFarmStation te) {
        super(inventory, te);
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int i = 0;
        for (SlotPoint p : points) {
            final int slot = i++;
            p.s = new Slot(this.getInv(), slot, p.x, p.y){

                public boolean func_75214_a(@Nullable ItemStack itemStack) {
                    return ((TileFarmStation)FarmStationContainer.this.getInv()).func_94041_b(slot, itemStack);
                }

                public int func_75219_a() {
                    return ((TileFarmStation)FarmStationContainer.this.getInv()).getInventoryStackLimit(slot);
                }
            };
            this.func_75146_a(p.s);
        }
    }

    private static void clean(List<ItemStack> list) {
        Iterator<ItemStack> iterator = list.iterator();
        while (iterator.hasNext()) {
            ItemStack o = iterator.next();
            if (o != null && o.func_77973_b() != null) continue;
            iterator.remove();
        }
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        FarmStationContainer.clean(slotItemsStacks1);
        FarmStationContainer.clean(slotItemsStacks2);
        FarmStationContainer.clean(slotItemsStacks3);
        FarmStationContainer.clean(slotItemsFertilizer);
        FarmStationContainer.clean(slotItemsSeeds);
        FarmStationContainer.clean(slotItemsProduce);
        for (SlotPoint p : points) {
            slots.add((GhostSlot)new GhostBackgroundItemSlot(p.ghosts.get(rand.nextInt(p.ghosts.size())), p.s));
        }
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return new Point(8, 87);
    }

    @Override
    public Point getUpgradeOffset() {
        return new Point(12, 63);
    }

    static {
        for (Item item : new Item[]{Items.field_151017_I, Items.field_151018_J, Items.field_151019_K, Items.field_151013_M, Items.field_151012_L}) {
            slotItemsStacks1.add(new ItemStack(item));
        }
        slotItemsStacks1.addAll(Config.farmHoes);
        for (Item item : new Item[]{Items.field_151053_p, Items.field_151049_t, Items.field_151036_c, Items.field_151006_E, Items.field_151056_x, DarkSteelItems.itemDarkSteelAxe}) {
            slotItemsStacks2.add(new ItemStack(item));
        }
        for (Item item : new Item[]{Items.field_151097_aZ, DarkSteelItems.itemDarkSteelShears, (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("IC2", "itemTreetap"))}) {
            slotItemsStacks3.add(new ItemStack(item));
        }
        slotItemsSeeds.add(new ItemStack(Items.field_151014_N));
        slotItemsSeeds.add(new ItemStack(Items.field_151172_bF));
        slotItemsSeeds.add(new ItemStack(Items.field_151174_bG));
        slotItemsSeeds.add(new ItemStack((Block)Blocks.field_150337_Q));
        slotItemsSeeds.add(new ItemStack((Block)Blocks.field_150338_P));
        slotItemsSeeds.add(new ItemStack(Items.field_151075_bm));
        slotItemsSeeds.add(new ItemStack(Blocks.field_150345_g));
        slotItemsSeeds.add(new ItemStack(Items.field_151120_aE));
        slotItemsSeeds.add(new ItemStack(Items.field_151081_bc));
        slotItemsSeeds.add(new ItemStack(Items.field_151080_bb));
        slotItemsProduce.add(new ItemStack(Blocks.field_150364_r, 1, 0));
        slotItemsProduce.add(new ItemStack(Blocks.field_150464_aj));
        slotItemsProduce.add(new ItemStack((Block)Blocks.field_150362_t, 1, 0));
        slotItemsProduce.add(new ItemStack(Items.field_151034_e));
        slotItemsProduce.add(new ItemStack(Items.field_151127_ba));
        slotItemsProduce.add(new ItemStack(Blocks.field_150423_aK));
        slotItemsFertilizer.add(new ItemStack(Items.field_151100_aR, 1, 15));
        rand = new Random();
        points = new SlotPoint[]{new SlotPoint(44, 19, slotItemsStacks1), new SlotPoint(62, 19, slotItemsStacks2), new SlotPoint(80, 19, slotItemsStacks3), new SlotPoint(116, 19, slotItemsFertilizer), new SlotPoint(134, 19, slotItemsFertilizer), new SlotPoint(53, 44, slotItemsSeeds), new SlotPoint(71, 44, slotItemsSeeds), new SlotPoint(53, 62, slotItemsSeeds), new SlotPoint(71, 62, slotItemsSeeds), new SlotPoint(107, 44, slotItemsProduce), new SlotPoint(125, 44, slotItemsProduce), new SlotPoint(143, 44, slotItemsProduce), new SlotPoint(107, 62, slotItemsProduce), new SlotPoint(125, 62, slotItemsProduce), new SlotPoint(143, 62, slotItemsProduce)};
    }

    private static class SlotPoint {
        int x;
        int y;
        List<ItemStack> ghosts;
        Slot s = null;

        SlotPoint(int x, int y, List<ItemStack> ghosts) {
            this.x = x;
            this.y = y;
            this.ghosts = ghosts;
        }
    }
}

