/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.FlowerPicker;
import crazypants.enderio.machine.farm.farmers.MelonFarmer;
import crazypants.enderio.machine.farm.farmers.NaturaBerryFarmer;
import crazypants.enderio.machine.farm.farmers.NetherWartFarmer;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import crazypants.enderio.machine.farm.farmers.PlantableFarmer;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.machine.farm.farmers.StemFarmer;
import crazypants.enderio.machine.farm.farmers.TreeFarmer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;

public final class FarmersRegistry {
    public static final PlantableFarmer DEFAULT_FARMER = new PlantableFarmer();
    @GameRegistry.ItemStackHolder(value="techreborn:techreborn.rubberlog")
    public static final ItemStack techreborn_rubberlog = null;
    @GameRegistry.ItemStackHolder(value="techreborn:techreborn.rubbersapling")
    public static final ItemStack techreborn_rubbersapling = null;

    public static void addFarmers() {
        FarmersRegistry.addTechreborn();
        FarmersRegistry.addExtraUtilities2();
        FarmersRegistry.addNatura();
        FarmersRegistry.addIC2();
        FarmersRegistry.addMFR();
        FarmersRegistry.addFlowers();
        FarmersRegistry.addImmersiveEngineering();
        FarmersCommune.joinCommune(new StemFarmer((Block)Blocks.field_150436_aH, new ItemStack(Items.field_151120_aE)));
        FarmersCommune.joinCommune(new StemFarmer((Block)Blocks.field_150434_aF, new ItemStack((Block)Blocks.field_150434_aF)));
        FarmersCommune.joinCommune(new TreeFarmer(Blocks.field_150345_g, Blocks.field_150364_r));
        FarmersCommune.joinCommune(new TreeFarmer(Blocks.field_150345_g, Blocks.field_150363_s));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.field_150337_Q, Blocks.field_150419_aX));
        FarmersCommune.joinCommune(new TreeFarmer(true, (Block)Blocks.field_150338_P, Blocks.field_150420_aW));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150394_bc, Blocks.field_150440_ba, new ItemStack(Items.field_151081_bc)));
        FarmersCommune.joinCommune(new MelonFarmer(Blocks.field_150393_bb, Blocks.field_150423_aK, new ItemStack(Items.field_151080_bb)));
        FarmersCommune.joinCommune(new NetherWartFarmer());
        FarmersCommune.joinCommune(DEFAULT_FARMER);
    }

    public static void addPickable(String mod, String blockName, String itemName) {
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            Block cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            Item seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
            if (seedItem != null) {
                FarmersCommune.joinCommune(new PickableFarmer(cropBlock, new ItemStack(seedItem)));
            }
        }
    }

    public static CustomSeedFarmer addSeed(String mod, String blockName, String itemName, Block ... extraFarmland) {
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            Block cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            Item seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, itemName));
            if (seedItem != null) {
                CustomSeedFarmer farmer = new CustomSeedFarmer(cropBlock, new ItemStack(seedItem));
                if (extraFarmland != null) {
                    for (Block farmland : extraFarmland) {
                        if (farmland == null) continue;
                        farmer.addTilledBlock(farmland);
                    }
                }
                FarmersCommune.joinCommune(farmer);
                return farmer;
            }
        }
        return null;
    }

    private static void addNatura() {
        Item seedItem;
        Block cropBlock;
        String mod = "Natura";
        String blockName = "N Crops";
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            DEFAULT_FARMER.addHarvestExlude(cropBlock);
            seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, "barley.seed"));
            if (seedItem != null) {
                FarmersCommune.joinCommune(new CustomSeedFarmer(cropBlock, 3, new ItemStack(seedItem)));
                FarmersCommune.joinCommune(new PickableFarmer(cropBlock, 4, 8, new ItemStack(seedItem, 1, 1)));
            }
        }
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName = "BerryBush"))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            seedItem = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mod, blockName));
            if (seedItem != null) {
                for (int i = 0; i < 4; ++i) {
                    NaturaBerryFarmer farmer = new NaturaBerryFarmer(cropBlock, i, 12 + i, new ItemStack(seedItem, 1, 12 + i));
                    farmer.setRequiresFarmland(false);
                    FarmersCommune.joinCommune(farmer);
                }
            }
        }
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName = "florasapling"))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            FarmersCommune.joinCommune(new TreeFarmer(cropBlock, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "tree")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "willow")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "Dark Tree"))));
        }
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName = "Rare Sapling"))) {
            cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            FarmersCommune.joinCommune(new TreeFarmer(cropBlock, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "Rare Tree"))));
        }
    }

    private static void addMFR() {
        String mod = "MineFactoryReloaded";
        String blockName = "rubberwood.sapling";
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation(mod, blockName))) {
            Block cropBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, blockName));
            FarmersCommune.joinCommune(new TreeFarmer(cropBlock, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "rubberwood.log"))));
        }
    }

    private static void addIC2() {
        RubberTreeFarmerIC2 rtf = new RubberTreeFarmerIC2();
        if (rtf.isValid()) {
            FarmersCommune.joinCommune(rtf);
        }
    }

    private static void addExtraUtilities2() {
        String mod = "extrautils2";
        String name = "EnderLilly";
        CustomSeedFarmer farmer = FarmersRegistry.addSeed(mod, name, name, Blocks.field_150377_bs, (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(mod, "decorativeBlock1")));
        if (farmer != null) {
            farmer.setIgnoreGroundCanSustainCheck(true);
        }
    }

    private static void addFlowers() {
        FarmersCommune.joinCommune(new FlowerPicker().add((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("minecraft", "yellow_flower")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("minecraft", "red_flower")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("BiomesOPlenty", "flowers")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("BiomesOPlenty", "flowers2")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Botany", "flower")), (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("Botania", "flower"))));
    }

    private static void addImmersiveEngineering() {
        if (Block.field_149771_c.func_148741_d((Object)new ResourceLocation("ImmersiveEngineering", "hemp"))) {
            Block hemp = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("ImmersiveEngineering", "hemp"));
            Item hempSeed = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("ImmersiveEngineering", "hemp"));
            if (hempSeed != null) {
                FarmersCommune.joinCommune(new StemFarmer(hemp, new ItemStack(hempSeed)));
            }
        }
    }

    private FarmersRegistry() {
    }

    private static void addTechreborn() {
        if (techreborn_rubberlog != null && techreborn_rubbersapling != null) {
            FarmersCommune.joinCommune(new TreeFarmer(techreborn_rubbersapling, techreborn_rubberlog));
        }
    }
}

