/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.machine.farm.FarmStationContainer;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IFarmerJoe;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class CustomSeedFarmer
implements IFarmerJoe {
    protected Block plantedBlock;
    protected int plantedBlockMeta;
    protected int grownBlockMeta;
    protected ItemStack seeds;
    protected boolean requiresFarmland = true;
    protected List<Block> tilledBlocks = new ArrayList<Block>();
    protected boolean ignoreSustainCheck = false;
    protected boolean disableTreeFarm;

    public CustomSeedFarmer(Block plantedBlock, ItemStack seeds) {
        this(plantedBlock, 0, 7, seeds);
    }

    public CustomSeedFarmer(Block plantedBlock, int grownBlockMeta, ItemStack seeds) {
        this(plantedBlock, 0, grownBlockMeta, seeds);
    }

    public CustomSeedFarmer(Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, ItemStack seeds) {
        this.plantedBlock = plantedBlock;
        this.plantedBlockMeta = plantedBlockMeta;
        this.grownBlockMeta = grownBlockMeta;
        this.seeds = seeds;
        FarmStationContainer.slotItemsSeeds.add(seeds);
        this.addTilledBlock(Blocks.field_150458_ak);
    }

    public void addTilledBlock(Block block) {
        this.tilledBlocks.add(block);
    }

    public boolean isIgnoreGroundCanSustainCheck() {
        return this.ignoreSustainCheck;
    }

    public void setIgnoreGroundCanSustainCheck(boolean ignoreSustainCheck) {
        this.ignoreSustainCheck = ignoreSustainCheck;
    }

    public int getPlantedBlockMeta() {
        return this.plantedBlockMeta;
    }

    public Block getPlantedBlock() {
        return this.plantedBlock;
    }

    public ItemStack getSeeds() {
        return this.seeds;
    }

    public int getFullyGrownBlockMeta() {
        return this.grownBlockMeta;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, IBlockState bs) {
        int meta = bs.func_177230_c().func_176201_c(bs);
        return block == this.getPlantedBlock() && this.getFullyGrownBlockMeta() == meta;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77969_a(this.getSeeds());
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (!farm.isOpen(bc.getBlockPos())) {
            return false;
        }
        if (this.requiresFarmland()) {
            boolean tilled;
            if (this.isGroundTilled(farm, bc)) {
                return this.plantFromInventory(farm, bc);
            }
            if (farm.hasSeed(this.getSeeds(), bc) && !(tilled = this.tillBlock(farm, bc))) {
                return false;
            }
        }
        return this.plantFromInventory(farm, bc);
    }

    public boolean requiresFarmland() {
        return this.requiresFarmland;
    }

    public void setRequiresFarmland(boolean requiresFarmland) {
        this.requiresFarmland = requiresFarmland;
    }

    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc) {
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc) && farm.takeSeedFromSupplies(this.getSeeds(), bc) != null) {
            return this.plant(farm, worldObj, bc);
        }
        return false;
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, IBlockState meta) {
        if (!this.canHarvest(farm, bc, block, meta)) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification("noHoe");
            return null;
        }
        World worldObj = farm.func_145831_w();
        ArrayList<EntityItem> result = new ArrayList<EntityItem>();
        List drops = block.getDrops((IBlockAccess)worldObj, bc.getBlockPos(), meta, farm.getMaxLootingValue());
        farm.damageHoe(1, bc);
        farm.actionPerformed(false);
        boolean removed = false;
        if (drops != null) {
            for (ItemStack stack : drops) {
                if (!removed && stack.func_77969_a(this.getSeeds())) {
                    --stack.field_77994_a;
                    removed = true;
                    if (stack.field_77994_a <= 0) continue;
                    result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
                    continue;
                }
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, stack.func_77946_l()));
            }
        }
        if (removed) {
            if (!this.plant(farm, worldObj, bc)) {
                result.add(new EntityItem(worldObj, (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, this.getSeeds().func_77946_l()));
                worldObj.func_180501_a(bc.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 3);
            }
        } else {
            worldObj.func_180501_a(bc.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 3);
        }
        return new HarvestResult(result, bc.getBlockPos());
    }

    protected boolean tillBlock(TileFarmStation farm, BlockCoord plantingLocation) {
        World worldObj = farm.func_145831_w();
        BlockCoord dirtLoc = plantingLocation.getLocation(EnumFacing.DOWN);
        Block dirtBlock = farm.getBlock(dirtLoc);
        if ((dirtBlock == Blocks.field_150346_d || dirtBlock == Blocks.field_150349_c) && farm.hasHoe()) {
            farm.damageHoe(1, dirtLoc);
            worldObj.func_175656_a(dirtLoc.getBlockPos(), Blocks.field_150458_ak.func_176223_P());
            worldObj.func_184134_a((double)((float)dirtLoc.x + 0.5f), (double)((float)dirtLoc.y + 0.5f), (double)((float)dirtLoc.z + 0.5f), Blocks.field_150458_ak.func_185467_w().func_185844_d(), SoundCategory.BLOCKS, (Blocks.field_150458_ak.func_185467_w().func_185843_a() + 1.0f) / 2.0f, Blocks.field_150458_ak.func_185467_w().func_185847_b() * 0.8f, false);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    protected boolean isGroundTilled(TileFarmStation farm, BlockCoord plantingLocation) {
        Block target = farm.getBlock(plantingLocation.getLocation(EnumFacing.DOWN));
        for (Block tst : this.tilledBlocks) {
            if (tst != target) continue;
            return true;
        }
        return false;
    }

    protected boolean canPlant(World worldObj, BlockCoord bc) {
        Block target = this.getPlantedBlock();
        BlockPos groundPos = bc.getBlockPos().func_177977_b();
        IBlockState bs = worldObj.func_180495_p(groundPos);
        Block ground = bs.func_177230_c();
        IPlantable plantable = (IPlantable)this.getPlantedBlock();
        return target.func_176196_c(worldObj, bc.getBlockPos()) && (ground.canSustainPlant(bs, (IBlockAccess)worldObj, groundPos, EnumFacing.UP, plantable) || this.ignoreSustainCheck);
    }

    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc) {
        worldObj.func_180501_a(bc.getBlockPos(), Blocks.field_150350_a.func_176223_P(), 3);
        if (this.canPlant(worldObj, bc)) {
            worldObj.func_180501_a(bc.getBlockPos(), this.getPlantedBlock().func_176203_a(this.getPlantedBlockMeta()), 3);
            farm.actionPerformed(false);
            return true;
        }
        return false;
    }

    public boolean doesDisableTreeFarm() {
        return this.disableTreeFarm;
    }
}

