/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.AbstractGeneratorEntity;
import crazypants.enderio.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.PowerDistributor;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileZombieGenerator
extends AbstractGeneratorEntity
implements IFluidHandler,
ITankAccess,
IHasNutrientTank {
    private static int IO_MB_TICK = 250;
    @Store
    final SmartTank tank = new SmartTank(Fluids.fluidNutrientDistillation, 2000);
    int outputPerTick = Config.zombieGeneratorRfPerTick;
    int tickPerBucketOfFuel = Config.zombieGeneratorTicksPerBucketFuel;
    private boolean tanksDirty;
    @Store(value={Store.StoreFor.CLIENT})
    private boolean active = false;
    private PowerDistributor powerDis;
    private int ticksRemaingFuel;
    private boolean inPause;

    public TileZombieGenerator() {
        super(new SlotDefinition(0, 0, 0), ModObject.blockZombieGenerator);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockZombieGenerator.getUnlocalisedName();
    }

    @Override
    public boolean supportsMode(@Nullable EnumFacing faceHit, @Nullable IoMode mode) {
        return mode != IoMode.PUSH && mode != IoMode.PUSH_PULL;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        FluidTankInfo[] infos;
        BlockCoord loc;
        IFluidHandler target;
        boolean res = super.doPull(dir);
        if (dir != null && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && (infos = target.getTankInfo(dir.func_176734_d())) != null) {
            for (FluidTankInfo info : infos) {
                int filled;
                if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                FluidStack canPull = info.fluid.copy();
                canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                FluidStack drained = target.drain(dir.func_176734_d(), canPull, false);
                if (drained == null || drained.amount <= 0 || (filled = this.fill(dir, drained, false)) <= 0) continue;
                drained = target.drain(dir.func_176734_d(), filled, true);
                this.fill(dir, drained, true);
                return res;
            }
        }
        return res;
    }

    @Override
    public int getPowerUsePerTick() {
        return this.outputPerTick;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void onNeighborBlockChange(Block blockId) {
        super.onNeighborBlockChange(blockId);
        if (this.powerDis != null) {
            this.powerDis.neighboursChanged();
        }
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        boolean res = false;
        if (!redstoneCheck) {
            if (this.active) {
                this.active = false;
                res = true;
            }
            return res;
        }
        boolean isActive = this.generateEnergy();
        if (isActive != this.active) {
            this.active = isActive;
            res = true;
        }
        if (this.getEnergyStored() >= this.getMaxEnergyStored()) {
            this.inPause = true;
        }
        this.transmitEnergy();
        if (this.tanksDirty) {
            PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
            this.tanksDirty = false;
        }
        return res;
    }

    private boolean generateEnergy() {
        if (this.inPause && this.getEnergyStored() >= this.getMaxEnergyStored() - this.outputPerTick * 200) {
            return false;
        }
        this.inPause = false;
        if (this.tank.getFluidAmount() < this.getActivationAmount()) {
            return false;
        }
        --this.ticksRemaingFuel;
        if (this.ticksRemaingFuel <= 0) {
            this.tank.drain(1, true);
            this.ticksRemaingFuel = this.tickPerBucketOfFuel / 1000;
            this.tanksDirty = true;
        }
        this.setEnergyStored(this.getEnergyStored() + this.outputPerTick);
        return true;
    }

    int getActivationAmount() {
        return (int)((float)this.tank.getCapacity() * 0.7f);
    }

    private boolean transmitEnergy() {
        if (this.getEnergyStored() <= 0) {
            return false;
        }
        if (this.powerDis == null) {
            this.powerDis = new PowerDistributor(new BlockCoord((TileEntity)this));
        }
        int transmitted = this.powerDis.transmitEnergy(this.field_145850_b, Math.min(this.outputPerTick * 2, this.getEnergyStored()));
        this.setEnergyStored(this.getEnergyStored() - transmitted);
        return transmitted > 0;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.canFill(fluid);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public int getFluidStored(EnumFacing from) {
        return this.tank.getFluidAmount();
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == Fluids.fluidNutrientDistillation) {
            return this.tank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[0];
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.tank;
    }
}

