/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.network.NetworkUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.invpanel.TileInventoryPanel;
import crazypants.enderio.machine.invpanel.client.InventoryDatabaseClient;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketItemInfo
extends MessageTileEntity<TileInventoryPanel>
implements IMessageHandler<PacketItemInfo, IMessage> {
    private int generation;
    private byte[] compressed;

    public PacketItemInfo() {
    }

    public PacketItemInfo(TileInventoryPanel tile, InventoryDatabaseServer db, List<ItemEntry> items) {
        super((TileEntity)tile);
        this.generation = db.generation;
        try {
            this.compressed = db.compressItemInfo(items);
        }
        catch (IOException ex) {
            Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while compressing items", ex);
            this.compressed = new byte[0];
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.generation = buf.readInt();
        this.compressed = NetworkUtil.readByteArray((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.generation);
        NetworkUtil.writeByteArray((ByteBuf)buf, (byte[])this.compressed);
    }

    public IMessage onMessage(PacketItemInfo message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileEntity te = player.field_70170_p.func_175625_s(message.getPos());
        if (te instanceof TileInventoryPanel) {
            TileInventoryPanel teInvPanel = (TileInventoryPanel)te;
            InventoryDatabaseClient db = teInvPanel.getDatabaseClient(message.generation);
            try {
                db.readCompressedItems(message.compressed);
            }
            catch (IOException ex) {
                Logger.getLogger(PacketItemInfo.class.getName()).log(Level.SEVERE, "Exception while reading item info", ex);
            }
        }
        return null;
    }
}

