/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.invpanel.server;

import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.machine.invpanel.server.AbstractInventory;
import crazypants.enderio.machine.invpanel.server.InventoryDatabaseServer;
import crazypants.enderio.machine.invpanel.server.ItemEntry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

class NormalInventory
extends AbstractInventory {
    final NetworkedInventory ni;

    NormalInventory(NetworkedInventory ni) {
        this.ni = ni;
    }

    @Override
    int scanInventory(InventoryDatabaseServer db) {
        IItemHandler inv = this.ni.getInventory();
        if (inv == null) {
            this.setEmpty(db);
            return 0;
        }
        int numSlots = inv.getSlots();
        if (numSlots < 1) {
            this.setEmpty(db);
            return 0;
        }
        if (numSlots != this.slotKeys.length) {
            this.reset(db, numSlots);
        }
        for (int slot = 0; slot < numSlots; ++slot) {
            ItemStack extracted;
            ItemStack stack = inv.getStackInSlot(slot);
            if (stack != null && ((extracted = inv.extractItem(slot, stack.field_77994_a, true)) == null || extracted.field_77994_a != stack.field_77994_a)) {
                stack = null;
            }
            this.updateSlot(db, slot, stack);
        }
        return numSlots;
    }

    @Override
    public int extractItem(InventoryDatabaseServer db, ItemEntry entry, int slot, int count) {
        IItemHandler inv = this.ni.getInventory();
        if (inv == null) {
            return 0;
        }
        ItemStack stack = inv.getStackInSlot(slot);
        if (stack == null) {
            return 0;
        }
        ItemStack extracted = inv.extractItem(slot, stack.field_77994_a, true);
        if (extracted == null || extracted.field_77994_a != stack.field_77994_a) {
            return 0;
        }
        if (db.lookupItem(stack, entry, false) != entry) {
            return 0;
        }
        int remaining = stack.field_77994_a;
        if (count > remaining) {
            count = remaining;
        }
        this.ni.itemExtracted(slot, count);
        this.updateCount(db, slot, entry, remaining -= count);
        return count;
    }
}

