/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.killera.ContainerKillerJoe;
import crazypants.enderio.machine.killera.GuiKillerJoe;
import crazypants.enderio.machine.killera.KillerJoeRenderMapper;
import crazypants.enderio.machine.killera.PacketSwing;
import crazypants.enderio.machine.killera.TileKillerJoe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.TextureRegistry;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.PacketGivePlayerXP;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockKillerJoe
extends AbstractMachineBlock<TileKillerJoe> {
    static final String USERNAME = "KillerJoe";
    public static final TextureRegistry.TextureSupplier textureHead1 = TextureRegistry.registerTexture("blocks/killerJoe_head");
    public static final TextureRegistry.TextureSupplier textureHead2 = TextureRegistry.registerTexture("blocks/killerJoe_head2");
    private static final Double px = 0.0625;
    public static final AxisAlignedBB AABB = new AxisAlignedBB(2.0 * px, 0.0 * px, 2.0 * px, 14.0 * px, 16.0 * px, 14.0 * px);

    public static BlockKillerJoe create() {
        PacketHandler.INSTANCE.registerMessage(PacketSwing.class, PacketSwing.class, PacketHandler.nextID(), Side.CLIENT);
        PacketGivePlayerXP.register();
        PacketExperianceContainer.register();
        BlockKillerJoe res = new BlockKillerJoe();
        MinecraftForge.EVENT_BUS.register((Object)res);
        res.init();
        return res;
    }

    protected BlockKillerJoe() {
        super(ModObject.blockKillerJoe, TileKillerJoe.class);
        this.func_149672_a(SoundType.field_185853_f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return 1200.0f;
    }

    @SubscribeEvent
    public void getKillDisplayName(PlayerEvent.NameFormat nameEvt) {
        if (nameEvt.getUsername() != null && nameEvt.getUsername().startsWith(USERNAME)) {
            nameEvt.setDisplayname(this.func_149732_F());
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerKillerJoe(player.field_71071_by, (TileKillerJoe)world.func_175625_s(new BlockPos(x, y, z)));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiKillerJoe(player.field_71071_by, (TileKillerJoe)world.func_175625_s(new BlockPos(x, y, z)));
    }

    @Override
    protected int getGuiId() {
        return 92;
    }

    public boolean func_149662_c(IBlockState bs) {
        return false;
    }

    @Override
    protected EnumFacing getFacingForHeading(int heading) {
        switch (heading) {
            case 0: {
                return EnumFacing.SOUTH;
            }
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
        }
        return EnumFacing.EAST;
    }

    @Override
    protected void setBlockStateWrapperCache(@Nonnull IBlockStateWrapper blockStateWrapper, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull TileKillerJoe tileEntity) {
        blockStateWrapper.addCacheKey(tileEntity.getFacing());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IItemRenderMapper getItemRenderMapper() {
        return KillerJoeRenderMapper.killerJoe;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IRenderMapper.IBlockRenderMapper getBlockRenderMapper() {
        return KillerJoeRenderMapper.killerJoe;
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return true;
    }
}

