/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.killera;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.FakePlayerEIO;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.generator.zombie.IHasNutrientTank;
import crazypants.enderio.machine.generator.zombie.PacketNutrientTank;
import crazypants.enderio.machine.killera.PacketSwing;
import crazypants.enderio.machine.ranged.IRanged;
import crazypants.enderio.machine.ranged.RangeParticle;
import crazypants.enderio.machine.wireless.WirelessChargedLocation;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.SmartTank;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Storable
public class TileKillerJoe
extends AbstractMachineEntity
implements IFluidHandler,
IHaveExperience,
ITankAccess,
IHasNutrientTank,
Predicate<EntityXPOrb>,
IRanged {
    public static ZombieCache zCache;
    private static final int IO_MB_TICK = 250;
    protected BoundingBox killBounds;
    private EnumFacing[] frontFaceAndSides;
    protected AxisAlignedBB hooverBounds;
    protected Attackera attackera;
    protected WirelessChargedLocation chargedLocation;
    @Store
    final SmartTank tank = new SmartTank(Fluids.fluidNutrientDistillation, 2000);
    int lastFluidLevelUpdate;
    private boolean tanksDirty;
    private boolean isSwingInProgress;
    private int swingProgressInt;
    private float swingProgress;
    private float prevSwingProgress;
    @Store
    private final ExperienceContainer xpCon;
    private boolean hadSword;
    @Nonnull
    private static final int[] slots;
    private static final double[][] faceMidPoints;
    private static final UUID uuid;
    private static final GameProfile DUMMY_PROFILE;
    private boolean showingRange = false;
    private static final Vector4f color;

    public TileKillerJoe() {
        super(new SlotDefinition(1, 0, 0));
        int maxXP = Config.killerJoeMaxXpLevel <= 0 ? Integer.MAX_VALUE : XpUtil.getExperienceForLevel(Config.killerJoeMaxXpLevel);
        this.xpCon = new ExperienceContainer(maxXP);
        if (zCache == null) {
            zCache = new ZombieCache();
            MinecraftForge.EVENT_BUS.register((Object)zCache);
        }
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockKillerJoe.getUnlocalisedName();
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        return itemstack.func_77973_b() instanceof ItemSword || itemstack.func_77973_b() instanceof ItemAxe;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void doUpdate() {
        this.updateArmSwingProgress();
        this.hooverXP();
        if (!this.field_145850_b.field_72995_K) {
            this.getAttackera().func_70071_h_();
            if (this.inventory[0] != null != this.hadSword) {
                this.updateBlock();
                this.hadSword = this.inventory[0] != null;
            }
        }
        super.doUpdate();
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCon;
    }

    @Override
    @Nonnull
    public int[] func_180463_a(EnumFacing var1) {
        return slots;
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        if (this.isSideDisabled(side)) {
            return false;
        }
        if (this.inventory[slot] == null || this.inventory[slot].field_77994_a < itemstack.field_77994_a) {
            return false;
        }
        return itemstack.func_77973_b() == this.inventory[slot].func_77973_b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (this.shouldDoWorkThisTick(10)) {
            if (this.tanksDirty) {
                PacketHandler.sendToAllAround((IMessage)new PacketNutrientTank(this), (TileEntity)this);
                this.tanksDirty = false;
            }
            if (this.xpCon.isDirty()) {
                PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
                this.xpCon.setDirty(false);
            }
        }
        if (!redstoneCheck) {
            return false;
        }
        if (this.tank.getFluidAmount() < this.getActivationAmount()) {
            return false;
        }
        if (this.func_70301_a(0) == null) {
            return false;
        }
        Attackera atackera = this.getAttackera();
        atackera.func_184201_a(EntityEquipmentSlot.MAINHAND, this.func_70301_a(0));
        if ((float)atackera.getTicksSinceLastSwing() < atackera.func_184818_cX()) {
            return false;
        }
        List entsInBounds = this.field_145850_b.func_72872_a(EntityLivingBase.class, (AxisAlignedBB)this.getKillBounds());
        if (!entsInBounds.isEmpty()) {
            for (EntityLivingBase ent : entsInBounds) {
                if (ent.field_70128_L || ent.field_70725_aQ > 0 || ent.func_180431_b(DamageSource.field_76377_j) || ent.field_70172_ad != 0 || ent instanceof EntityPlayer && ((EntityPlayer)ent).field_71075_bZ.field_75102_a) continue;
                boolean togglePvp = false;
                if (ent instanceof EntityPlayer && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W()) {
                    if (Config.killerPvPoffDisablesSwing) continue;
                    if (Config.killerPvPoffIsIgnored) {
                        togglePvp = true;
                    }
                }
                if (Config.killerJoeMustSee && !this.canJoeSee(ent)) continue;
                if (ent instanceof EntityZombie) {
                    zCache.cache.add((EntityZombie)ent);
                }
                try {
                    if (togglePvp) {
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_71188_g(true);
                    }
                    atackera.func_71059_n((Entity)ent);
                }
                finally {
                    if (togglePvp) {
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_71188_g(false);
                    }
                }
                atackera.func_184821_cY();
                this.useNutrient();
                this.swingWeapon();
                if (this.func_70301_a(0) == null || this.func_70301_a((int)0).field_77994_a <= 0 || atackera.func_184614_ca() == null) {
                    this.func_70299_a(0, null);
                }
                return false;
            }
        }
        return false;
    }

    int getActivationAmount() {
        return (int)((float)this.tank.getCapacity() * 0.7f);
    }

    private boolean canJoeSee(EntityLivingBase ent) {
        Vec3d entPos = new Vec3d(ent.field_70165_t, ent.field_70163_u + (double)ent.func_70047_e(), ent.field_70161_v);
        for (EnumFacing facing1 : this.frontFaceAndSides) {
            if (this.field_145850_b.func_72933_a(new Vec3d((double)this.func_174877_v().func_177958_n() + faceMidPoints[facing1.ordinal()][0], (double)this.func_174877_v().func_177956_o() + faceMidPoints[facing1.ordinal()][1], (double)this.func_174877_v().func_177952_p() + faceMidPoints[facing1.ordinal()][2]), entPos) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setFacing(EnumFacing facing) {
        super.setFacing(facing);
        this.frontFaceAndSides = new EnumFacing[]{facing, facing.func_176746_e(), facing.func_176735_f()};
    }

    public ExperienceContainer getXpContainer() {
        return this.xpCon;
    }

    private void hooverXP() {
        double maxDist = Config.killerJoeHooverXpLength;
        List xp = this.field_145850_b.func_175647_a(EntityXPOrb.class, this.getHooverBounds(), (Predicate)this);
        for (EntityXPOrb entity : xp) {
            double zDist;
            double yDist;
            double xDist = (double)this.func_174877_v().func_177958_n() + 0.5 - entity.field_70165_t;
            double totalDistance = Math.sqrt(xDist * xDist + (yDist = (double)this.func_174877_v().func_177956_o() + 0.5 - entity.field_70163_u) * yDist + (zDist = (double)this.func_174877_v().func_177952_p() + 0.5 - entity.field_70161_v) * zDist);
            if (totalDistance < 1.5) {
                this.hooverXP(entity);
                continue;
            }
            double d = 1.0 - Math.max(0.1, totalDistance) / maxDist;
            double speed = 0.01 + d * 0.02;
            entity.field_70159_w += xDist / totalDistance * speed;
            entity.field_70179_y += zDist / totalDistance * speed;
            entity.field_70181_x += yDist / totalDistance * speed;
            if (!(yDist > 0.5)) continue;
            entity.field_70181_x = 0.12;
        }
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!this.field_145850_b.field_72995_K && !entity.field_70128_L) {
            this.xpCon.addExperience(entity.func_70526_d());
            entity.func_70106_y();
        }
    }

    public boolean apply(@Nullable EntityXPOrb input) {
        return input != null && !input.field_70128_L;
    }

    void swingWeapon() {
        if (this.func_70301_a(0) == null) {
            return;
        }
        if (!this.isSwingInProgress || this.swingProgressInt >= this.getArmSwingAnimationEnd() / 2 || this.swingProgressInt < 0) {
            this.swingProgressInt = -1;
            this.isSwingInProgress = true;
            if (this.field_145850_b instanceof WorldServer) {
                PacketHandler.sendToAllAround((IMessage)new PacketSwing(this), (TileEntity)this);
            }
        }
    }

    float getSwingProgress(float p_70678_1_) {
        float f1 = this.swingProgress - this.prevSwingProgress;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        return this.prevSwingProgress + f1 * p_70678_1_;
    }

    private void updateArmSwingProgress() {
        this.prevSwingProgress = this.swingProgress;
        int i = this.getArmSwingAnimationEnd();
        if (this.isSwingInProgress) {
            ++this.swingProgressInt;
            if (this.swingProgressInt >= i) {
                this.swingProgressInt = 0;
                this.isSwingInProgress = false;
            }
        } else {
            this.swingProgressInt = 0;
        }
        this.swingProgress = (float)this.swingProgressInt / (float)i;
    }

    private int getArmSwingAnimationEnd() {
        return 6;
    }

    Attackera getAttackera() {
        if (this.attackera == null) {
            this.attackera = new Attackera();
        }
        return this.attackera;
    }

    WirelessChargedLocation getChargedLocation() {
        if (this.chargedLocation == null) {
            this.chargedLocation = new WirelessChargedLocation((TileEntity)this);
        }
        return this.chargedLocation;
    }

    private BoundingBox getKillBounds() {
        if (this.killBounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += Config.killerJoeAttackHeight;
            min.y -= Config.killerJoeAttackHeight;
            EnumFacing facingDir = this.facing;
            if (ForgeDirectionOffsets.isPositiveOffset((EnumFacing)facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)Config.killerJoeAttackLength));
                min.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)Config.killerJoeAttackLength));
                max.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            }
            if (facingDir.func_82601_c() == 0) {
                min.x -= Config.killerJoeAttackWidth;
                max.x += Config.killerJoeAttackWidth;
            } else {
                min.z -= Config.killerJoeAttackWidth;
                max.z += Config.killerJoeAttackWidth;
            }
            this.killBounds = new BoundingBox(min.x, min.y, min.z, max.x, max.y, max.z);
        }
        return this.killBounds;
    }

    private AxisAlignedBB getHooverBounds() {
        if (this.hooverBounds == null) {
            BoundingBox bb = new BoundingBox(this.getLocation());
            Vector3d min = bb.getMin();
            Vector3d max = bb.getMax();
            max.y += Config.killerJoeAttackHeight;
            min.y -= Config.killerJoeAttackHeight;
            EnumFacing facingDir = this.facing;
            if (ForgeDirectionOffsets.isPositiveOffset((EnumFacing)facingDir)) {
                max.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)Config.killerJoeHooverXpLength));
                min.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            } else {
                min.add(ForgeDirectionOffsets.offsetScaled((EnumFacing)facingDir, (double)Config.killerJoeHooverXpLength));
                max.add(ForgeDirectionOffsets.forDir((EnumFacing)facingDir));
            }
            if (facingDir.func_82601_c() == 0) {
                min.x -= Config.killerJoeHooverXpWidth * 2.0;
                max.x += Config.killerJoeHooverXpWidth * 2.0;
            } else {
                min.z -= Config.killerJoeHooverXpWidth * 2.0;
                max.z += Config.killerJoeHooverXpWidth * 2.0;
            }
            this.hooverBounds = new AxisAlignedBB(min.x, min.y, min.z, max.x, max.y, max.z);
        }
        return this.hooverBounds;
    }

    private void useNutrient() {
        this.tank.drain(Config.killerJoeNutrientUsePerAttackMb, true);
        this.tanksDirty = true;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        FluidUtil.doPull((IFluidHandler)this, (EnumFacing)dir, (int)250);
        return res;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        int drained;
        FluidStack canDrain;
        BlockCoord loc;
        IFluidHandler target;
        boolean res = super.doPush(dir);
        if (dir != null && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && (canDrain = this.drain(dir, 250, false)) != null && canDrain.amount > 0 && (drained = target.fill(dir.func_176734_d(), canDrain, true)) > 0) {
            this.drain(dir, drained, true);
        }
        return res;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tanksDirty = true;
        }
        return res;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.tank.canFill(fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        return this.xpCon.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.xpCon.drain(from, maxDrain, doDrain);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.xpCon.canDrain(from, fluid);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        if (forFluidType != null && forFluidType.getFluid() == Fluids.fluidNutrientDistillation) {
            return this.tank;
        }
        return null;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCon};
    }

    public void setTanksDirty() {
        this.tanksDirty = true;
    }

    @Override
    public SmartTank getNutrientTank() {
        return this.tank;
    }

    public boolean equals(@Nullable Object obj) {
        return super.equals(obj);
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @SideOnly(value=Side.CLIENT)
    public void setShowRange(boolean showRange) {
        if (this.showingRange == showRange) {
            return;
        }
        this.showingRange = showRange;
        if (this.showingRange) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(new RangeParticle<TileKillerJoe>(this, color));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isShowingRange() {
        return this.showingRange;
    }

    @Override
    public BoundingBox getBounds() {
        return this.getKillBounds();
    }

    static {
        slots = new int[1];
        faceMidPoints = new double[][]{{0.5, 0.0, 0.5}, {0.5, 1.0, 0.5}, {0.5, 0.5, 0.0}, {0.5, 0.5, 1.0}, {0.0, 0.5, 0.5}, {1.0, 0.5, 0.5}};
        uuid = UUID.fromString("3baa66fa-a69a-11e4-89d3-123b93f75cba");
        DUMMY_PROFILE = new GameProfile(uuid, "[EioKillera]");
        color = new Vector4f(0.94f, 0.11f, 0.11f, 0.4f);
    }

    private class Attackera
    extends FakePlayerEIO {
        ItemStack prevWeapon;

        public Attackera() {
            super(TileKillerJoe.this.func_145831_w(), TileKillerJoe.this.getLocation(), DUMMY_PROFILE);
        }

        public void func_70071_h_() {
            this.func_184611_a(EnumHand.MAIN_HAND, TileKillerJoe.this.func_70301_a(0));
            ItemStack prev = this.prevWeapon;
            ItemStack cur = this.func_184614_ca();
            if (!ItemStack.func_77989_b((ItemStack)cur, (ItemStack)prev)) {
                if (prev != null) {
                    this.func_110140_aT().func_111148_a(prev.func_111283_C(EntityEquipmentSlot.MAINHAND));
                }
                if (cur != null) {
                    this.func_110140_aT().func_111147_b(cur.func_111283_C(EntityEquipmentSlot.MAINHAND));
                }
                this.prevWeapon = cur == null ? null : cur.func_77946_l();
            }
            TileKillerJoe.this.getChargedLocation().chargeItems(this.field_71071_by.field_70462_a);
            ++this.field_184617_aD;
        }

        public int getTicksSinceLastSwing() {
            return this.field_184617_aD;
        }
    }

    public static class ZombieCache {
        private Set<EntityZombie> cache = Sets.newHashSet();

        @SubscribeEvent
        public void onSummonAid(ZombieEvent.SummonAidEvent event) {
            if (!this.cache.isEmpty() && this.cache.remove(event.getSummoner())) {
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

