/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIO;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.capacitor.DefaultCapacitorData;
import crazypants.enderio.machine.light.BlockElectricLight;
import crazypants.enderio.machine.light.BlockLightNode;
import crazypants.enderio.machine.light.TileLightNode;
import crazypants.enderio.machine.wireless.WirelessChargedLocation;
import crazypants.enderio.power.IInternalPowerReceiver;
import crazypants.enderio.power.PowerHandlerUtil;
import info.loenwind.autosave.annotations.Store;
import info.loenwind.autosave.handlers.minecraft.HandleBlockPos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;

public class TileElectricLight
extends TileEntityEio
implements IInternalPowerReceiver {
    @Store
    private EnumFacing face = EnumFacing.DOWN;
    public static final int RF_USE_PER_TICK = 1;
    private boolean init = true;
    @Store(handler=HandleBlockPos.HandleBlockPosList.class)
    private List<BlockPos> lightNodes;
    private boolean updatingLightNodes = false;
    private boolean lastActive = false;
    @Store
    private boolean isInvereted;
    @Store
    private boolean isWireless;
    @Store
    private boolean requiresPower = true;
    private WirelessChargedLocation chargedLocation;
    @Store
    private int energyStoredRF;

    public void onNeighborBlockChange(Block blockID) {
        if (!this.updatingLightNodes) {
            this.init = true;
        }
    }

    public void nodeNeighbourChanged(TileLightNode tileLightNode) {
        if (!this.updatingLightNodes) {
            this.init = true;
        }
    }

    public void nodeRemoved(TileLightNode tileLightNode) {
        if (!this.updatingLightNodes) {
            this.init = true;
        }
    }

    public EnumFacing getFace() {
        return this.face;
    }

    public void setFace(EnumFacing face) {
        this.face = face;
    }

    public void setInverted(boolean inverted) {
        this.isInvereted = inverted;
    }

    public void setRequiresPower(boolean isPowered) {
        this.requiresPower = isPowered;
    }

    public boolean isRequiresPower() {
        return this.requiresPower;
    }

    public void setInvereted(boolean isInvereted) {
        this.isInvereted = isInvereted;
    }

    public boolean isInvereted() {
        return this.isInvereted;
    }

    public void setWireless(boolean wireless) {
        this.isWireless = wireless;
    }

    public boolean isWireless() {
        return this.isWireless;
    }

    public void doUpdate() {
        boolean isActivated;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean bl = isActivated = this.init ? this.field_145850_b.func_175640_z(this.field_174879_c) ^ this.isInvereted : this.lastActive;
        if (this.requiresPower) {
            if (isActivated) {
                if (!this.hasPower()) {
                    isActivated = false;
                } else {
                    this.setEnergyStored(this.getEnergyStored() - 1);
                }
            }
            if (this.init) {
                this.updateLightNodes();
            }
        }
        if (isActivated != this.lastActive || this.init) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.field_174879_c);
            bs = bs.func_177226_a((IProperty)BlockElectricLight.ACTIVE, (Comparable)Boolean.valueOf(isActivated));
            this.field_145850_b.func_180501_a(this.field_174879_c, bs, 2);
            if (this.requiresPower) {
                for (BlockPos ln : this.lightNodes) {
                    if (ln == null || (bs = this.field_145850_b.func_180495_p(ln)).func_177230_c() != EnderIO.blockLightNode) continue;
                    bs = bs.func_177226_a((IProperty)BlockLightNode.ACTIVE, (Comparable)Boolean.valueOf(isActivated));
                    this.field_145850_b.func_180501_a(ln, bs, 2);
                    this.field_145850_b.func_184138_a(ln, bs, bs, 3);
                    this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, ln);
                }
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
            this.init = false;
            this.lastActive = isActivated;
        }
        if (this.isWireless) {
            if (this.chargedLocation == null) {
                this.chargedLocation = new WirelessChargedLocation((TileEntity)this);
            }
            if (this.energyStoredRF < this.getMaxEnergyStored()) {
                boolean needInit = this.energyStoredRF == 0;
                this.energyStoredRF += this.chargedLocation.takeEnergy(Math.min(this.getMaxEnergyStored() - this.energyStoredRF, 10));
                if (needInit && this.energyStoredRF > 0) {
                    this.init = true;
                }
            }
        }
    }

    public void onBlockRemoved() {
        if (!this.requiresPower) {
            return;
        }
        this.updatingLightNodes = true;
        try {
            this.clearLightNodes();
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLightNodes() {
        Set<BlockPos> before;
        if (this.lightNodes != null && !this.lightNodes.isEmpty()) {
            before = new HashSet<BlockPos>(this.lightNodes.size());
            for (BlockPos node : this.lightNodes) {
                before.add(node);
            }
        } else {
            before = Collections.emptySet();
        }
        HashSet<BlockPos> after = new HashSet<BlockPos>(17);
        this.updatingLightNodes = true;
        try {
            if (this.lightNodes == null) {
                this.lightNodes = new ArrayList<BlockPos>();
            }
            for (BlockPos dir : EnumFacing.field_82609_l) {
                if (dir == this.face || dir == this.face.func_176734_d()) continue;
                Vector3d offset = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
                this.addNodeInDirection(new Vector3d(offset), after);
                this.addNodeInDirection(offset.add(ForgeDirectionOffsets.forDirCopy((EnumFacing)this.face.func_176734_d())), after);
            }
            this.addNodeInDirection(ForgeDirectionOffsets.forDirCopy((EnumFacing)this.face.func_176734_d()), after);
            Vector3d[] diags = new Vector3d[2];
            if (this.face.func_82601_c() != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy((EnumFacing)EnumFacing.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy((EnumFacing)EnumFacing.SOUTH);
            } else if (this.face.func_96559_d() != 0) {
                diags[0] = ForgeDirectionOffsets.forDirCopy((EnumFacing)EnumFacing.EAST);
                diags[1] = ForgeDirectionOffsets.forDirCopy((EnumFacing)EnumFacing.SOUTH);
            } else {
                diags[0] = ForgeDirectionOffsets.forDirCopy((EnumFacing)EnumFacing.UP);
                diags[1] = ForgeDirectionOffsets.forDirCopy((EnumFacing)EnumFacing.EAST);
            }
            this.addDiaganals(diags, new Vector3d(), after);
            this.addDiaganals(diags, ForgeDirectionOffsets.forDirCopy((EnumFacing)this.face.func_176734_d()), after);
            if (!before.equals(after)) {
                TileEntity te;
                this.lightNodes.clear();
                for (BlockPos entry : after) {
                    if (!before.contains(entry)) {
                        this.field_145850_b.func_180501_a(entry, EnderIO.blockLightNode.func_176223_P(), 3);
                        te = this.field_145850_b.func_175625_s(entry);
                        if (!(te instanceof TileLightNode)) continue;
                        ((TileLightNode)te).setParentPos(this.func_174877_v());
                        this.lightNodes.add(entry);
                        continue;
                    }
                    this.lightNodes.add(entry);
                }
                for (BlockPos entry : before) {
                    if (after.contains(entry) || !((te = this.field_145850_b.func_175625_s(entry)) instanceof TileLightNode) || ((TileLightNode)te).parent != null && !((TileLightNode)te).parent.equals((Object)this.func_174877_v())) continue;
                    this.field_145850_b.func_175698_g(entry);
                }
            } else {
                this.init = false;
            }
        }
        finally {
            this.updatingLightNodes = false;
        }
    }

    private void addDiaganals(Vector3d[] diags, Vector3d trans, Set<BlockPos> result) {
        Vector3d offset = new Vector3d();
        offset.set(diags[0]);
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
        offset.set(diags[0]);
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
        offset.set(diags[0]);
        offset.negate();
        offset.add(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
        offset.set(diags[0]);
        offset.negate();
        offset.sub(diags[1]);
        this.addNodeInDirection(offset.add(trans), result);
    }

    private void addNodeInDirection(Vector3d offset, Set<BlockPos> result) {
        boolean isAir = this.isAir(offset);
        boolean isTransp = this.isTranparent(offset);
        if (isAir || isTransp) {
            offset.scale(2.0);
            if (this.isAir(offset)) {
                this.addLightNode(offset, result);
            } else if (isAir) {
                offset.scale(0.5);
                this.addLightNode(offset, result);
            }
        }
    }

    private boolean isLightNode(Vector3d offset) {
        BlockPos bp = new BlockPos(this.func_174877_v().func_177958_n() + (int)offset.x, this.func_174877_v().func_177956_o() + (int)offset.y, this.func_174877_v().func_177952_p() + (int)offset.z);
        return this.field_145850_b.func_180495_p(bp).func_177230_c() == EnderIO.blockLightNode && this.field_145850_b.func_175625_s(bp) instanceof TileLightNode;
    }

    private void clearLightNodes() {
        if (this.lightNodes != null) {
            for (BlockPos ln : this.lightNodes) {
                if (this.field_145850_b.func_180495_p(ln).func_177230_c() != EnderIO.blockLightNode) continue;
                this.field_145850_b.func_175698_g(ln);
            }
            this.lightNodes.clear();
        }
    }

    private void addLightNode(Vector3d offset, Set<BlockPos> result) {
        int x = this.func_174877_v().func_177958_n() + (int)offset.x;
        int y = this.func_174877_v().func_177956_o() + (int)offset.y;
        int z = this.func_174877_v().func_177952_p() + (int)offset.z;
        if (this.isLightNode(offset)) {
            TileLightNode te = (TileLightNode)this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
            if (te.parent != null && !this.func_174877_v().equals((Object)te.parent)) {
                return;
            }
        }
        result.add(new BlockPos(x, y, z));
    }

    private boolean isRailcraftException(Block id) {
        String className = id.getClass().getName();
        return className.equals("mods.railcraft.common.blocks.machine.BlockMachine");
    }

    private boolean isTranparent(Vector3d offset) {
        Block id = this.field_145850_b.func_180495_p(new BlockPos(this.func_174877_v().func_177958_n() + (int)offset.x, this.func_174877_v().func_177956_o() + (int)offset.y, this.func_174877_v().func_177952_p() + (int)offset.z)).func_177230_c();
        if (this.isRailcraftException(id)) {
            return false;
        }
        return this.field_145850_b.getBlockLightOpacity(new BlockPos(this.func_174877_v().func_177958_n() + (int)offset.x, this.func_174877_v().func_177956_o() + (int)offset.y, this.func_174877_v().func_177952_p() + (int)offset.z)) == 0;
    }

    private boolean isAir(Vector3d offset) {
        return this.field_145850_b.func_175623_d(new BlockPos(this.func_174877_v().func_177958_n() + (int)offset.x, this.func_174877_v().func_177956_o() + (int)offset.y, this.func_174877_v().func_177952_p() + (int)offset.z)) || this.isLightNode(offset);
    }

    public boolean hasPower() {
        return this.energyStoredRF >= 1;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        if (!this.requiresPower) {
            return 0;
        }
        if (this.energyStoredRF == 0) {
            this.init = true;
        }
        return PowerHandlerUtil.recieveInternal(this, maxReceive, from, simulate);
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return this.requiresPower;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        if (!this.requiresPower) {
            return 0;
        }
        return CapacitorKey.LEGACY_ENERGY_INTAKE.get(DefaultCapacitorData.BASIC_CAPACITOR);
    }

    @Override
    public int getEnergyStored() {
        if (!this.requiresPower) {
            return 0;
        }
        return this.energyStoredRF;
    }

    @Override
    public int getMaxEnergyStored() {
        if (!this.requiresPower) {
            return 0;
        }
        return 100;
    }

    @Override
    public void setEnergyStored(int stored) {
        this.energyStoredRF = stored;
    }

    @Override
    public boolean displayPower() {
        return this.isRequiresPower();
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }
}

