/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.relocator;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.machine.obelisk.spawn.AbstractMobObelisk;
import crazypants.enderio.machine.obelisk.spawn.ISpawnCallback;
import crazypants.enderio.machine.obelisk.spawn.TileEntityAbstractSpawningObelisk;
import crazypants.enderio.network.PacketHandler;
import info.loenwind.autosave.annotations.Storable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileRelocatorObelisk
extends TileEntityAbstractSpawningObelisk {
    private final Map<EntityLivingBase, Integer> relocationQueue = new WeakHashMap<EntityLivingBase, Integer>();
    private final Random rand = new Random();

    public TileRelocatorObelisk() {
        super(new SlotDefinition(12, 0), CapacitorKey.AVERSION_POWER_INTAKE, CapacitorKey.AVERSION_POWER_BUFFER, CapacitorKey.AVERSION_POWER_USE);
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockSpawnRelocator.getUnlocalisedName();
    }

    @Override
    public ISpawnCallback.Result isSpawnPrevented(EntityLivingBase mob) {
        if (this.redstoneCheckPassed && this.hasPower() && this.isMobInRange(mob) && this.isMobInFilter(mob)) {
            this.relocationQueue.put(mob, null);
            return ISpawnCallback.Result.DONE;
        }
        return ISpawnCallback.Result.NEXT;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        if (!this.relocationQueue.isEmpty()) {
            AxisAlignedBB targetBB = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 1, 1)).func_72314_b(4.0, 1.0, 4.0);
            Iterator<EntityLivingBase> iterator = this.relocationQueue.keySet().iterator();
            while (iterator.hasNext()) {
                double dy;
                double dz;
                double z;
                double y;
                double dx;
                EntityLivingBase mob = iterator.next();
                if (mob == null || mob.field_70128_L || this.field_145850_b.func_73045_a(mob.func_145782_y()) == null || mob.field_70173_aa > 1200 || this.relocationQueue.size() > 35) {
                    iterator.remove();
                    continue;
                }
                if (!this.hasPower() || !(this.rand.nextFloat() < 0.025f)) continue;
                AxisAlignedBB mobbb = mob.func_174813_aQ();
                if (targetBB.func_72326_a(mobbb)) {
                    iterator.remove();
                    continue;
                }
                double x = (double)this.func_174877_v().func_177958_n() + 0.5 + Math.random() * 8.0 - 4.0;
                AxisAlignedBB bb = new AxisAlignedBB(x - (dx = mobbb.field_72336_d - mobbb.field_72340_a) / 2.0, y = (double)this.func_174877_v().func_177956_o() + 0.5 + Math.random() * 3.0 - 1.5, (z = (double)this.func_174877_v().func_177952_p() + 0.5 + Math.random() * 8.0 - 4.0) - (dz = mobbb.field_72334_f - mobbb.field_72339_c) / 2.0, x + dx / 2.0, y + (dy = mobbb.field_72337_e - mobbb.field_72338_b), z + dz / 2.0);
                boolean spaceClear = this.field_145850_b.func_72917_a(bb, (Entity)mob) && this.field_145850_b.func_184144_a((Entity)mob, bb).isEmpty() && this.field_145850_b.func_72953_d(bb) == mob.isCreatureType(EnumCreatureType.WATER_CREATURE, false);
                if (!spaceClear) continue;
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(new BlockCoord(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v)), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, 64.0));
                mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                mob.func_70634_a(x - dx / 2.0, y, z - dz / 2.0);
                mob.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFarmAction(new BlockCoord(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v)), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, 64.0));
                iterator.remove();
            }
        }
        return super.processTasks(redstoneCheck);
    }

    @Override
    public AbstractMobObelisk.SpawnObeliskAction getSpawnObeliskAction() {
        return AbstractMobObelisk.SpawnObeliskAction.RELOCATE;
    }
}

