/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.render;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.obelisk.AbstractBlockObelisk;
import crazypants.enderio.machine.obelisk.attractor.TileAttractor;
import crazypants.enderio.machine.obelisk.aversion.AversionObeliskRenderer;
import crazypants.enderio.machine.obelisk.aversion.TileAversionObelisk;
import crazypants.enderio.machine.obelisk.inhibitor.TileInhibitorObelisk;
import crazypants.enderio.machine.obelisk.relocator.RelocatorObeliskRenderer;
import crazypants.enderio.machine.obelisk.relocator.TileRelocatorObelisk;
import crazypants.enderio.machine.obelisk.render.ObeliskSpecialRenderer;
import crazypants.enderio.machine.obelisk.weather.TileWeatherObelisk;
import crazypants.enderio.machine.obelisk.weather.WeatherObeliskSpecialRenderer;
import crazypants.enderio.machine.obelisk.xp.TileExperienceObelisk;
import crazypants.enderio.material.Material;
import crazypants.enderio.render.TextureRegistry;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ObeliskRenderManager {
    public static final ObeliskRenderManager INSTANCE = new ObeliskRenderManager();
    public static ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("enderio:obelisk");
    private TextureRegistry.TextureSupplier[] textures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obeliskBottom"), TextureRegistry.registerTexture("blocks/blockSoulMachineTop"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide"), TextureRegistry.registerTexture("blocks/blockAttractorSide")};
    private TextureRegistry.TextureSupplier[] activeTextures = new TextureRegistry.TextureSupplier[]{TextureRegistry.registerTexture("blocks/obeliskBottom"), TextureRegistry.registerTexture("blocks/blockSoulMachineTop"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn"), TextureRegistry.registerTexture("blocks/blockAttractorSideOn")};

    private ObeliskRenderManager() {
    }

    public void registerRenderers() {
        ObeliskSpecialRenderer eor;
        AbstractBlockObelisk block = EnderIO.blockExperianceOblisk;
        if (block != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack((Item)EnderIO.itemXpTransfer));
            this.registerRenderer(block, TileExperienceObelisk.class, eor);
        }
        if ((block = EnderIO.blockAttractor) != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack((Item)EnderIO.itemMaterial, 1, Material.ATTRACTOR_CRYSTAL.ordinal()));
            this.registerRenderer(block, TileAttractor.class, eor);
        }
        if ((block = EnderIO.blockSpawnGuard) != null) {
            eor = new AversionObeliskRenderer();
            this.registerRenderer(block, TileAversionObelisk.class, eor);
        }
        if ((block = EnderIO.blockSpawnRelocator) != null) {
            eor = new RelocatorObeliskRenderer();
            this.registerRenderer(block, TileRelocatorObelisk.class, eor);
        }
        if ((block = EnderIO.blockWeatherObelisk) != null) {
            eor = new WeatherObeliskSpecialRenderer(new ItemStack(Items.field_151152_bP));
            this.registerRenderer(block, TileWeatherObelisk.class, eor);
        }
        if ((block = EnderIO.blockInhibitorObelisk) != null) {
            eor = new ObeliskSpecialRenderer(new ItemStack(Items.field_151079_bi));
            this.registerRenderer(block, TileInhibitorObelisk.class, eor);
        }
    }

    private <T extends AbstractMachineEntity> void registerRenderer(AbstractBlockObelisk<? extends AbstractMachineEntity> block, Class<T> tileClass, TileEntitySpecialRenderer<? super T> specialRenderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tileClass, specialRenderer);
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a(block), (int)0, tileClass);
    }

    public TextureRegistry.TextureSupplier[] getTextures() {
        return this.textures;
    }

    public TextureRegistry.TextureSupplier[] getActiveTextures() {
        return this.activeTextures;
    }
}

