/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.obelisk.xp;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.ModObject;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.machine.obelisk.xp.PacketXpTransferEffects;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.xp.XpUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemXpTransfer
extends Item
implements IResourceTooltipProvider {
    public static ItemXpTransfer create() {
        PacketHandler.INSTANCE.registerMessage(PacketXpTransferEffects.class, PacketXpTransferEffects.class, PacketHandler.nextID(), Side.CLIENT);
        ItemXpTransfer result = new ItemXpTransfer();
        result.init();
        return result;
    }

    protected ItemXpTransfer() {
        this.func_77637_a(EnderIOTab.tabEnderIO);
        this.func_77655_b(ModObject.itemXpTransfer.getUnlocalisedName());
        this.setRegistryName(ModObject.itemXpTransfer.getUnlocalisedName());
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return ItemXpTransfer.onActivated(player, world, pos, side);
    }

    public static EnumActionResult onActivated(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        boolean res;
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        boolean swing = false;
        if (player.func_70093_af()) {
            swing = res = ItemXpTransfer.tranferFromPlayerToBlock(player, world, pos, side);
        } else {
            res = ItemXpTransfer.tranferFromBlockToPlayer(player, world, pos, side);
        }
        if (res) {
            ItemXpTransfer.sendXPUpdate(player, world, pos, swing);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public static void sendXPUpdate(EntityPlayer player, World world, BlockPos pos, boolean swing) {
        Vector3d look = Util.getLookVecEio((EntityPlayer)player);
        double xP = player.field_70165_t + look.x;
        double yP = player.field_70163_u + 1.5;
        double zP = player.field_70161_v + look.z;
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketXpTransferEffects(swing, xP, yP, zP), (EntityPlayerMP)player);
        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f), false);
    }

    public static boolean tranferFromBlockToPlayer(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler fh = (IFluidHandler)te;
        if (!fh.canDrain(side, Fluids.fluidXpJuice)) {
            return false;
        }
        int currentXP = XpUtil.getPlayerXP(player);
        int nextLevelXP = XpUtil.getExperienceForLevel(player.field_71068_ca + 1);
        int requiredXP = nextLevelXP - currentXP;
        int fluidVolume = XpUtil.experienceToLiquid(requiredXP);
        FluidStack fs = new FluidStack(Fluids.fluidXpJuice, fluidVolume);
        FluidStack res = fh.drain(side, fs, true);
        if (res == null || res.amount <= 0) {
            return false;
        }
        int xpToGive = XpUtil.liquidToExperience(res.amount);
        player.func_71023_q(xpToGive);
        return true;
    }

    public static boolean tranferFromPlayerToBlock(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (player.field_71067_cb <= 0) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler fh = (IFluidHandler)te;
        if (!fh.canFill(side, Fluids.fluidXpJuice)) {
            return false;
        }
        int fluidVolume = XpUtil.experienceToLiquid(XpUtil.getPlayerXP(player));
        FluidStack fs = new FluidStack(Fluids.fluidXpJuice, fluidVolume);
        int takenVolume = fh.fill(side, fs, true);
        if (takenVolume <= 0) {
            return false;
        }
        int xpToTake = XpUtil.liquidToExperience(takenVolume);
        XpUtil.addPlayerXP(player, -xpToTake);
        return true;
    }

    protected void init() {
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public String getUnlocalizedNameForTooltip(ItemStack stack) {
        return this.func_77658_a();
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }
}

