/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.machine.solar.SolarPanelNetwork;
import crazypants.enderio.machine.solar.SolarType;
import crazypants.enderio.power.IInternalPowerProvider;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.waila.IWailaNBTProvider;
import info.loenwind.autosave.annotations.Storable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;

@Storable
public class TileEntitySolarPanel
extends TileEntityEio
implements IInternalPowerProvider,
IWailaNBTProvider {
    private boolean forceNetworkSearch = true;
    protected SolarPanelNetwork network = new SolarPanelNetwork();

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return from == EnumFacing.DOWN;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public int getMaxEnergyRecieved(EnumFacing dir) {
        return 0;
    }

    @Override
    public int getEnergyStored() {
        return this.network.getEnergyAvailablePerTick();
    }

    @Override
    public int getMaxEnergyStored() {
        return this.network.getEnergyMaxPerTick();
    }

    @Override
    public void setEnergyStored(int stored) {
    }

    public void doUpdate() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.network.isValid()) {
            this.network = new SolarPanelNetwork(this);
        }
        this.network.onUpdate(this, this.forceNetworkSearch);
        this.forceNetworkSearch = false;
        if (this.network.isValid()) {
            this.transmitEnergy();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.network.destroyNetwork();
    }

    int getEnergyPerTick() {
        return TileEntitySolarPanel.getEnergyPerTick(this.field_145850_b, this.field_174879_c);
    }

    static int getEnergyPerTick(World world, BlockPos pos) {
        return ((SolarType)((Object)world.func_180495_p(pos).func_177229_b(SolarType.KIND))).getRfperTick();
    }

    float calculateLightRatio() {
        return TileEntitySolarPanel.calculateLightRatio(this.field_145850_b);
    }

    boolean canSeeSun() {
        return TileEntitySolarPanel.canSeeSun(this.field_145850_b, this.field_174879_c);
    }

    static boolean canSeeSun(World world, BlockPos pos) {
        return world.func_175710_j(pos.func_177984_a());
    }

    public static float calculateLightRatio(World world) {
        int lightValue = EnumSkyBlock.SKY.field_77198_c - world.func_175657_ab();
        float sunAngle = world.func_72929_e(1.0f);
        sunAngle = sunAngle < (float)Math.PI ? (sunAngle += (0.0f - sunAngle) * 0.2f) : (sunAngle += ((float)Math.PI * 2 - sunAngle) * 0.2f);
        lightValue = Math.round((float)lightValue * MathHelper.func_76134_b((float)sunAngle));
        lightValue = MathHelper.func_76125_a((int)lightValue, (int)0, (int)15);
        return (float)lightValue / 15.0f;
    }

    private void transmitEnergy() {
        int canTransmit;
        IPowerInterface receptor = PowerHandlerUtil.create(this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(EnumFacing.DOWN)));
        if (receptor != null && receptor.getPowerRequest(EnumFacing.UP) > 0 && (canTransmit = this.network.getEnergyAvailableThisTick()) > 0) {
            this.network.extractEnergy(receptor.recieveEnergy(EnumFacing.UP, canTransmit));
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound tag) {
        super.readCustomNBT(tag);
        this.forceNetworkSearch = true;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound tag) {
        super.writeCustomNBT(tag);
        if (this.network.isValid()) {
            tag.func_74768_a("rfCap", this.network.getEnergyMaxPerTick());
        }
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    public void setNetwork(SolarPanelNetwork network) {
        this.network = network;
    }

    @Override
    public void getData(NBTTagCompound tag) {
        if (this.network.isValid()) {
            this.func_189515_b(tag);
        }
    }

    @Override
    public BlockCoord getLocation() {
        return new BlockCoord(this.field_174879_c);
    }
}

