/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import crazypants.enderio.ModObject;
import crazypants.enderio.capacitor.CapacitorKey;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileSoulBinder
extends AbstractPoweredTaskEntity
implements IHaveExperience,
IFluidHandler,
ITankAccess,
IPaintable.IPaintableTileEntity {
    @Store
    private final ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.soulBinderMaxXpLevel));
    private boolean wasWorking = false;

    public TileSoulBinder() {
        super(new SlotDefinition(2, 2, 1), CapacitorKey.SOUL_BINDER_POWER_INTAKE, CapacitorKey.SOUL_BINDER_POWER_BUFFER, CapacitorKey.SOUL_BINDER_POWER_USE);
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return ModObject.blockSoulBinder.getUnlocalisedName();
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        if (this.isActive()) {
            this.sendTaskProgressPacket();
        }
        return super.processTasks(redstoneChecksPassed);
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        IMachineRecipe recipe = super.canStartNextTask(chance);
        if (recipe == null) {
            return null;
        }
        int xpRequired = ((ISoulBinderRecipe)((Object)recipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() >= xpRequired) {
            return recipe;
        }
        return null;
    }

    public boolean needsXP() {
        return this.getXPRequired() > 0;
    }

    private int getXPRequired() {
        if (this.currentTask != null) {
            return 0;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return 0;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired() - this.getContainer().getExperienceTotal();
    }

    public int getCurrentlyRequiredLevel() {
        if (this.currentTask != null) {
            return -1;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return -1;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceLevelsRequired();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        int xpRequired = ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() < xpRequired) {
            return false;
        }
        if (super.startNextTask(nextRecipe, chance)) {
            this.xpCont.drain(null, XpUtil.experienceToLiquid(xpRequired), true);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack item) {
        int otherSlot;
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        MachineRecipeInput newInput = new MachineRecipeInput(slot, item);
        int n = otherSlot = slot == 0 ? 1 : 0;
        if (this.inventory[otherSlot] == null) {
            List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), newInput);
            if (recipes.isEmpty()) {
                return false;
            }
            for (IMachineRecipe rec : recipes) {
                if (rec == null || !rec.isValidInput(newInput)) continue;
                return true;
            }
        } else {
            MachineRecipeInput[] inputs = new MachineRecipeInput[]{newInput, new MachineRecipeInput(otherSlot, this.inventory[otherSlot])};
            return MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), inputs) != null;
        }
        return false;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        boolean res = super.doPull(dir);
        int req = this.getXPRequired();
        if (req > 0) {
            FluidUtil.doPull((IFluidHandler)this, (EnumFacing)dir, (int)Math.min(XpUtil.experienceToLiquid(req), Config.fluidConduitExtractRate));
        }
        return res;
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        boolean res = super.doPush(dir);
        int maxAmount = Math.min(XpUtil.experienceToLiquid(this.getExcessXP()), Config.fluidConduitExtractRate);
        if (maxAmount > 0) {
            FluidUtil.doPush((IFluidHandler)this, (EnumFacing)dir, (int)maxAmount);
        }
        return res;
    }

    private int getExcessXP() {
        IMachineRecipe nextRecipe;
        if (this.currentTask == null && (nextRecipe = this.getNextRecipe()) instanceof ISoulBinderRecipe) {
            return Math.max(0, this.getContainer().getExperienceTotal() - ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired());
        }
        return this.getContainer().getExperienceTotal();
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.xpCont.canFill(from, fluid);
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        int max = XpUtil.experienceToLiquid(this.getXPRequired());
        if (resource == null || max <= 0) {
            return 0;
        }
        if (max < resource.amount) {
            FluidStack copy = resource.copy();
            copy.amount = max;
            return this.xpCont.fill(from, copy, doFill);
        }
        return this.xpCont.fill(from, resource, doFill);
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        int max = XpUtil.experienceToLiquid(this.getExcessXP());
        if (resource != null && max < resource.amount) {
            FluidStack copy = resource.copy();
            copy.amount = max;
            return this.xpCont.drain(from, copy, doDrain);
        }
        return this.xpCont.drain(from, resource, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.xpCont.drain(from, Math.min(XpUtil.experienceToLiquid(this.getExcessXP()), maxDrain), doDrain);
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.xpCont.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return this.xpCont.getTankInfo(from);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }

    public boolean isWorking() {
        return this.currentTask == null ? false : this.currentTask.getProgress() >= 0.0f;
    }

    @Override
    protected void updateEntityClient() {
        super.updateEntityClient();
        if (this.wasWorking != this.isWorking()) {
            this.wasWorking = this.isWorking();
            this.updateBlock();
        }
    }

    @Override
    public String getSoundName() {
        return "machine.soulbinder";
    }

    @Override
    public float getPitch() {
        float pitch;
        switch (this.getCapacitorData().getBaseLevel()) {
            case 1: {
                pitch = 0.8f;
                break;
            }
            case 2: {
                pitch = 0.85f;
                break;
            }
            case 3: {
                pitch = 0.9f;
                break;
            }
            default: {
                pitch = 1.0f;
            }
        }
        return pitch + this.random.nextFloat() * 0.08f - 0.04f;
    }
}

