/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.FluidUtil;
import com.enderio.core.common.util.ItemUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.tank.PacketTankFluid;
import crazypants.enderio.machine.tank.VoidMode;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.tool.SmartTank;
import info.loenwind.autosave.annotations.Storable;
import info.loenwind.autosave.annotations.Store;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Storable
public class TileTank
extends AbstractMachineEntity
implements IFluidHandler,
ITankAccess,
IPaintable.IPaintableTileEntity {
    private static int IO_MB_TICK = 100;
    @Store
    protected SmartTank tank;
    protected int lastUpdateLevel = -1;
    private boolean tankDirty = false;
    private int lastFluidLuminosity = 0;
    @Store
    private VoidMode voidMode = VoidMode.NEVER;
    private static long lastSendTickAll = -1L;
    private long nextSendTickThis = -1L;
    private int sendPrio = 0;

    public TileTank(int meta) {
        super(new SlotDefinition(0, 2, 3, 4, -1, -1));
        this.tank = meta == 1 ? new SmartTank(32000) : new SmartTank(16000);
    }

    public TileTank() {
        this(0);
    }

    @Override
    protected boolean doPush(@Nullable EnumFacing dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (dir == null || this.isSideDisabled(dir)) {
            return false;
        }
        boolean res = super.doPush(dir);
        if (this.tank.getFluidAmount() > 0 && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null && target.canFill(dir.func_176734_d(), this.tank.getFluid().getFluid())) {
            FluidStack push = this.tank.getFluid().copy();
            push.amount = Math.min(push.amount, IO_MB_TICK);
            int filled = target.fill(dir.func_176734_d(), push, true);
            if (filled > 0) {
                this.tank.drain(filled, true);
                this.tankDirty = true;
                return res;
            }
        }
        return res;
    }

    @Override
    protected boolean doPull(@Nullable EnumFacing dir) {
        BlockCoord loc;
        IFluidHandler target;
        if (dir == null || this.isSideDisabled(dir)) {
            return false;
        }
        boolean res = super.doPull(dir);
        if (this.tank.getFluidAmount() < this.tank.getCapacity() && (target = FluidUtil.getFluidHandler((IBlockAccess)this.field_145850_b, (BlockCoord)(loc = this.getLocation().getLocation(dir)))) != null) {
            if (this.tank.getFluidAmount() > 0) {
                FluidStack canPull = this.tank.getFluid().copy();
                canPull.amount = this.tank.getCapacity() - this.tank.getFluidAmount();
                canPull.amount = Math.min(canPull.amount, IO_MB_TICK);
                FluidStack drained = target.drain(dir.func_176734_d(), canPull, true);
                if (drained != null && drained.amount > 0) {
                    this.tank.fill(drained, true);
                    this.tankDirty = true;
                    return res;
                }
            } else {
                FluidTankInfo[] infos = target.getTankInfo(dir.func_176734_d());
                if (infos != null) {
                    for (FluidTankInfo info : infos) {
                        if (info.fluid == null || info.fluid.amount <= 0 || !this.canFill(dir, info.fluid.getFluid())) continue;
                        FluidStack canPull = info.fluid.copy();
                        canPull.amount = Math.min(IO_MB_TICK, canPull.amount);
                        FluidStack drained = target.drain(dir.func_176734_d(), canPull, true);
                        if (drained == null || drained.amount <= 0) continue;
                        this.tank.fill(drained, true);
                        this.tankDirty = true;
                        return res;
                    }
                }
            }
        }
        return res;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from)) {
            return 0;
        }
        return this.fillInternal(resource, doFill);
    }

    int fillInternal(FluidStack resource, boolean doFill) {
        int res = this.tank.fill(resource, doFill);
        if (res > 0 && doFill) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(resource, doDrain);
    }

    FluidStack drainInternal(FluidStack resource, boolean doDrain) {
        FluidStack res = this.tank.drain(resource, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (!this.canDrain(from)) {
            return null;
        }
        return this.drainInternal(maxDrain, doDrain);
    }

    FluidStack drainInternal(int maxDrain, boolean doDrain) {
        FluidStack res = this.tank.drain(maxDrain, doDrain);
        if (res != null && res.amount > 0 && doDrain) {
            this.tankDirty = true;
        }
        return res;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return this.canFill(from) && fluid != null && (this.tank.getFluidAmount() > 0 && FluidUtil.areFluidsTheSame((Fluid)this.tank.getFluid().getFluid(), (Fluid)fluid) || this.tank.getFluidAmount() == 0);
    }

    private boolean canFill(EnumFacing from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PUSH && mode != IoMode.DISABLED;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.canDrain(from) && this.tank.canDrainFluidType(fluid);
    }

    private boolean canDrain(EnumFacing from) {
        IoMode mode = this.getIoMode(from);
        return mode != IoMode.PULL && mode != IoMode.DISABLED;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    private int getFilledLevel() {
        int level = (int)Math.floor(16.0f * this.tank.getFilledRatio());
        if (level == 0 && this.tank.getFluidAmount() > 0) {
            level = 1;
        }
        return level;
    }

    public boolean canVoidItems() {
        return this.tank.getFluid() != null && this.tank.getFluid().getFluid().getTemperature() > 973;
    }

    public VoidMode getVoidMode() {
        return this.voidMode;
    }

    public void setVoidMode(VoidMode mode) {
        this.voidMode = mode;
    }

    @Override
    @Nonnull
    public String getMachineName() {
        return "tank";
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack item) {
        if (this.canVoidItems() && this.voidMode == VoidMode.ALWAYS && i < this.getSlotDefinition().getMaxInputSlot()) {
            return false;
        }
        if (i == 0) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item);
            if (fluid != null) {
                return true;
            }
            if (item.func_77973_b() == Items.field_151131_as) {
                return true;
            }
            if (item.func_77973_b() == Items.field_151129_at) {
                return true;
            }
            return item.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)item.func_77973_b()).getFluid(item) != null;
        }
        if (i == 1) {
            if (item.func_77973_b() instanceof IFluidContainerItem && (((IFluidContainerItem)item.func_77973_b()).getFluid(item) == null || ((IFluidContainerItem)item.func_77973_b()).getFluid((ItemStack)item).amount < ((IFluidContainerItem)item.func_77973_b()).getCapacity(item))) {
                return true;
            }
            return FluidContainerRegistry.isEmptyContainer((ItemStack)item) || item.func_77973_b() == Items.field_151133_ar;
        }
        if (i == 2 && this.canVoidItems()) {
            return this.voidMode == VoidMode.ALWAYS || this.voidMode != VoidMode.NEVER && !FluidContainerRegistry.isContainer((ItemStack)item);
        }
        return false;
    }

    @Override
    public void func_70299_a(int slot, @Nullable ItemStack contents) {
        super.func_70299_a(slot, contents);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    private boolean canSendClientUpdate() {
        long tick = EnderIO.proxy.getTickCount();
        if (this.nextSendTickThis > tick) {
            return false;
        }
        if (tick == lastSendTickAll && this.sendPrio++ < 200) {
            return false;
        }
        lastSendTickAll = tick;
        this.nextSendTickThis = lastSendTickAll + 10L + (long)(this.sendPrio * 2);
        this.sendPrio = 0;
        return true;
    }

    @Override
    protected boolean processTasks(boolean redstoneCheck) {
        this.processItems(redstoneCheck);
        int filledLevel = this.getFilledLevel();
        if (this.lastUpdateLevel != filledLevel) {
            this.lastUpdateLevel = filledLevel;
            this.tankDirty = true;
        }
        if (this.tankDirty && this.canSendClientUpdate()) {
            int thisFluidLuminosity;
            PacketHandler.sendToAllAround((IMessage)new PacketTankFluid(this), (TileEntity)this);
            this.field_145850_b.func_175666_e(this.field_174879_c, this.func_145838_q());
            int n = thisFluidLuminosity = this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null || this.tank.getFluidAmount() == 0 ? 0 : this.tank.getFluid().getFluid().getLuminosity(this.tank.getFluid());
            if (thisFluidLuminosity != this.lastFluidLuminosity) {
                this.field_145850_b.func_175664_x(this.func_174877_v());
                this.field_145850_b.markAndNotifyBlock(this.field_174879_c, this.field_145850_b.func_175726_f(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
                this.lastFluidLuminosity = thisFluidLuminosity;
            }
            this.tankDirty = false;
        }
        return false;
    }

    public int getComparatorOutput() {
        FluidTankInfo info = this.getTankInfo(null)[0];
        if (info == null || info.fluid == null) {
            return 0;
        }
        return info.fluid.amount == 0 ? 0 : (int)(1.0 + (double)info.fluid.amount / (double)info.capacity * 14.0);
    }

    private boolean processItems(boolean redstoneCheck) {
        if (!redstoneCheck) {
            return false;
        }
        if (!this.shouldDoWorkThisTick(20)) {
            return false;
        }
        if (this.canVoidItems()) {
            this.inventory[2] = null;
            this.func_70296_d();
        }
        return this.drainFullContainer() || this.fillEmptyContainer();
    }

    private boolean fillEmptyContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryFillContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot() + 1], (FluidStack)this.getOutputTanks()[0].getFluid());
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMaxOutputSlot();
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].func_77985_e() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].field_77994_a < this.inventory[slot].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[slot].field_77994_a;
            } else {
                return false;
            }
        }
        this.getOutputTanks()[0].setFluid(fill.remainder.fluidStack);
        this.func_70299_a(this.getSlotDefinition().getMinInputSlot() + 1, fill.remainder.itemStack);
        this.func_70299_a(slot, fill.result.itemStack);
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    private boolean drainFullContainer() {
        FluidUtil.FluidAndStackResult fill = FluidUtil.tryDrainContainer((ItemStack)this.inventory[this.getSlotDefinition().getMinInputSlot()], (ITankAccess)this);
        if (fill.result.fluidStack == null) {
            return false;
        }
        int slot = this.getSlotDefinition().getMinOutputSlot();
        if (this.inventory[slot] != null && fill.result.itemStack != null) {
            if (this.inventory[slot].func_77985_e() && ItemUtil.areStackMergable((ItemStack)this.inventory[slot], (ItemStack)fill.result.itemStack) && this.inventory[slot].field_77994_a < this.inventory[slot].func_77976_d()) {
                fill.result.itemStack.field_77994_a += this.inventory[slot].field_77994_a;
            } else {
                return false;
            }
        }
        this.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        this.func_70299_a(this.getSlotDefinition().getMinInputSlot(), fill.remainder.itemStack);
        if (fill.result.itemStack != null) {
            this.func_70299_a(slot, fill.result.itemStack);
        }
        this.setTanksDirty();
        this.func_70296_d();
        return false;
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.tank;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.tank};
    }

    public void setTanksDirty() {
        this.tankDirty = true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1 && this.tank.getFluidAmount() > 0;
    }
}

