/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.tank;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.CycleButton;
import com.google.common.collect.Lists;
import crazypants.enderio.EnderIO;
import crazypants.enderio.gui.IconEIO;
import java.util.List;
import java.util.Locale;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum VoidMode {
    ALWAYS,
    IF_NOT_CONTAINER,
    NEVER;


    @SideOnly(value=Side.CLIENT)
    public static enum IconHolder implements CycleButton.ICycleEnum
    {
        ALWAYS(ALWAYS, IconEIO.TICK),
        IF_NOT_CONTAINER(IF_NOT_CONTAINER, IconEIO.ITEM_SINGLE),
        NEVER(NEVER, IconEIO.CROSS);

        private final VoidMode mode;
        private final IWidgetIcon icon;
        private final List<String> unlocTooltips;

        private IconHolder(VoidMode mode, IWidgetIcon icon) {
            this.mode = mode;
            this.icon = icon;
            String prefix = "gui.void.mode";
            String str = prefix + "." + this.name().toLowerCase(Locale.US);
            this.unlocTooltips = Lists.newArrayList((Object[])new String[]{prefix, str, str + ".desc"});
        }

        public IWidgetIcon getIcon() {
            return this.icon;
        }

        public List<String> getTooltipLines() {
            return EnderIO.lang.localizeAll(this.unlocTooltips);
        }

        public VoidMode getMode() {
            return this.mode;
        }

        public static IconHolder getFromMode(VoidMode mode) {
            for (IconHolder holder : IconHolder.values()) {
                if (holder.mode != mode) continue;
                return holder;
            }
            return NEVER;
        }
    }
}

