/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.IconButton;
import com.enderio.core.client.gui.widget.GuiToolTip;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.RenderUtil;
import crazypants.enderio.EnderIO;
import crazypants.enderio.fluid.Fluids;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.vat.ContainerVat;
import crazypants.enderio.machine.vat.PacketDumpTank;
import crazypants.enderio.machine.vat.TileVat;
import crazypants.enderio.machine.vat.VatRecipeManager;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.IOException;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiVat
extends GuiPoweredMachineBase<TileVat> {
    private static final String GUI_TEXTURE = "vat";
    private final IconButton dump1;
    private final IconButton dump2;

    public GuiVat(InventoryPlayer inventory, TileVat te) {
        super(te, (Container)new ContainerVat(inventory, te), GUI_TEXTURE);
        this.addToolTip(new GuiToolTip(new Rectangle(30, 12, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("vat.inputTank");
                if (((TileVat)((GuiVat)GuiVat.this).getTileEntity()).inputTank.getFluid() != null) {
                    heading = heading + ": " + ((TileVat)((GuiVat)GuiVat.this).getTileEntity()).inputTank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileVat)((GuiVat)GuiVat.this).getTileEntity()).inputTank));
            }
        });
        this.addToolTip(new GuiToolTip(new Rectangle(132, 12, 15, 47), new String[]{""}){

            protected void updateText() {
                this.text.clear();
                String heading = EnderIO.lang.localize("vat.outputTank");
                if (((TileVat)((GuiVat)GuiVat.this).getTileEntity()).outputTank.getFluid() != null) {
                    heading = heading + ": " + ((TileVat)((GuiVat)GuiVat.this).getTileEntity()).outputTank.getFluid().getLocalizedName();
                }
                this.text.add(heading);
                this.text.add(Fluids.toCapactityString((IFluidTank)((TileVat)((GuiVat)GuiVat.this).getTileEntity()).outputTank));
            }
        });
        this.dump1 = new IconButton((IGuiScreen)this, 1, 29, 62, (IWidgetIcon)IconEIO.DUMP_LIQUID);
        this.dump1.setToolTip(new String[]{EnderIO.lang.localize("gui.machine.vat.dump.1")});
        this.dump2 = new IconButton((IGuiScreen)this, 2, 131, 62, (IWidgetIcon)IconEIO.VOID_LIQUID);
        this.dump2.setToolTip(new String[]{EnderIO.lang.localize("gui.machine.vat.dump.2")});
        this.addProgressTooltip(81, 63, 14, 14);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.dump1.onGuiInit();
        this.dump2.onGuiInit();
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        super.renderSlotHighlights(mode);
        int x = 30;
        int y = 12;
        if (mode == IoMode.PULL || mode == IoMode.PUSH_PULL) {
            this.renderSlotHighlight(PULL_COLOR, x - 2, y - 2, 19, 51);
        }
        if (mode == IoMode.PUSH || mode == IoMode.PUSH_PULL) {
            x = 132;
            this.renderSlotHighlight(PUSH_COLOR, x - 2, y - 2, 19, 51);
        }
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        String str;
        float mult;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        TileVat vat = (TileVat)this.getTileEntity();
        if (this.shouldRenderProgress()) {
            int scaled = this.getProgressScaled(14) + 1;
            this.func_73729_b(this.field_147003_i + 81, this.field_147009_r + 77 - scaled, 176, 14 - scaled, 14, scaled);
            TextureAtlasSprite inputIcon = null;
            if (vat.currentTaskInputFluid != null) {
                inputIcon = RenderUtil.getStillTexture((Fluid)vat.currentTaskInputFluid);
            }
            TextureAtlasSprite outputIcon = null;
            if (vat.currentTaskOutputFluid != null) {
                outputIcon = RenderUtil.getStillTexture((Fluid)vat.currentTaskOutputFluid);
            }
            if (inputIcon != null && outputIcon != null) {
                this.renderVat(inputIcon, outputIcon, vat.getProgress());
            }
        }
        int x = this.field_147003_i + 30;
        int y = this.field_147009_r + 12;
        RenderUtil.renderGuiTank((FluidTank)vat.inputTank, (double)x, (double)y, (double)this.field_73735_i, (double)15.0, (double)47.0);
        x = this.field_147003_i + 132;
        RenderUtil.renderGuiTank((FluidTank)vat.outputTank, (double)x, (double)y, (double)this.field_73735_i, (double)15.0, (double)47.0);
        Fluid outputFluid = vat.outputTank.getFluidAmount() > 0 ? vat.outputTank.getFluid().getFluid() : vat.currentTaskOutputFluid;
        Fluid inputFluid = vat.inputTank.getFluidAmount() > 0 ? vat.inputTank.getFluid().getFluid() : vat.currentTaskInputFluid;
        ItemStack inStack = vat.func_70301_a(0);
        if (inStack != null && (mult = VatRecipeManager.instance.getMultiplierForInput(inputFluid, inStack, outputFluid)) > 0.0f) {
            str = "x" + mult;
            x = this.field_147003_i + 63 - this.field_146289_q.func_78256_a(str) / 2;
            this.field_146289_q.func_175065_a(str, (float)x, (float)(this.field_147009_r + 32), ColorUtil.getRGB((Color)Color.gray), false);
        }
        if ((inStack = vat.func_70301_a(1)) != null && (mult = VatRecipeManager.instance.getMultiplierForInput(inputFluid, inStack, outputFluid)) > 0.0f) {
            str = "x" + mult;
            x = this.field_147003_i + 113 - this.field_146289_q.func_78256_a(str) / 2;
            this.field_146289_q.func_175065_a(str, (float)x, (float)(this.field_147009_r + 32), ColorUtil.getRGB((Color)Color.gray), false);
        }
        this.bindGuiTexture();
        super.func_146976_a(par1, par2, par3);
    }

    private void renderVat(TextureAtlasSprite inputIcon, TextureAtlasSprite outputIcon, float progress) {
        RenderUtil.bindBlockTexture();
        int x = this.field_147003_i + 76;
        int y = this.field_147009_r + 34;
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * (1.0f - progress)));
        this.func_175175_a(x, y, inputIcon, 26, 28);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.75f * progress));
        this.func_175175_a(x, y, outputIcon, 26, 28);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        this.func_73729_b(x, y, 0, 228, 26, 28);
    }

    protected void func_146284_a(GuiButton b) throws IOException {
        super.func_146284_a(b);
        if (b == this.dump1) {
            this.dump(1);
        } else if (b == this.dump2) {
            this.dump(2);
        }
    }

    private void dump(int i) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketDumpTank((TileVat)this.getTileEntity(), i));
    }

    @Override
    protected int getPowerX() {
        return 10;
    }

    @Override
    protected int getPowerY() {
        return 13;
    }

    @Override
    protected int getPowerHeight() {
        return 60;
    }
}

