/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.machine.vat.PacketTanks;
import crazypants.enderio.machine.vat.TileVat;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketDumpTank
extends MessageTileEntity<TileVat>
implements IMessageHandler<PacketDumpTank, IMessage> {
    private int tank;

    public PacketDumpTank() {
    }

    public PacketDumpTank(TileVat te, int tank) {
        super((TileEntity)te);
        this.tank = tank;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.tank);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.tank = buf.readInt();
    }

    public IMessage onMessage(PacketDumpTank message, MessageContext ctx) {
        TileVat te = (TileVat)message.getTileEntity(ctx.getServerHandler().field_147369_b.field_70170_p);
        if (te != null) {
            if (message.tank == 2) {
                te.outputTank.setFluid(null);
            } else if (!te.inputTank.isEmpty()) {
                if (te.isActive()) {
                    ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.gui.machine.vat.dump.active", new Object[0]));
                } else if (te.outputTank.isEmpty()) {
                    te.outputTank.setFluid(te.inputTank.getFluid());
                    te.inputTank.setFluid(null);
                } else if (te.outputTank.getFluid().isFluidEqual(te.inputTank.getFluid()) && te.outputTank.getAvailableSpace() > 0) {
                    FluidStack drain = te.inputTank.drain(te.outputTank.getAvailableSpace(), true);
                    te.outputTank.fill(drain, true);
                } else {
                    ctx.getServerHandler().field_147369_b.func_145747_a((ITextComponent)new TextComponentTranslation("enderio.gui.machine.vat.dump.fail", new Object[0]));
                }
            }
            te.func_70296_d();
            return new PacketTanks(te);
        }
        return null;
    }
}

