/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import com.enderio.core.common.network.MessageTileEntity;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.PoweredTaskProgress;
import crazypants.enderio.machine.vat.TileVat;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketVatProgress
extends MessageTileEntity<TileVat>
implements IMessageHandler<PacketVatProgress, IMessage> {
    private float progress = 0.0f;
    private String inputFluidId = null;
    private String outputFluidId = null;

    public PacketVatProgress() {
    }

    public PacketVatProgress(TileVat vat) {
        super((TileEntity)vat);
        IMachineRecipe rec;
        this.progress = vat.getProgress();
        IPoweredTask task = vat.getCurrentTask();
        if (task == null) {
            return;
        }
        for (MachineRecipeInput input : task.getInputs()) {
            if (input.fluid == null || input.fluid.getFluid() == null) continue;
            this.inputFluidId = input.fluid.getFluid().getName();
            break;
        }
        if ((rec = task.getRecipe()) == null) {
            return;
        }
        for (IMachineRecipe.ResultStack res : rec.getCompletedResult(1.0f, task.getInputs())) {
            if (res.fluid == null || res.fluid.getFluid() == null) continue;
            this.outputFluidId = res.fluid.getFluid().getName();
        }
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeFloat(this.progress);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.inputFluidId == null ? "" : this.inputFluidId));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)(this.outputFluidId == null ? "" : this.outputFluidId));
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.progress = buf.readFloat();
        this.inputFluidId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (this.inputFluidId.isEmpty()) {
            this.inputFluidId = null;
        }
        this.outputFluidId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (this.outputFluidId.isEmpty()) {
            this.outputFluidId = null;
        }
    }

    public IMessage onMessage(PacketVatProgress message, MessageContext ctx) {
        TileVat tile = (TileVat)message.getTileEntity(EnderIO.proxy.getClientWorld());
        if (tile != null) {
            tile.currentTaskInputFluid = null;
            tile.currentTaskOutputFluid = null;
            if (message.progress < 0.0f) {
                tile.setClientTask(null);
            } else {
                tile.setClientTask(new PoweredTaskProgress(message.progress));
                if (message.inputFluidId != null) {
                    tile.currentTaskInputFluid = FluidRegistry.getFluid((String)message.inputFluidId);
                }
                if (message.outputFluidId != null) {
                    tile.currentTaskOutputFluid = FluidRegistry.getFluid((String)message.outputFluidId);
                }
            }
        }
        return null;
    }
}

