/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import com.enderio.core.api.client.gui.IAdvancedTooltipProvider;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.IHaveRenderers;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.BlockItemIngotStorage;
import crazypants.util.ClientUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIngotStorage
extends BlockEio<TileEntityEio>
implements IAdvancedTooltipProvider,
IHaveRenderers {
    public static final PropertyEnum<Alloy> VARIANT = PropertyEnum.func_177709_a((String)"variant", Alloy.class);

    public static BlockIngotStorage create() {
        BlockIngotStorage res = new BlockIngotStorage();
        res.init();
        return res;
    }

    private BlockIngotStorage() {
        super(ModObject.blockIngotStorage.getUnlocalisedName(), null, Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
    }

    protected ItemBlock createItemBlock() {
        return new BlockItemIngotStorage((Block)this, this.getName());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers() {
        Item item = Item.func_150898_a((Block)this);
        int numAlloys = Alloy.values().length;
        for (int i = 0; i < numAlloys; ++i) {
            ClientUtil.regRenderer(item, i, Alloy.values()[i].baseName + "Block");
        }
    }

    public int func_180651_a(IBlockState state) {
        Alloy enumColour = (Alloy)((Object)state.func_177229_b(VARIANT));
        return enumColour.ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        Alloy alloy = Alloy.values()[meta];
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)alloy));
    }

    public int func_176201_c(IBlockState state) {
        Alloy colour = (Alloy)((Object)state.func_177229_b(VARIANT));
        return colour.ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public float func_176195_g(IBlockState bs, World world, BlockPos pos) {
        return Alloy.values()[bs.func_177230_c().func_176201_c(bs)].getHardness();
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.func_176195_g(world.func_180495_p(pos), world, pos) * 2.0f;
    }

    public boolean isBeaconBase(IBlockAccess worldObj, BlockPos pos, BlockPos beacon) {
        return true;
    }

    @Override
    protected boolean shouldWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumFacing side) {
        return false;
    }

    public void addCommonEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
        list.add(EnderIO.lang.localize("tooltip.isBeaconBase"));
    }

    public void addBasicEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }

    public void addDetailedEntries(ItemStack itemstack, EntityPlayer entityplayer, List<String> list, boolean flag) {
    }
}

