/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.EnderIO;
import crazypants.enderio.material.Alloy;
import crazypants.enderio.material.MachinePart;
import crazypants.enderio.material.Material;
import crazypants.enderio.material.PowderIngot;
import crazypants.enderio.material.fusedQuartz.FusedQuartzType;
import crazypants.util.RecipeUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MaterialRecipes {
    public static void registerDependantOresInDictionary() {
        for (PowderIngot powder : PowderIngot.values()) {
            if (!powder.hasDependancy() || !powder.isDependancyMet()) continue;
            OreDictionary.registerOre((String)powder.oreDictName, (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, powder.ordinal()));
            powder.setRegistered();
        }
    }

    public static void registerOresInDictionary() {
        for (PowderIngot powderIngot : PowderIngot.values()) {
            if (powderIngot.hasDependancy()) continue;
            OreDictionary.registerOre((String)powderIngot.oreDictName, (ItemStack)new ItemStack((Item)EnderIO.itemPowderIngot, 1, powderIngot.ordinal()));
        }
        for (Enum enum_ : Alloy.values()) {
            for (String oreDictName : ((Alloy)enum_).getOreIngots()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackIngot());
            }
            for (String oreDictName : ((Alloy)enum_).getOreBlocks()) {
                OreDictionary.registerOre((String)oreDictName, (ItemStack)((Alloy)enum_).getStackBlock());
            }
        }
        OreDictionary.registerOre((String)"nuggetPulsatingIron", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.PULSATING_IRON_NUGGET.ordinal()));
        OreDictionary.registerOre((String)"nuggetVibrantAlloy", (ItemStack)new ItemStack((Item)EnderIO.itemMaterial, 1, Material.VIBRANT_NUGGET.ordinal()));
        ItemStack pureGlass = new ItemStack((Block)EnderIO.blockFusedQuartz, 1, FusedQuartzType.FUSED_GLASS.ordinal());
        OreDictionary.registerOre((String)"blockGlass", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassColorless", (ItemStack)pureGlass);
        OreDictionary.registerOre((String)"blockGlassHardened", (ItemStack)new ItemStack((Block)EnderIO.blockFusedQuartz, 1, FusedQuartzType.FUSED_QUARTZ.ordinal()));
        ItemStack skull = new ItemStack(Items.field_151144_bL, 1, Short.MAX_VALUE);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)skull);
        OreDictionary.registerOre((String)"itemSkull", (ItemStack)new ItemStack((Block)EnderIO.blockEndermanSkull));
        Material.registerOres(EnderIO.itemMaterial);
        MachinePart.registerOres(EnderIO.itemMachinePart);
    }

    public static void addRecipes() {
        for (Alloy alloy : Alloy.values()) {
            RecipeUtil.addShaped(alloy.getStackBlock(), "iii", "iii", "iii", Character.valueOf('i'), alloy.getOreIngot());
            RecipeUtil.addShapeless(alloy.getStackIngot(9), alloy.getOreBlock());
        }
    }
}

