/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.paint;

import com.enderio.core.common.util.FluidUtil;
import com.google.common.base.Strings;
import crazypants.enderio.EnderIO;
import crazypants.enderio.paint.IPaintable;
import crazypants.util.NbtValue;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class PainterUtil2 {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValid(ItemStack paintSource, Block target) {
        boolean solidPaint = false;
        boolean textureOnly = false;
        if (paintSource != null) {
            Block block = PainterUtil2.getBlockFromItem(paintSource);
            IBlockState bs = block.func_176223_P();
            solidPaint = bs.func_185914_p();
            if (!PainterUtil2.shouldHaveModel(block)) {
                if (!PainterUtil2.shouldHaveTexture(block)) return false;
                textureOnly = true;
            } else if (block instanceof IPaintable && (bs = ((IPaintable)block).getPaintSource(block, paintSource)) != null) {
                return false;
            }
        }
        if (target == null) {
            if (paintSource == null) return false;
            return true;
        }
        if (paintSource == null) {
            return target instanceof IPaintable;
        }
        if (target instanceof IPaintable.ITexturePaintableBlock) {
            return true;
        }
        if (target instanceof IPaintable.ISolidBlockPaintableBlock) {
            if (!solidPaint) return false;
            if (textureOnly) return false;
            return true;
        }
        if (target instanceof IPaintable.INonSolidBlockPaintableBlock) {
            if (solidPaint) return false;
            if (textureOnly) return false;
            return true;
        }
        if (!(target instanceof IPaintable.IBlockPaintableBlock)) return false;
        if (textureOnly) return false;
        return true;
    }

    public static IBlockState rotate(IBlockState paintSource) {
        for (IProperty prop : paintSource.func_177227_a()) {
            if (!(prop instanceof PropertyDirection)) continue;
            PropertyDirection pd = (PropertyDirection)prop;
            return paintSource.func_177231_a((IProperty)pd);
        }
        if (paintSource.func_177230_c() instanceof BlockLog) {
            return paintSource.func_177231_a((IProperty)BlockLog.field_176299_a);
        }
        return paintSource;
    }

    public static void writeNbt(NBTTagCompound nbtRoot, IBlockState paintSource) {
        if (nbtRoot == null) {
            return;
        }
        if (paintSource == null) {
            NbtValue.SOURCE_BLOCK.removeTag(nbtRoot);
            NbtValue.SOURCE_META.removeTag(nbtRoot);
            return;
        }
        Block block = paintSource.func_177230_c();
        ResourceLocation res = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        String name = res.toString();
        if (!name.trim().isEmpty()) {
            NbtValue.SOURCE_BLOCK.setString(nbtRoot, name);
            NbtValue.SOURCE_META.setInt(nbtRoot, block.func_176201_c(paintSource));
        }
    }

    public static IBlockState readNbt(NBTTagCompound nbtRoot) {
        ResourceLocation res;
        String blockId;
        if (nbtRoot != null && !Strings.isNullOrEmpty((String)(blockId = NbtValue.SOURCE_BLOCK.getString(nbtRoot))) && Block.field_149771_c.func_148741_d((Object)(res = new ResourceLocation(blockId)))) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)res);
            int meta = NbtValue.SOURCE_META.getInt(nbtRoot);
            return block.func_176203_a(meta);
        }
        return null;
    }

    public static IBlockState getSourceBlock(ItemStack itemStack) {
        return PainterUtil2.readNbt(itemStack.func_77978_p());
    }

    public static void setSourceBlock(ItemStack itemStack, IBlockState paintSource) {
        if (itemStack == null) {
            return;
        }
        if (paintSource == null) {
            NbtValue.SOURCE_BLOCK.removeTag(itemStack);
            NbtValue.SOURCE_META.removeTag(itemStack);
            return;
        }
        Block block = paintSource.func_177230_c();
        ResourceLocation res = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        String name = res.toString();
        if (!name.trim().isEmpty()) {
            NbtValue.SOURCE_BLOCK.setString(itemStack, name);
            NbtValue.SOURCE_META.setInt(itemStack, block.func_176201_c(paintSource));
        }
    }

    public static String getTooltTipText(ItemStack itemStack) {
        String sourceName = "";
        IBlockState state = PainterUtil2.getSourceBlock(itemStack);
        if (state != null) {
            Block block = state.func_177230_c();
            Item itemFromBlock = Item.func_150898_a((Block)block);
            if (itemFromBlock != null) {
                ItemStack is = new ItemStack(itemFromBlock, 1, block.func_176201_c(state));
                sourceName = is.func_82833_r();
            }
        } else {
            return EnderIO.lang.localize("blockPainter.unpainted");
        }
        return EnderIO.lang.localize("blockPainter.paintedWith", new Object[]{sourceName});
    }

    public static boolean shouldHaveModel(Block block) {
        if (block == null) {
            return false;
        }
        return block.func_176223_P().func_185901_i() == EnumBlockRenderType.MODEL;
    }

    public static boolean shouldHaveTexture(Block block) {
        if (block == null) {
            return false;
        }
        EnumBlockRenderType rt = block.func_176223_P().func_185901_i();
        return rt != null && rt != EnumBlockRenderType.INVISIBLE;
    }

    public static Block getBlockFromItem(Item itemIn) {
        FluidStack fluidStack;
        if (itemIn instanceof ItemBlock) {
            return ((ItemBlock)itemIn).func_179223_d();
        }
        if (itemIn != null && (fluidStack = FluidUtil.getFluidFromItem((ItemStack)new ItemStack(itemIn))) != null) {
            return fluidStack.getFluid().getBlock();
        }
        return null;
    }

    public static Block getBlockFromItem(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.func_77973_b() instanceof ItemBlock) {
                return ((ItemBlock)itemStack.func_77973_b()).func_179223_d();
            }
            FluidStack fluidStack = FluidUtil.getFluidFromItem((ItemStack)itemStack);
            if (fluidStack != null && fluidStack.getFluid() != null) {
                return fluidStack.getFluid().getBlock();
            }
        }
        return null;
    }

    public static boolean canRenderInLayer(@Nullable IBlockState paintSource, BlockRenderLayer blockLayer) {
        if (paintSource != null) {
            return paintSource.func_177230_c().canRenderInLayer(paintSource, blockLayer);
        }
        return blockLayer == BlockRenderLayer.SOLID;
    }
}

