/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.power;

import cofh.api.energy.IEnergyConnection;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.power.CapBankPI;
import crazypants.enderio.power.IInternalPoweredTile;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerInterfaceRF;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class PowerHandlerUtil {
    @Nonnull
    public static final String STORED_ENERGY_NBT_KEY = "storedEnergyRF";

    public static IPowerInterface create(Object o) {
        if (o instanceof TileCapBank) {
            return new CapBankPI((TileCapBank)o);
        }
        if (o instanceof IEnergyConnection) {
            return new PowerInterfaceRF((IEnergyConnection)o);
        }
        return null;
    }

    public static int getStoredEnergyForItem(ItemStack item) {
        if (!item.func_77942_o()) {
            return 0;
        }
        NBTTagCompound tag = item.func_77978_p();
        if (tag.func_74764_b("storedEnergy")) {
            double storedMj = tag.func_74769_h("storedEnergy");
            return (int)(storedMj * 10.0);
        }
        return tag.func_74762_e(STORED_ENERGY_NBT_KEY);
    }

    public static void setStoredEnergyForItem(ItemStack item, int storedEnergy) {
        NBTTagCompound tag = item.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74768_a(STORED_ENERGY_NBT_KEY, storedEnergy);
        item.func_77982_d(tag);
    }

    public static int recieveInternal(IInternalPoweredTile target, int maxReceive, EnumFacing from, boolean simulate) {
        int result = Math.min(target.getMaxEnergyRecieved(from), maxReceive);
        result = Math.min(target.getMaxEnergyStored() - target.getEnergyStored(), result);
        if ((result = Math.max(0, result)) > 0 && !simulate) {
            target.setEnergyStored(target.getEnergyStored() + result);
        }
        return result;
    }
}

