/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import crazypants.enderio.Log;
import crazypants.enderio.paint.IPaintable;
import crazypants.enderio.paint.YetaUtil;
import crazypants.enderio.render.IBlockStateWrapper;
import crazypants.enderio.render.IOMode;
import crazypants.enderio.render.IRenderMapper;
import crazypants.enderio.render.pipeline.CacheKey;
import crazypants.enderio.render.pipeline.CollectedQuadBakedBlockModel;
import crazypants.enderio.render.pipeline.OverlayHolder;
import crazypants.enderio.render.pipeline.PaintWrangler;
import crazypants.enderio.render.pipeline.QuadCollector;
import crazypants.util.Profiler;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateWrapperBase
extends CacheKey
implements IBlockStateWrapper {
    private static final Cache<Pair<Block, Long>, QuadCollector> cache = CacheBuilder.newBuilder().maximumSize(500L).build();
    @Nonnull
    private final Block block;
    @Nonnull
    private final IBlockState state;
    @Nonnull
    private final IBlockAccess world;
    @Nonnull
    private final BlockPos pos;
    @Nonnull
    private final IRenderMapper.IBlockRenderMapper renderMapper;
    private boolean doCaching = false;
    private IBakedModel model = null;
    @Nonnull
    private static final IRenderMapper.IBlockRenderMapper nullRenderMapper = new IRenderMapper.IBlockRenderMapper(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public EnumMap<EnumFacing, IOMode.EnumIOMode> mapOverlayLayer(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, boolean isPainted) {
            return null;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public List<IBlockState> mapBlockRender(IBlockStateWrapper state, IBlockAccess world, BlockPos pos, BlockRenderLayer blockLayer, QuadCollector quadCollector) {
            return null;
        }
    };

    protected static Cache<Pair<Block, Long>, QuadCollector> getCache() {
        return cache;
    }

    public BlockStateWrapperBase(IBlockState state, IBlockAccess world, BlockPos pos, IRenderMapper.IBlockRenderMapper renderMapper) {
        this.state = BlockStateWrapperBase.notnull(state);
        this.block = BlockStateWrapperBase.notnull(state.func_177230_c());
        this.world = BlockStateWrapperBase.notnull(world);
        this.pos = BlockStateWrapperBase.notnull(pos);
        this.renderMapper = renderMapper != null ? renderMapper : nullRenderMapper;
    }

    @Nonnull
    private static <X> X notnull(@Nullable X x) {
        if (x == null) {
            throw new NullPointerException();
        }
        return x;
    }

    protected BlockStateWrapperBase(BlockStateWrapperBase parent, IBlockState state) {
        this.block = parent.block;
        this.state = BlockStateWrapperBase.notnull(state);
        this.world = parent.world;
        this.pos = parent.pos;
        this.renderMapper = parent.renderMapper;
        this.doCaching = parent.doCaching;
        this.model = parent.model;
    }

    public static void invalidate() {
        BlockStateWrapperBase.getCache().invalidateAll();
    }

    public Collection<IProperty<?>> func_177227_a() {
        return this.state.func_177227_a();
    }

    public <T extends Comparable<T>> T func_177229_b(IProperty<T> property) {
        return (T)this.state.func_177229_b(property);
    }

    public <T extends Comparable<T>, V extends T> IBlockState func_177226_a(IProperty<T> property, V value) {
        return new BlockStateWrapperBase(this, this.state.func_177226_a(property, value));
    }

    public <T extends Comparable<T>> IBlockState func_177231_a(IProperty<T> property) {
        return new BlockStateWrapperBase(this, this.state.func_177231_a(property));
    }

    public ImmutableMap<IProperty<?>, Comparable<?>> func_177228_b() {
        return this.state.func_177228_b();
    }

    @Nonnull
    public Block func_177230_c() {
        return this.block;
    }

    @Override
    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.world.func_175625_s(this.pos);
    }

    @Override
    @Nonnull
    public IBlockAccess getWorld() {
        return this.world;
    }

    @Override
    @Nonnull
    public IBlockState getState() {
        return this.state;
    }

    @Override
    @Nonnull
    public IBlockStateWrapper addCacheKey(@Nullable Object addlCacheKey) {
        super.addCacheKey(addlCacheKey);
        this.doCaching = true;
        return this;
    }

    @Override
    public void bakeModel() {
        String cacheResult;
        long start = Profiler.client.start();
        QuadCollector quads = null;
        IBlockState rawPaintSource = null;
        IBlockState paintSource = null;
        if (!(!(this.block instanceof IPaintable.IBlockPaintableBlock) || this.block instanceof IPaintable.IWrenchHideablePaint && YetaUtil.shouldHeldItemHideFacades())) {
            rawPaintSource = PaintWrangler.getActualBlockState(this.world, this.pos, ((IPaintable.IBlockPaintableBlock)this.block).getPaintSource(this.state, this.world, this.pos));
            paintSource = PaintWrangler.getDynamicBlockState(this.world, this.pos, rawPaintSource);
        }
        if (this.doCaching) {
            if (paintSource != null) {
                this.addCacheKeyInternal(paintSource);
            }
            cacheResult = (quads = (QuadCollector)BlockStateWrapperBase.getCache().getIfPresent((Object)Pair.of((Object)this.block, (Object)this.getCacheKey()))) == null ? "miss" : "hit";
        } else {
            cacheResult = "not cachable";
        }
        if (quads == null) {
            quads = new QuadCollector();
            if (!this.bakePaintLayer(quads, rawPaintSource, paintSource)) {
                this.bakeBlockLayer(quads);
                paintSource = null;
            } else if (this.renderMapper instanceof IRenderMapper.IBlockRenderMapper.IRenderLayerAware.IPaintAware) {
                this.bakeBlockLayer(quads);
            }
            if (this.doCaching) {
                BlockStateWrapperBase.getCache().put((Object)Pair.of((Object)this.block, (Object)this.getCacheKey()), (Object)quads);
            }
        }
        this.model = new CollectedQuadBakedBlockModel(quads.combine(OverlayHolder.getOverlay(this.renderMapper.mapOverlayLayer(this, this.world, this.pos, paintSource != null))));
        Profiler.client.stop(start, this.state.func_177230_c().func_149732_F() + " (bake, cache=" + cacheResult + ")");
    }

    protected void bakeBlockLayer(QuadCollector quads) {
        if (this.renderMapper instanceof IRenderMapper.IBlockRenderMapper.IRenderLayerAware) {
            for (BlockRenderLayer layer : quads.getBlockLayers()) {
                quads.addFriendlyBlockStates(layer, this.renderMapper.mapBlockRender(this, this.world, this.pos, layer, quads));
            }
        } else {
            BlockRenderLayer layer = this.block.func_180664_k();
            quads.addFriendlyBlockStates(layer, this.renderMapper.mapBlockRender(this, this.world, this.pos, layer, quads));
        }
    }

    protected boolean bakePaintLayer(QuadCollector quads, IBlockState rawPaintSource, IBlockState paintSource) {
        if (paintSource != null) {
            BlockRenderLayer oldRenderLayer = MinecraftForgeClient.getRenderLayer();
            boolean rendered = true;
            for (BlockRenderLayer layer : quads.getBlockLayers()) {
                if (!paintSource.func_177230_c().canRenderInLayer(paintSource, layer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)layer);
                rendered = rendered && PaintWrangler.wrangleBakedModel(this.world, this.pos, rawPaintSource, paintSource, quads);
            }
            ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldRenderLayer);
            return rendered;
        }
        return false;
    }

    protected IBakedModel getModel() {
        if (this.model == null) {
            this.bakeModel();
            if (this.model != null) {
                Log.warn(this.block + " doesn't bake its model!");
            } else {
                Log.warn(this.block + "'s model won't bake!");
                return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
        }
        return this.model;
    }

    public Material func_185904_a() {
        return this.state.func_185904_a();
    }

    public boolean func_185913_b() {
        return this.state.func_185913_b();
    }

    public int func_185891_c() {
        return this.state.func_185891_c();
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        return this.state.getLightOpacity(world, pos);
    }

    public int func_185906_d() {
        return this.state.func_185906_d();
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return this.state.getLightValue(world, pos);
    }

    public boolean func_185895_e() {
        return this.state.func_185895_e();
    }

    public boolean func_185916_f() {
        return this.state.func_185916_f();
    }

    public MapColor func_185909_g() {
        return this.state.func_185909_g();
    }

    public IBlockState func_185907_a(Rotation rot) {
        return this.state.func_185907_a(rot);
    }

    public IBlockState func_185902_a(Mirror mirrorIn) {
        return this.state.func_185902_a(mirrorIn);
    }

    public boolean func_185917_h() {
        return this.state.func_185917_h();
    }

    public EnumBlockRenderType func_185901_i() {
        return this.state.func_185901_i();
    }

    public int func_185889_a(IBlockAccess source, BlockPos pos) {
        return this.state.func_185889_a(source, pos);
    }

    public float func_185892_j() {
        return this.state.func_185892_j();
    }

    public boolean func_185898_k() {
        return this.state.func_185898_k();
    }

    public boolean func_185915_l() {
        return this.state.func_185915_l();
    }

    public boolean func_185897_m() {
        return this.state.func_185897_m();
    }

    public int func_185911_a(IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.state.func_185911_a(blockAccess, pos, side);
    }

    public boolean func_185912_n() {
        return this.state.func_185912_n();
    }

    public int func_185888_a(World worldIn, BlockPos pos) {
        return this.state.func_185888_a(worldIn, pos);
    }

    public float func_185887_b(World worldIn, BlockPos pos) {
        return this.state.func_185887_b(worldIn, pos);
    }

    public float func_185903_a(EntityPlayer player, World worldIn, BlockPos pos) {
        return this.state.func_185903_a(player, worldIn, pos);
    }

    public int func_185893_b(IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.state.func_185893_b(blockAccess, pos, side);
    }

    public EnumPushReaction func_185905_o() {
        return this.state.func_185905_o();
    }

    public IBlockState func_185899_b(IBlockAccess blockAccess, BlockPos pos) {
        return this.state.func_185899_b(blockAccess, pos);
    }

    public AxisAlignedBB func_185890_d(World worldIn, BlockPos pos) {
        return this.state.func_185890_d(worldIn, pos);
    }

    public boolean func_185894_c(IBlockAccess blockAccess, BlockPos pos, EnumFacing facing) {
        return this.state.func_185894_c(blockAccess, pos, facing);
    }

    public boolean func_185914_p() {
        return this.state.func_185914_p();
    }

    public AxisAlignedBB func_185918_c(World worldIn, BlockPos pos) {
        return this.state.func_185918_c(worldIn, pos);
    }

    public void func_185908_a(World worldIn, BlockPos pos, AxisAlignedBB p_185908_3_, List<AxisAlignedBB> p_185908_4_, @Nullable Entity p_185908_5_) {
        this.state.func_185908_a(worldIn, pos, p_185908_3_, p_185908_4_, p_185908_5_);
    }

    public AxisAlignedBB func_185900_c(IBlockAccess blockAccess, BlockPos pos) {
        return this.state.func_185900_c(blockAccess, pos);
    }

    public RayTraceResult func_185910_a(World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        return this.state.func_185910_a(worldIn, pos, start, end);
    }

    public boolean func_185896_q() {
        return this.state.func_185896_q();
    }

    public boolean doesSideBlockRendering(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.doesSideBlockRendering(world, pos, side);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.state.isSideSolid(world, pos, side);
    }

    public boolean func_189547_a(World worldIn, BlockPos pos, int id, int param) {
        return this.state.func_189547_a(worldIn, pos, id, param);
    }

    public void func_189546_a(World worldIn, BlockPos pos, Block p_189546_3_) {
        this.state.func_189546_a(worldIn, pos, p_189546_3_);
    }
}

