/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.render.pipeline;

import crazypants.enderio.render.pipeline.BlockStateWrapperBase;
import crazypants.enderio.render.pipeline.CollectedQuadBakedBlockModel;
import crazypants.enderio.render.pipeline.EnderItemOverrideList;
import crazypants.util.Profiler;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class RelayingBakedModel
implements IPerspectiveAwareModel {
    private IBakedModel defaults;

    private IBakedModel getDefaults() {
        if (this.defaults == null) {
            try {
                this.defaults = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.defaults;
    }

    public RelayingBakedModel(IBakedModel defaults) {
        this.defaults = defaults;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        long start = Profiler.client.start();
        if (state instanceof BlockStateWrapperBase) {
            IBakedModel model = ((BlockStateWrapperBase)state).getModel();
            if (model instanceof CollectedQuadBakedBlockModel) {
                ((CollectedQuadBakedBlockModel)model).setParticleTexture(this.func_177554_e());
            }
            if (model != null) {
                Profiler.client.stop(start, state.func_177230_c().func_149732_F() + " (relayed)");
                return model.func_188616_a(state, side, rand);
            }
        }
        return this.getDefaults().func_188616_a(state, side, rand);
    }

    public boolean func_177555_b() {
        return this.getDefaults().func_177555_b();
    }

    public boolean func_177556_c() {
        return this.getDefaults().func_177556_c();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.getDefaults().func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return EnderItemOverrideList.instance;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.getDefaults() instanceof IPerspectiveAwareModel) {
            Pair perspective = ((IPerspectiveAwareModel)this.getDefaults()).handlePerspective(cameraTransformType);
            return Pair.of((Object)this, (Object)perspective.getRight());
        }
        return Pair.of((Object)this, null);
    }
}

