/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.client.gui.button.CheckBox;
import com.enderio.core.client.gui.widget.TextFieldEnder;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.EnderIO;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.packet.PacketAccessMode;
import crazypants.enderio.teleport.packet.PacketLabel;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiTravelAccessable
extends GuiContainerBaseEIO {
    private static final int ID_PUBLIC = 0;
    private static final int ID_PRIVATE = 1;
    private static final int ID_PROTECTED = 2;
    private CheckBox publicCB;
    private CheckBox privateCB;
    private CheckBox protectedCB;
    private TextFieldEnder tf;
    private String publicStr;
    private String privateStr;
    private String protectedStr;
    private ITravelAccessable te;
    private int col0x;
    private int col1x;
    private int col2x;
    protected World world;

    public GuiTravelAccessable(InventoryPlayer playerInv, ITravelAccessable te, World world) {
        this(new ContainerTravelAccessable(playerInv, te, world));
    }

    public GuiTravelAccessable(ContainerTravelAccessable container) {
        super((Container)container, "travelAccessable");
        this.te = container.ta;
        this.world = container.world;
        this.publicStr = EnderIO.lang.localize("gui.travelAccessable.public");
        this.privateStr = EnderIO.lang.localize("gui.travelAccessable.private");
        this.protectedStr = EnderIO.lang.localize("gui.travelAccessable.protected");
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        this.tf = new TextFieldEnder(fr, 28, 10, 90, 16);
        this.col1x = 88;
        this.col0x = (this.col1x - fr.func_78256_a(this.protectedStr) / 2) / 2;
        this.col2x = this.col1x + fr.func_78256_a(this.protectedStr) / 2;
        this.col2x += (176 - this.col2x) / 2;
        int x = 0;
        int y = 50;
        x = this.col0x - 8;
        this.privateCB = new CheckBox((IGuiScreen)this, 1, x, y);
        this.privateCB.setSelected(this.te.getAccessMode() == ITravelAccessable.AccessMode.PRIVATE);
        x = this.col1x - 8;
        this.protectedCB = new CheckBox((IGuiScreen)this, 2, x, y);
        this.protectedCB.setSelected(this.te.getAccessMode() == ITravelAccessable.AccessMode.PROTECTED);
        x = this.col2x - 8;
        this.publicCB = new CheckBox((IGuiScreen)this, 0, x, y);
        this.publicCB.setSelected(this.te.getAccessMode() == ITravelAccessable.AccessMode.PUBLIC);
        this.field_147000_g = 185;
        this.textFields.add(this.tf);
    }

    protected void func_146284_a(GuiButton b) {
        this.privateCB.setSelected(b.field_146127_k == 1);
        this.protectedCB.setSelected(b.field_146127_k == 2);
        this.publicCB.setSelected(b.field_146127_k == 0);
        ITravelAccessable.AccessMode curMode = b.field_146127_k == 1 ? ITravelAccessable.AccessMode.PRIVATE : (b.field_146127_k == 2 ? ITravelAccessable.AccessMode.PROTECTED : ITravelAccessable.AccessMode.PUBLIC);
        this.te.setAccessMode(curMode);
        BlockCoord bc = this.te.getLocation();
        PacketAccessMode p = new PacketAccessMode(bc.x, bc.y, bc.z, curMode);
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.publicCB.setPaintSelectedBorder(false);
        this.publicCB.onGuiInit();
        this.privateCB.onGuiInit();
        this.protectedCB.onGuiInit();
        this.tf.func_146203_f(32);
        this.tf.func_146195_b(true);
        String txt = this.te.getLabel();
        if (txt != null && txt.length() > 0) {
            this.tf.func_146180_a(txt);
        }
        ((ContainerTravelAccessable)this.field_147002_h).addGhostSlots(this.getGhostSlots());
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_73864_a(int x, int y, int par3) throws IOException {
        super.func_73864_a(x, y, par3);
    }

    public void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindGuiTexture();
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        int col = ColorUtil.getRGB((Color)Color.white);
        int x = sx;
        int y = sy + 38;
        FontRenderer fontRenderer = this.getFontRenderer();
        x = sx + this.col0x - fontRenderer.func_78256_a(this.privateStr) / 2;
        fontRenderer.func_175063_a(this.privateStr, (float)x, (float)y, col);
        x = sx + this.col1x - fontRenderer.func_78256_a(this.protectedStr) / 2;
        fontRenderer.func_175063_a(this.protectedStr, (float)x, (float)y, col);
        x = sx + this.col2x - fontRenderer.func_78256_a(this.publicStr) / 2;
        fontRenderer.func_175063_a(this.publicStr, (float)x, (float)y, col);
        this.checkLabelForChange();
        super.func_146976_a(f, i, j);
    }

    private void checkLabelForChange() {
        String curText;
        String newTxt = this.tf.func_146179_b();
        if (newTxt != null && newTxt.length() == 0) {
            newTxt = null;
        }
        if ((curText = this.te.getLabel()) != null && curText.length() == 0) {
            curText = null;
        }
        boolean changed = false;
        if (newTxt == null) {
            changed = curText != null;
        } else {
            boolean bl = changed = !newTxt.equals(curText);
        }
        if (!changed) {
            return;
        }
        this.te.setLabel(newTxt);
        BlockCoord bc = this.te.getLocation();
        PacketLabel p = new PacketLabel(bc.x, bc.y, bc.z, this.te.getLabel());
        PacketHandler.INSTANCE.sendToServer((IMessage)p);
    }

    protected void drawForegroundImpl(int mouseX, int mouseY) {
        super.drawForegroundImpl(mouseX, mouseY);
        if (this.te.getAccessMode() != ITravelAccessable.AccessMode.PROTECTED) {
            this.bindGuiTexture();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)2929);
            this.func_73729_b(43, 72, 5, 35, 90, 18);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
    }
}

