/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.api.teleport.TravelSource;
import crazypants.enderio.teleport.TravelController;
import crazypants.enderio.teleport.anchor.BlockTravelAnchor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

@SideOnly(value=Side.CLIENT)
public class TravelEntitySpecialRenderer
extends TileEntitySpecialRenderer<TileEntity> {
    private final Vector4f selectedColor;
    private final Vector4f highlightColor;
    private EntityItem ei;

    public TravelEntitySpecialRenderer() {
        this(new Vector4f(1.0f, 0.25f, 0.0f, 0.5f), new Vector4f(1.0f, 1.0f, 1.0f, 0.25f));
    }

    public TravelEntitySpecialRenderer(Vector4f selectedColor, Vector4f highlightColor) {
        this.selectedColor = selectedColor;
        this.highlightColor = highlightColor;
    }

    public void func_180535_a(TileEntity tileentity, double x, double y, double z, float f, int destroyStage) {
        double maxDistance;
        if (!TravelController.instance.showTargets()) {
            return;
        }
        ITravelAccessable ta = (ITravelAccessable)tileentity;
        BlockCoord onBlock = TravelController.instance.onBlockCoord;
        if (onBlock != null && onBlock.equals((Object)ta.getLocation())) {
            return;
        }
        if (!ta.canSeeBlock((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        Vector3d eye = Util.getEyePositionEio((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        Vector3d loc = new Vector3d((double)tileentity.func_174877_v().func_177958_n() + 0.5, (double)tileentity.func_174877_v().func_177956_o() + 0.5, (double)tileentity.func_174877_v().func_177952_p() + 0.5);
        double d = maxDistance = TravelController.instance.isTravelItemActiveForRendering((EntityPlayer)Minecraft.func_71410_x().field_71439_g) ? (double)TravelSource.STAFF.getMaxDistanceTravelledSq() : (double)TravelSource.BLOCK.getMaxDistanceTravelledSq();
        if (eye.distanceSquared(loc) > maxDistance) {
            return;
        }
        double sf = TravelController.instance.getScaleForCandidate(loc);
        BlockCoord bc = new BlockCoord(tileentity);
        TravelController.instance.addCandidate(bc);
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderUtil.bindBlockTexture();
        GL11.glPushAttrib((int)8192);
        GL11.glPushAttrib((int)64);
        GL11.glEnable((int)32826);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glEnable((int)2884);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        this.renderBlock((IBlockAccess)tileentity.func_145831_w(), sf);
        if (TravelController.instance.isBlockSelected(bc)) {
            GlStateManager.func_179131_c((float)this.selectedColor.x, (float)this.selectedColor.y, (float)this.selectedColor.z, (float)this.selectedColor.w);
            RenderUtil.renderBoundingBox((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf + 0.05, sf + 0.05, sf + 0.05), (TextureAtlasSprite)this.getSelectedIcon());
        } else {
            GlStateManager.func_179131_c((float)this.highlightColor.x, (float)this.highlightColor.y, (float)this.highlightColor.z, (float)this.highlightColor.w);
            RenderUtil.renderBoundingBox((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf + 0.05, sf + 0.05, sf + 0.05), (TextureAtlasSprite)this.getHighlightIcon());
        }
        GL11.glPopMatrix();
        this.renderLabel(tileentity, x, y, z, ta, sf);
        GL11.glPopAttrib();
        GL11.glPopAttrib();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    private void renderLabel(TileEntity tileentity, double x, double y, double z, ITravelAccessable ta, double sf) {
        String toRender;
        float globalScale = (float)sf;
        ItemStack itemLabel = ta.getItemLabel();
        if (itemLabel != null && itemLabel.func_77973_b() != null) {
            boolean isBlock = itemLabel.func_77973_b() instanceof ItemBlock;
            GL11.glBlendFunc((int)770, (int)32769);
            float col = 0.5f;
            GL14.glBlendColor((float)col, (float)col, (float)col, (float)col);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            if (!isBlock && Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                RenderUtil.rotateToPlayer();
            }
            GL11.glPushMatrix();
            GL11.glScalef((float)globalScale, (float)globalScale, (float)globalScale);
            GL11.glPushMatrix();
            if (isBlock) {
                GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
            }
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            if (this.ei == null) {
                this.ei = new EntityItem(tileentity.func_145831_w(), x, y, z, itemLabel);
            } else {
                this.ei.func_92058_a(itemLabel);
            }
            RenderUtil.render3DItem((EntityItem)this.ei, (boolean)false);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        if ((toRender = ta.getLabel()) != null && toRender.trim().length() > 0) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Vector4f bgCol = RenderUtil.DEFAULT_TEXT_BG_COL;
            if (TravelController.instance.isBlockSelected(new BlockCoord(tileentity))) {
                bgCol = new Vector4f(this.selectedColor.x, this.selectedColor.y, this.selectedColor.z, this.selectedColor.w);
            }
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
            GL11.glPushMatrix();
            GL11.glScalef((float)globalScale, (float)globalScale, (float)globalScale);
            Vector3f pos = new Vector3f(0.0f, 1.2f, 0.0f);
            float size = 0.5f;
            RenderUtil.drawBillboardedText((Vector3f)pos, (String)toRender, (float)size, (Vector4f)bgCol);
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
    }

    protected void renderBlock(IBlockAccess world, double sf) {
        RenderUtil.renderBoundingBox((BoundingBox)BoundingBox.UNIT_CUBE.scale(sf, sf, sf), (TextureAtlasSprite)this.getSelectedIcon());
    }

    public Vector4f getSelectedColor() {
        return this.selectedColor;
    }

    public TextureAtlasSprite getSelectedIcon() {
        return BlockTravelAnchor.selectedOverlayIcon.get(TextureAtlasSprite.class);
    }

    public Vector4f getHighlightColor() {
        return this.highlightColor;
    }

    public TextureAtlasSprite getHighlightIcon() {
        return BlockTravelAnchor.highlightOverlayIcon.get(TextureAtlasSprite.class);
    }
}

