/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.tool;

import crazypants.enderio.EnderIO;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.tool.IToolProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ToolUtil {
    private static ToolUtil instance;
    private final List<IToolProvider> toolProviders = new ArrayList<IToolProvider>();

    public static boolean isToolEquipped(EntityPlayer player, EnumHand hand) {
        return ToolUtil.getInstance().isToolEquippedImpl(player, hand);
    }

    public static ITool getEquippedTool(EntityPlayer player, EnumHand hand) {
        return ToolUtil.getInstance().getEquippedToolImpl(player, hand);
    }

    public static boolean breakBlockWithTool(Block block, World world, int x, int y, int z, EntityPlayer entityPlayer, EnumHand hand) {
        return ToolUtil.breakBlockWithTool(block, world, new BlockPos(x, y, z), entityPlayer, hand);
    }

    public static boolean breakBlockWithTool(Block block, World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand) {
        return ToolUtil.breakBlockWithTool(block, world, pos, entityPlayer, entityPlayer.func_184586_b(hand));
    }

    public static boolean breakBlockWithTool(Block block, World world, BlockPos pos, EntityPlayer entityPlayer, ItemStack heldItem) {
        ITool tool = ToolUtil.getToolFromStack(heldItem);
        if (tool != null && entityPlayer.func_70093_af() && tool.canUse(heldItem, entityPlayer, pos)) {
            IBlockState bs = world.func_180495_p(pos);
            if (block.removedByPlayer(bs, world, pos, entityPlayer, true)) {
                block.func_180657_a(world, entityPlayer, pos, world.func_180495_p(pos), world.func_175625_s(pos), heldItem);
            }
            tool.used(heldItem, entityPlayer, pos);
            return true;
        }
        return false;
    }

    public static ToolUtil getInstance() {
        if (instance == null) {
            instance = new ToolUtil();
        }
        return instance;
    }

    private ToolUtil() {
    }

    public void registerToolProvider(IToolProvider toolProvider) {
        this.toolProviders.add(toolProvider);
    }

    private boolean isToolEquippedImpl(EntityPlayer player, EnumHand hand) {
        return this.getEquippedToolImpl(player, hand) != null;
    }

    private ITool getEquippedToolImpl(EntityPlayer player, EnumHand hand) {
        EntityPlayer entityPlayer = player = player == null ? EnderIO.proxy.getClientPlayer() : player;
        if (player == null) {
            return null;
        }
        ItemStack equipped = player.func_184586_b(hand);
        return ToolUtil.getToolFromStack(equipped);
    }

    public static ITool getToolFromStack(ItemStack equipped) {
        if (equipped == null) {
            return null;
        }
        if (equipped.func_77973_b() instanceof ITool) {
            return (ITool)equipped.func_77973_b();
        }
        return ToolUtil.getInstance().getToolImpl(equipped);
    }

    private ITool getToolImpl(ItemStack equipped) {
        for (IToolProvider provider : this.toolProviders) {
            ITool result = provider.getTool(equipped);
            if (result == null) continue;
            return result;
        }
        return null;
    }
}

