/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.network.EnderPacketHandler;
import com.enderio.core.common.network.PacketProgress;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityBase
extends TileEntity
implements ITickable {
    private final int checkOffset = (int)(Math.random() * 20.0);
    protected final boolean isProgressTile = this instanceof IProgressTile;
    protected int lastProgressScaled = -1;
    protected int ticksSinceLastProgressUpdate;

    public final void func_73660_a() {
        this.doUpdate();
        if (this.isProgressTile && !this.field_145850_b.field_72995_K) {
            int curScaled = this.getProgressScaled(16);
            if (++this.ticksSinceLastProgressUpdate >= this.getProgressUpdateFreq() || curScaled != this.lastProgressScaled) {
                this.sendTaskProgressPacket();
                this.lastProgressScaled = curScaled;
            }
        }
    }

    public static int getProgressScaled(int scale, IProgressTile tile) {
        return (int)(tile.getProgress() * (float)scale);
    }

    public final int getProgressScaled(int scale) {
        if (this.isProgressTile) {
            return TileEntityBase.getProgressScaled(scale, (IProgressTile)((Object)this));
        }
        return 0;
    }

    protected void doUpdate() {
    }

    protected void sendTaskProgressPacket() {
        if (this.isProgressTile) {
            EnderPacketHandler.sendToAllAround(new PacketProgress((IProgressTile)((Object)this)), this);
        }
        this.ticksSinceLastProgressUpdate = 0;
    }

    protected int getProgressUpdateFreq() {
        return 20;
    }

    public final void func_145839_a(NBTTagCompound root) {
        super.func_145839_a(root);
        this.readCustomNBT(root);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound root) {
        super.func_189515_b(root);
        this.writeCustomNBT(root);
        return root;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return tag;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeCustomNBT(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public boolean canPlayerAccess(EntityPlayer player) {
        return !this.func_145837_r() && player.func_174831_c(this.func_174877_v().func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    protected abstract void writeCustomNBT(NBTTagCompound var1);

    protected abstract void readCustomNBT(NBTTagCompound var1);

    protected void updateBlock() {
        if (this.field_145850_b != null) {
            IBlockState bs = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.field_174879_c, bs, bs, 3);
        }
    }

    protected boolean isPoweredRedstone() {
        return this.field_145850_b.func_175667_e(this.func_174877_v()) ? this.field_145850_b.func_175676_y(this.func_174877_v()) > 0 : false;
    }

    public void init() {
    }

    protected boolean shouldDoWorkThisTick(int interval) {
        return this.shouldDoWorkThisTick(interval, 0);
    }

    protected boolean shouldDoWorkThisTick(int interval, int offset) {
        return (this.field_145850_b.func_82737_E() + (long)this.checkOffset + (long)offset) % (long)interval == 0L;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void setGhostSlotContents(int slot, ItemStack stack) {
    }

    public void func_70296_d() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_185912_n()) {
                this.field_145850_b.func_175666_e(this.field_174879_c, state.func_177230_c());
            }
        }
    }
}

