/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.enchant;

import com.enderio.core.EnderCore;
import com.enderio.core.api.common.enchant.IAdvancedEnchant;
import com.enderio.core.common.config.ConfigHandler;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class EnchantXPBoost
extends Enchantment
implements IAdvancedEnchant {
    private static EnchantXPBoost INSTANCE;

    @Nullable
    public static EnchantXPBoost instance() {
        return INSTANCE;
    }

    private EnchantXPBoost() {
        super(Enchantment.Rarity.UNCOMMON, EnumEnchantmentType.BREAKABLE, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND});
        this.setRegistryName("xpboost");
    }

    public int func_77317_b(int level) {
        return super.func_77317_b(level) + 30;
    }

    public int func_77321_a(int level) {
        return super.func_77321_a(level);
    }

    public int func_77325_b() {
        return 3;
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.field_77351_y.func_77557_a(stack.func_77973_b()) && !(stack.func_77973_b() instanceof ItemArmor) && !(stack.func_77973_b() instanceof ItemFishingRod);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.func_92089_a(stack);
    }

    public String func_77320_a() {
        return "enchantment.xpboost";
    }

    public boolean isAllowedOnBooks() {
        return ConfigHandler.allowXPBoost;
    }

    @Override
    public String[] getTooltipDetails(ItemStack stack) {
        return new String[]{EnderCore.lang.localize("enchantment.xpboost.tooltip", false)};
    }

    public static void register() {
        if (ConfigHandler.allowXPBoost) {
            INSTANCE = new EnchantXPBoost();
            GameRegistry.register((IForgeRegistryEntry)INSTANCE);
            FMLInterModComms.sendMessage((String)"EnderIO", (String)"recipe:enchanter", (String)("<enchantment name=\"" + EnderCore.DOMAIN + ":xpboost\" costPerLevel=\"4\">\n<itemStack oreDictionary=\"ingotGold\" number=\"16\"/>\n</enchantment>"));
        }
    }
}

