/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Log;
import com.enderio.core.common.vecmath.Vector3d;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class Util {
    public static String WailaStyle = "\u00a4";
    public static String WailaIcon = "\u00a5";
    public static String TAB = WailaStyle + WailaStyle + "a";
    public static String ALIGNRIGHT = WailaStyle + WailaStyle + "b";
    public static String ALIGNCENTER = WailaStyle + WailaStyle + "c";
    public static String HEART = WailaStyle + WailaIcon + "a";
    public static String HHEART = WailaStyle + WailaIcon + "b";
    public static String EHEART = WailaStyle + WailaIcon + "c";

    public static Block getBlockFromItemId(ItemStack itemId) {
        Item item = itemId.func_77973_b();
        if (item instanceof ItemBlock) {
            return ((ItemBlock)item).field_150939_a;
        }
        return null;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemPotion) {
            if (stack.field_77994_a == 1) {
                return new ItemStack(Items.field_151069_bo);
            }
            stack.func_77979_a(1);
            return stack;
        }
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }

    public static void giveExperience(EntityPlayer thePlayer, float experience) {
        int intExp = (int)experience;
        float fractional = experience - (float)intExp;
        if (fractional > 0.0f && (float)Math.random() < fractional) {
            ++intExp;
        }
        while (intExp > 0) {
            int j = EntityXPOrb.func_70527_a((int)intExp);
            intExp -= j;
            thePlayer.field_70170_p.func_72838_d((Entity)new EntityXPOrb(thePlayer.field_70170_p, thePlayer.field_70165_t, thePlayer.field_70163_u + 0.5, thePlayer.field_70161_v + 0.5, j));
        }
    }

    public static BlockCoord canPlaceItem(ItemStack stack, IBlockState blockToBePlaced, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (stack == null || stack.field_77994_a == 0 || blockToBePlaced == null) {
            return null;
        }
        IBlockState bs = world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)world, pos)) {
            pos = pos.func_177972_a(side);
        }
        if (!player.func_175151_a(pos, side, stack)) {
            return null;
        }
        if (pos.func_177956_o() == 255 && blockToBePlaced.func_185904_a().func_76220_a()) {
            return null;
        }
        if (world.func_175716_a(blockToBePlaced.func_177230_c(), pos, false, side, (Entity)player, stack)) {
            return new BlockCoord(pos);
        }
        return null;
    }

    public static EntityItem createDrop(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack == null || stack.field_77994_a <= 0) {
            return null;
        }
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.func_174869_p();
            return entityitem;
        }
        EntityItem entityitem = new EntityItem(world, x, y, z, stack);
        entityitem.field_70159_w = 0.0;
        entityitem.field_70181_x = 0.0;
        entityitem.field_70179_y = 0.0;
        entityitem.func_174868_q();
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, BlockPos pos, boolean doRandomSpread) {
        Util.dropItems(world, stack, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), doRandomSpread);
    }

    public static void dropItems(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        EntityItem entityitem = Util.createEntityItem(world, stack, x, y, z, doRandomSpread);
        world.func_72838_d((Entity)entityitem);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z) {
        return Util.createEntityItem(world, stack, x, y, z, true);
    }

    public static EntityItem createEntityItem(World world, ItemStack stack, double x, double y, double z, boolean doRandomSpread) {
        EntityItem entityitem;
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            entityitem = new EntityItem(world, x + d, y + d1, z + d2, stack);
            entityitem.func_174869_p();
        } else {
            entityitem = new EntityItem(world, x, y, z, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.func_174868_q();
        }
        return entityitem;
    }

    public static void dropItems(World world, ItemStack stack, int x, int y, int z, boolean doRandomSpread) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        if (doRandomSpread) {
            float f1 = 0.7f;
            double d = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f1) + (double)(1.0f - f1) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d, (double)y + d1, (double)z + d2, stack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        } else {
            EntityItem entityitem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, stack);
            entityitem.field_70159_w = 0.0;
            entityitem.field_70181_x = 0.0;
            entityitem.field_70179_y = 0.0;
            entityitem.func_174868_q();
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static void dropItems(World world, ItemStack[] inventory, int x, int y, int z, boolean doRandomSpread) {
        if (inventory == null) {
            return;
        }
        for (ItemStack stack : inventory) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            Util.dropItems(world, stack.func_77946_l(), x, y, z, doRandomSpread);
        }
    }

    public static void dropItems(World world, IInventory inventory, int x, int y, int z, boolean doRandomSpread) {
        for (int l = 0; l < inventory.func_70302_i_(); ++l) {
            ItemStack items = inventory.func_70301_a(l);
            if (items == null || items.field_77994_a <= 0) continue;
            Util.dropItems(world, items.func_77946_l(), x, y, z, doRandomSpread);
        }
    }

    public static boolean dumpModObjects(File file) {
        StringBuilder sb = new StringBuilder();
        for (Object key : Block.field_149771_c.func_148742_b()) {
            if (key == null) continue;
            sb.append(key.toString());
            sb.append("\n");
        }
        for (Object key : Item.field_150901_e.func_148742_b()) {
            if (key == null) continue;
            sb.append(key.toString());
            sb.append("\n");
        }
        try {
            Files.write((CharSequence)sb, (File)file, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Log.warn("Error dumping ore dictionary entries: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean dumpOreNames(File file) {
        try {
            Object[] oreNames = OreDictionary.getOreNames();
            Files.write((CharSequence)Joiner.on((String)"\n").join(oreNames), (File)file, (Charset)Charsets.UTF_8);
            return true;
        }
        catch (IOException e) {
            Log.warn("Error dumping ore dictionary entries: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static ItemStack decrStackSize(IInventory inventory, int slot, int size) {
        ItemStack item = inventory.func_70301_a(slot);
        if (item != null) {
            if (item.field_77994_a <= size) {
                ItemStack result = item;
                inventory.func_70299_a(slot, null);
                inventory.func_70296_d();
                return result;
            }
            ItemStack split = item.func_77979_a(size);
            if (item.field_77994_a == 0) {
                inventory.func_70299_a(slot, null);
            }
            inventory.func_70296_d();
            return split;
        }
        return null;
    }

    public static Vec3d getEyePosition(EntityPlayer player) {
        double y = player.field_70163_u;
        return new Vec3d(player.field_70165_t, y += (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vector3d getEyePositionEio(EntityPlayer player) {
        Vector3d res = new Vector3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        res.y += (double)player.func_70047_e();
        return res;
    }

    public static Vector3d getLookVecEio(EntityPlayer player) {
        Vec3d lv = player.func_70040_Z();
        return new Vector3d(lv.field_72450_a, lv.field_72448_b, lv.field_72449_c);
    }

    public static boolean isEquipped(EntityPlayer player, Class<? extends Item> class1) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.func_70448_g() == null) {
            return false;
        }
        return class1.isAssignableFrom(player.field_71071_by.func_70448_g().func_77973_b().getClass());
    }

    public static boolean isType(ItemStack stack, Class<?> class1) {
        if (stack == null || class1 == null) {
            return false;
        }
        return class1.isAssignableFrom(stack.func_77973_b().getClass());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<RayTraceResult> raytraceAll(World world, Vec3d startVec, Vec3d endVec, boolean includeLiquids) {
        RayTraceResult movingobjectposition;
        ArrayList<RayTraceResult> result = new ArrayList<RayTraceResult>();
        boolean p_147447_4_ = false;
        boolean p_147447_5_ = false;
        if (Double.isNaN(startVec.field_72450_a)) return result;
        if (Double.isNaN(startVec.field_72448_b) || Double.isNaN(startVec.field_72449_c)) return result;
        if (Double.isNaN(endVec.field_72450_a) || Double.isNaN(endVec.field_72448_b) || Double.isNaN(endVec.field_72449_c)) return result;
        int endX = MathHelper.func_76128_c((double)endVec.field_72450_a);
        int endY = MathHelper.func_76128_c((double)endVec.field_72448_b);
        int endZ = MathHelper.func_76128_c((double)endVec.field_72449_c);
        int startX = MathHelper.func_76128_c((double)startVec.field_72450_a);
        int startY = MathHelper.func_76128_c((double)startVec.field_72448_b);
        int startZ = MathHelper.func_76128_c((double)startVec.field_72449_c);
        BlockPos pos = new BlockPos(startX, startY, startZ);
        IBlockState bs = world.func_180495_p(pos);
        Block block = bs.func_177230_c();
        if ((!p_147447_4_ || block.func_180646_a(bs, world, pos) != null) && block.func_176209_a(bs, includeLiquids) && (movingobjectposition = block.func_180636_a(bs, world, new BlockPos(startX, startY, startZ), startVec, endVec)) != null) {
            result.add(movingobjectposition);
        }
        RayTraceResult movingobjectposition2 = null;
        int k1 = 200;
        while (k1-- >= 0) {
            EnumFacing enumfacing;
            if (Double.isNaN(startVec.field_72450_a) || Double.isNaN(startVec.field_72448_b) || Double.isNaN(startVec.field_72449_c)) {
                return null;
            }
            if (startX == endX && startY == endY && startZ == endZ) {
                if (!p_147447_5_) return result;
                result.add(movingobjectposition2);
            }
            boolean flag6 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (endX > startX) {
                d0 = (double)startX + 1.0;
            } else if (endX < startX) {
                d0 = (double)startX + 0.0;
            } else {
                flag6 = false;
            }
            if (endY > startY) {
                d1 = (double)startY + 1.0;
            } else if (endY < startY) {
                d1 = (double)startY + 0.0;
            } else {
                flag3 = false;
            }
            if (endZ > startZ) {
                d2 = (double)startZ + 1.0;
            } else if (endZ < startZ) {
                d2 = (double)startZ + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = endVec.field_72450_a - startVec.field_72450_a;
            double d7 = endVec.field_72448_b - startVec.field_72448_b;
            double d8 = endVec.field_72449_c - startVec.field_72449_c;
            if (flag6) {
                d3 = (d0 - startVec.field_72450_a) / d6;
            }
            if (flag3) {
                d4 = (d1 - startVec.field_72448_b) / d7;
            }
            if (flag4) {
                d5 = (d2 - startVec.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = endX > startX ? EnumFacing.WEST : EnumFacing.EAST;
                startVec = new Vec3d(d0, startVec.field_72448_b + d7 * d3, startVec.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = endY > startY ? EnumFacing.DOWN : EnumFacing.UP;
                startVec = new Vec3d(startVec.field_72450_a + d6 * d4, d1, startVec.field_72449_c + d8 * d4);
            } else {
                enumfacing = endZ > startZ ? EnumFacing.NORTH : EnumFacing.SOUTH;
                startVec = new Vec3d(startVec.field_72450_a + d6 * d5, startVec.field_72448_b + d7 * d5, d2);
            }
            startX = MathHelper.func_76128_c((double)startVec.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
            startY = MathHelper.func_76128_c((double)startVec.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
            startZ = MathHelper.func_76128_c((double)startVec.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
            pos = new BlockPos(startX, startY, startZ);
            IBlockState bs1 = world.func_180495_p(pos);
            Block block1 = bs.func_177230_c();
            if (p_147447_4_ && block1.func_180646_a(bs1, world, new BlockPos(startX, startY, startZ)) == null) continue;
            if (block1.func_176209_a(bs1, includeLiquids)) {
                RayTraceResult movingobjectposition1 = block1.func_180636_a(bs1, world, new BlockPos(startX, startY, startZ), startVec, endVec);
                if (movingobjectposition1 == null) continue;
                result.add(movingobjectposition1);
                continue;
            }
            movingobjectposition2 = new RayTraceResult(startVec, enumfacing, pos);
        }
        if (!p_147447_5_) {
            return result;
        }
        result.add(movingobjectposition2);
        return result;
    }

    public static EnumFacing getDirFromOffset(int xOff, int yOff, int zOff) {
        if (xOff != 0 && yOff == 0 && zOff == 0) {
            return xOff < 0 ? EnumFacing.WEST : EnumFacing.EAST;
        }
        if (zOff != 0 && yOff == 0 && xOff == 0) {
            return zOff < 0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
        }
        if (yOff != 0 && xOff == 0 && zOff == 0) {
            return yOff < 0 ? EnumFacing.DOWN : EnumFacing.UP;
        }
        return null;
    }

    public static int getProgressScaled(int scale, IProgressTile tile) {
        return (int)(tile.getProgress() * (float)scale);
    }

    public static void writeFacingToNBT(NBTTagCompound nbtRoot, String name, EnumFacing dir) {
        if (nbtRoot == null || name == null) {
            return;
        }
        short val = -1;
        if (dir != null) {
            val = (short)dir.ordinal();
        }
        nbtRoot.func_74777_a(name, val);
    }

    public static EnumFacing readFacingFromNBT(NBTTagCompound nbtRoot, String name) {
        if (nbtRoot == null || name == null) {
            return null;
        }
        int val = -1;
        if (nbtRoot.func_74764_b(name)) {
            val = nbtRoot.func_74765_d(name);
        }
        if (val > 0) {
            return EnumFacing.values()[val];
        }
        return null;
    }
}

