/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.blocks.BlockEnderKeyChest;
import gigaherz.enderthing.network.UpdatePlayersUsing;
import gigaherz.enderthing.storage.EnderInventory;
import gigaherz.enderthing.storage.InventoryManager;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnderKeyChest
extends TileEntityEnderChest {
    private int inventoryId;
    private int ticksSinceSync;
    protected boolean isPrivate;
    private UUID boundToPlayer;
    private EnderInventory inventory;

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public int getInventoryId() {
        return this.inventoryId;
    }

    public void setInventoryId(int inventoryId) {
        this.inventoryId = inventoryId;
        this.releasePreviousInventory();
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Nullable
    public UUID getPlayerBound() {
        return this.boundToPlayer;
    }

    public void bindToPlayer(UUID boundToPlayer) {
        this.boundToPlayer = boundToPlayer;
        this.releasePreviousInventory();
        this.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean isBoundToPlayer() {
        return this.boundToPlayer != null;
    }

    private void releasePreviousInventory() {
        if (this.inventory != null) {
            this.inventory.removeWeakListener(this);
        }
        this.inventory = null;
    }

    public boolean hasInventory() {
        return this.inventoryId >= 0 && (!this.isPrivate || this.isBoundToPlayer());
    }

    @Nullable
    public EnderInventory getInventory() {
        if (this.inventoryId < 0) {
            return null;
        }
        if (this.inventory == null && (!this.isPrivate || this.isBoundToPlayer())) {
            this.inventory = this.isBoundToPlayer() ? InventoryManager.get(this.field_145850_b).getPrivate(this.boundToPlayer).getInventory(this.inventoryId) : InventoryManager.get(this.field_145850_b).getInventory(this.inventoryId);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177229_b((IProperty)BlockEnderKeyChest.PRIVATE) != newState.func_177229_b((IProperty)BlockEnderKeyChest.PRIVATE) || oldState.func_177229_b((IProperty)BlockEnderKeyChest.BOUND) != newState.func_177229_b((IProperty)BlockEnderKeyChest.BOUND);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventoryId = tag.func_74762_e("InventoryId");
        this.boundToPlayer = InventoryManager.uuidFromNBT(tag);
        this.releasePreviousInventory();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74768_a("InventoryId", this.inventoryId);
        if (this.boundToPlayer != null) {
            InventoryManager.uuidToNBT(tag, this.boundToPlayer);
        }
        return tag;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.hasInventory();
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.getInventory());
        }
        return (T)super.getCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.handleUpdateTag(packet.func_148857_g());
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public void func_73660_a() {
        if (++this.ticksSinceSync % 80 == 0 && !this.field_145850_b.field_72995_K) {
            Enderthing.channel.sendToAllAround((IMessage)new UpdatePlayersUsing(this.field_174879_c, 1, this.field_145973_j), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 64.0));
        }
        this.field_145975_i = this.field_145972_a;
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        float f = 0.1f;
        if (this.field_145973_j > 0 && this.field_145972_a == 0.0f) {
            this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187520_aJ, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.field_145973_j == 0 && this.field_145972_a > 0.0f || this.field_145973_j > 0 && this.field_145972_a < 1.0f) {
            float closedThreshold;
            float prevAngle = this.field_145972_a;
            this.field_145972_a = this.field_145973_j > 0 ? (this.field_145972_a += f) : (this.field_145972_a -= f);
            if (this.field_145972_a > 1.0f) {
                this.field_145972_a = 1.0f;
            }
            if (this.field_145972_a < (closedThreshold = 0.5f) && prevAngle >= closedThreshold) {
                this.field_145850_b.func_184148_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, SoundEvents.field_187519_aI, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.field_145972_a < 0.0f) {
                this.field_145972_a = 0.0f;
            }
        }
    }

    public void receiveUpdate(int id, int value) {
        if (id == 1) {
            this.field_145973_j = value;
        }
    }

    public static class Private
    extends TileEnderKeyChest {
        public Private() {
            this.isPrivate = true;
        }
    }
}

