/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing;

import com.mojang.realmsclient.gui.ChatFormatting;
import gigaherz.enderthing.IModProxy;
import gigaherz.enderthing.blocks.BlockEnderKeyChest;
import gigaherz.enderthing.blocks.TileEnderKeyChest;
import gigaherz.enderthing.gui.GuiHandler;
import gigaherz.enderthing.items.ItemEnderCard;
import gigaherz.enderthing.items.ItemEnderKey;
import gigaherz.enderthing.items.ItemEnderLock;
import gigaherz.enderthing.items.ItemEnderPack;
import gigaherz.enderthing.network.UpdatePlayersUsing;
import gigaherz.enderthing.recipes.ChangeColorsRecipe;
import gigaherz.enderthing.recipes.KeyRecipe;
import gigaherz.enderthing.recipes.LockRecipe;
import gigaherz.enderthing.recipes.MakePrivateRecipe;
import gigaherz.enderthing.recipes.PackRecipe;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.RecipeSorter;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="enderthing", version="0.7.3", acceptedMinecraftVersions="[1.11.0,1.12.0)")
public class Enderthing {
    public static final String MODID = "enderthing";
    public static final String VERSION = "0.7.3";
    public static final String CHANNEL = "Enderthing";
    public static final String INVENTORY_ID_KEY = "InventoryId";
    public static final int ITEM_PRIVATE_BIT = 1;
    public static final int BLOCK_PRIVATE_BIT = 8;
    public static BlockEnderKeyChest enderKeyChest;
    public static ItemEnderKey enderKey;
    public static ItemEnderLock enderLock;
    public static ItemEnderPack enderPack;
    public static ItemEnderCard enderCard;
    @Mod.Instance(value="enderthing")
    public static Enderthing instance;
    @SidedProxy(clientSide="gigaherz.enderthing.client.ClientProxy", serverSide="gigaherz.enderthing.server.ServerProxy")
    public static IModProxy proxy;
    public static GuiHandler guiHandler;
    public static CreativeTabs tabEnderthing;
    public static SimpleNetworkWrapper channel;
    public static Logger logger;
    public static Configuration config;
    public static boolean breakChestOnHarvest;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[1];
        enderKeyChest = new BlockEnderKeyChest("ender_key_chest");
        blockArray[0] = enderKeyChest;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[5];
        itemArray[0] = enderKeyChest.createItemBlock();
        enderKey = new ItemEnderKey("ender_key");
        itemArray[1] = enderKey;
        enderLock = new ItemEnderLock("ender_lock");
        itemArray[2] = enderLock;
        enderPack = new ItemEnderPack("ender_pack");
        itemArray[3] = enderPack;
        enderCard = new ItemEnderCard("ender_card");
        itemArray[4] = enderCard;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntityWithAlternatives(TileEnderKeyChest.class, (String)Enderthing.location("ender_key_chest").toString(), (String[])new String[]{"tileEnderKeyChest"});
        GameRegistry.registerTileEntityWithAlternatives(TileEnderKeyChest.Private.class, (String)Enderthing.location("ender_key_chest_private").toString(), (String[])new String[]{"tileEnderKeyPrivateChest"});
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        config = new Configuration(event.getSuggestedConfigurationFile());
        Property breakChest = config.get("Balance", "BreakChestOnHarvest", true);
        if (!breakChest.wasRead()) {
            config.save();
        } else {
            breakChestOnHarvest = breakChest.getBoolean();
        }
        this.registerTileEntities();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)guiHandler);
        channel = NetworkRegistry.INSTANCE.newSimpleChannel(CHANNEL);
        int messageNumber = 0;
        channel.registerMessage(UpdatePlayersUsing.Handler.class, UpdatePlayersUsing.class, messageNumber++, Side.CLIENT);
        logger.debug("Final message number: " + messageNumber);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)enderCard), (Object[])new Object[]{"nnn", "ppp", "nnn", Character.valueOf('n'), Items.field_151074_bl, Character.valueOf('p'), Items.field_151121_aF});
        GameRegistry.addRecipe((IRecipe)new KeyRecipe());
        GameRegistry.addRecipe((IRecipe)new LockRecipe());
        GameRegistry.addRecipe((IRecipe)new PackRecipe());
        GameRegistry.addRecipe((IRecipe)new MakePrivateRecipe(enderKey));
        GameRegistry.addRecipe((IRecipe)new MakePrivateRecipe(enderLock));
        GameRegistry.addRecipe((IRecipe)new MakePrivateRecipe(enderPack));
        GameRegistry.addRecipe((IRecipe)new MakePrivateRecipe(enderKeyChest));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderKey, false));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderLock, false));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderPack, false));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderKeyChest, false));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderKey, true));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderLock, true));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderPack, true));
        GameRegistry.addRecipe((IRecipe)new ChangeColorsRecipe(enderKeyChest, true));
        RecipeSorter.register((String)"enderthing:ender_key", KeyRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"enderthing:ender_lock", LockRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"enderthing:ender_pack", PackRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"enderthing:make_private", MakePrivateRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"enderthing:change_color", ChangeColorsRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:minecraft:shaped");
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static int getIdFromItem(ItemStack stack) {
        byte color1 = 0;
        int color2 = 0;
        int color3 = 0;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            color1 = tag.func_74771_c("Color1");
            color2 = tag.func_74771_c("Color2");
            color3 = tag.func_74771_c("Color3");
        }
        return Enderthing.getId(color1, color2, color3);
    }

    public static int getIdFromBlock(ItemStack stack) {
        NBTTagCompound etag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (etag = tag.func_74775_l("BlockEntityTag")) != null) {
            return etag.func_74762_e(INVENTORY_ID_KEY);
        }
        return -1;
    }

    private static int getId(int c1, int c2, int c3) {
        return c1 | c2 << 4 | c3 << 8;
    }

    public static int getId(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return Enderthing.getIdFromBlock(stack);
        }
        return Enderthing.getIdFromItem(stack);
    }

    public static int getPrivateBit(Item item) {
        if (item instanceof ItemBlock) {
            return 8;
        }
        return 1;
    }

    public static ItemStack getItem(Item item, int c1, int c2, int c3, boolean priv) {
        if (item instanceof ItemBlock) {
            return Enderthing.getItem(Enderthing.getId(c1, c2, c3), priv);
        }
        ItemStack key = new ItemStack(item, 1, priv ? Enderthing.getPrivateBit(item) : 0);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74774_a("Color1", (byte)c1);
        tag.func_74774_a("Color2", (byte)c2);
        tag.func_74774_a("Color3", (byte)c3);
        key.func_77982_d(tag);
        return key;
    }

    public static ItemStack getLock(int id, boolean priv) {
        int c1 = id & 0xF;
        int c2 = id >> 4 & 0xF;
        int c3 = id >> 8 & 0xF;
        return Enderthing.getItem(enderLock, c1, c2, c3, priv);
    }

    public static boolean isPrivate(ItemStack input) {
        if (input.func_77973_b() instanceof ItemBlock) {
            return (input.func_77960_j() & 8) != 0;
        }
        return (input.func_77960_j() & 1) != 0;
    }

    public static ItemStack getItem(int id, boolean priv) {
        ItemStack stack = new ItemStack((Block)enderKeyChest, 1, priv ? 8 : 0);
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound etag = new NBTTagCompound();
        etag.func_74768_a(INVENTORY_ID_KEY, id);
        tag.func_74782_a("BlockEntityTag", (NBTBase)etag);
        stack.func_77982_d(tag);
        return stack;
    }

    public static int getIdFromBlock(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEnderKeyChest) {
            return ((TileEnderKeyChest)te).getInventoryId();
        }
        return -1;
    }

    public static void addStandardInformation(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        int id;
        if (Enderthing.isPrivate(stack)) {
            tooltip.add(ChatFormatting.BOLD + I18n.func_135052_a((String)"tooltip.enderthing.private", (Object[])new Object[0]));
        }
        if ((id = Enderthing.getId(stack)) < 0) {
            tooltip.add(ChatFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.enderthing.colorMissing", (Object[])new Object[0]));
            return;
        }
        int color1 = id & 0xF;
        int color2 = id >> 4 & 0xF;
        int color3 = id >> 8 & 0xF;
        EnumDyeColor c1 = EnumDyeColor.func_176764_b((int)color1);
        EnumDyeColor c2 = EnumDyeColor.func_176764_b((int)color2);
        EnumDyeColor c3 = EnumDyeColor.func_176764_b((int)color3);
        tooltip.add(I18n.func_135052_a((String)"tooltip.enderthing.colors", (Object[])new Object[]{c1.func_176610_l(), c2.func_176610_l(), c3.func_176610_l()}));
    }

    static {
        guiHandler = new GuiHandler();
        tabEnderthing = new CreativeTabs("tabEnderthing"){

            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((Item)enderKey);
            }
        };
        breakChestOnHarvest = true;
    }
}

