/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.blocks.TileEnderKeyChest;
import gigaherz.enderthing.gui.GuiHandler;
import gigaherz.enderthing.shadow.common.BlockRegistered;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnderKeyChest
extends BlockRegistered {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool PRIVATE = PropertyBool.func_177716_a((String)"private");
    public static final PropertyBool BOUND = PropertyBool.func_177716_a((String)"bound");
    protected static final AxisAlignedBB ENDER_CHEST_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);

    public BlockEnderKeyChest(String name) {
        super(name, Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BOUND, (Comparable)Boolean.valueOf(false)));
        this.func_149647_a(Enderthing.tabEnderthing);
        this.func_149711_c(22.5f);
        this.func_149752_b(1000.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149715_a(0.5f);
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)PRIVATE)).booleanValue()) {
            return new TileEnderKeyChest.Private();
        }
        return new TileEnderKeyChest();
    }

    @Deprecated
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return BlockEnderKeyChest.getItem((IBlockAccess)world, pos);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList ret = Lists.newArrayList();
        ret.add(new ItemStack(Blocks.field_150343_Z, 8));
        ret.add(Enderthing.getLock(Enderthing.getIdFromBlock(world, pos), (Boolean)state.func_177229_b((IProperty)PRIVATE)));
        return ret;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        if (!Enderthing.breakChestOnHarvest || this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList items = Lists.newArrayList();
            ItemStack itemstack = BlockEnderKeyChest.getItem((IBlockAccess)worldIn, pos);
            items.add(itemstack);
            ForgeEventFactory.fireBlockHarvesting((List)items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                BlockEnderKeyChest.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.func_176226_b(worldIn, pos, state, i);
            this.harvesters.set(null);
        }
        worldIn.func_175698_g(pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te == null || !(te instanceof TileEnderKeyChest)) {
            return true;
        }
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185915_l()) {
            return true;
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEnderKeyChest chest = (TileEnderKeyChest)te;
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (side == EnumFacing.UP && heldItem.func_77973_b() == Items.field_151100_aR && (chest.getPlayerBound() == null || chest.getPlayerBound().equals(playerIn.func_110124_au()))) {
            int oldId;
            int meta = EnumDyeColor.func_176766_a((int)heldItem.func_77960_j()).func_176765_a();
            float z = hitZ;
            float x = hitX;
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case EAST: {
                    x = hitZ;
                    z = 1.0f - hitX;
                    break;
                }
                case SOUTH: {
                    x = 1.0f - hitX;
                    z = 1.0f - hitZ;
                    break;
                }
                case WEST: {
                    x = 1.0f - hitZ;
                    z = hitX;
                }
            }
            x *= 16.0f;
            z *= 16.0f;
            boolean hitSuccess = false;
            int id = oldId = chest.getInventoryId();
            if (z >= 1.0f && z <= 8.0f) {
                int color1 = id & 0xF;
                int color2 = id >> 4 & 0xF;
                int color3 = id >> 8 & 0xF;
                if ((double)x >= 3.5 && (double)x < 6.5) {
                    color3 = meta;
                    hitSuccess = true;
                } else if ((double)x >= 6.5 && (double)x < 9.5) {
                    color2 = meta;
                    hitSuccess = true;
                } else if ((double)x >= 9.5 && (double)x < 12.5) {
                    color1 = meta;
                    hitSuccess = true;
                }
                id = color1 | color2 << 4 | color3 << 8;
            }
            if (oldId != id) {
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    heldItem.func_190917_f(-1);
                }
                chest.setInventoryId(id);
            }
            if (hitSuccess) {
                return true;
            }
        }
        GuiHandler.openKeyGui(worldIn, pos, playerIn, chest.getInventoryId(), (Boolean)state.func_177229_b((IProperty)PRIVATE));
        return true;
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ENDER_CHEST_AABB;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf((stack.func_77960_j() & 8) != 0)), 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < 3; ++i) {
            int xOffset = rand.nextInt(2) * 2 - 1;
            int zOffset = rand.nextInt(2) * 2 - 1;
            double xPos = (double)pos.func_177958_n() + 0.5 + (double)xOffset * 0.25;
            double yPos = (float)pos.func_177956_o() + rand.nextFloat();
            double zPos = (double)pos.func_177952_p() + 0.5 + (double)zOffset * 0.25;
            double xSpeed = rand.nextFloat() * (float)xOffset;
            double ySpeed = (double)rand.nextFloat() * 0.125 - 0.0625;
            double zSpeed = rand.nextFloat() * (float)zOffset;
            worldIn.func_175688_a(EnumParticleTypes.PORTAL, xPos, yPos, zPos, xSpeed, ySpeed, zSpeed, new int[0]);
        }
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)PRIVATE, (Comparable)Boolean.valueOf((meta & 8) != 0)).func_177226_a((IProperty)BOUND, (Comparable)Boolean.valueOf((meta & 0xC) == 12));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() | ((Boolean)state.func_177229_b((IProperty)PRIVATE) != false ? 8 : 0) | ((Boolean)state.func_177229_b((IProperty)BOUND) != false ? 4 : 0);
    }

    @Deprecated
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Deprecated
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PRIVATE, BOUND});
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(ChatFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.enderthing.ender_key_chest.rightClick", (Object[])new Object[0]));
        Enderthing.addStandardInformation(stack, player, tooltip, advanced);
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this));
        list.add((Object)new ItemStack((Block)this, 1, 8));
    }

    @Override
    public ItemBlock createItemBlock() {
        return new AsItem(this);
    }

    private static ItemStack getItem(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEnderKeyChest) {
            int id = ((TileEnderKeyChest)te).getInventoryId();
            return Enderthing.getItem(id, (Boolean)state.func_177229_b((IProperty)PRIVATE));
        }
        return new ItemStack((Block)Enderthing.enderKeyChest);
    }

    public static class AsItem
    extends ItemBlock {
        public AsItem(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
            ItemStack itemStackIn = playerIn.func_184586_b(hand);
            if (playerIn.func_70093_af()) {
                int oldId = Enderthing.getIdFromBlock(itemStackIn);
                ItemStack oldStack = Enderthing.getLock(oldId, itemStackIn.func_77960_j() != 0);
                if (!playerIn.field_71071_by.func_70441_a(oldStack)) {
                    playerIn.func_71019_a(oldStack, false);
                }
                if (itemStackIn.func_190916_E() > 1) {
                    ItemStack stack = new ItemStack(Blocks.field_150477_bB);
                    if (!playerIn.field_71071_by.func_70441_a(stack)) {
                        playerIn.func_71019_a(stack, false);
                    }
                    itemStackIn.func_190917_f(-1);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)new ItemStack(Blocks.field_150477_bB));
            }
            return super.func_77659_a(worldIn, playerIn, hand);
        }
    }
}

