/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.items;

import com.mojang.realmsclient.gui.ChatFormatting;
import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.blocks.BlockEnderKeyChest;
import gigaherz.enderthing.blocks.TileEnderKeyChest;
import gigaherz.enderthing.shadow.common.ItemRegistered;
import gigaherz.enderthing.storage.InventoryManager;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemEnderCard
extends ItemRegistered {
    public ItemEnderCard(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77637_a(Enderthing.tabEnderthing);
    }

    public void bindToPlayer(ItemStack stack, EntityPlayer player) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a("PlayerName", player.func_70005_c_());
        InventoryManager.uuidToNBT(tag, player.func_110124_au());
    }

    @Nullable
    public UUID getBoundPlayerUniqueID(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        return InventoryManager.uuidFromNBT(tag);
    }

    @Nullable
    public String getBoundPlayerCachedName(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return null;
        }
        if (!tag.func_150297_b("PlayerName", 8)) {
            return null;
        }
        return tag.func_74779_i("PlayerName");
    }

    public void setBoundPlayerCachedName(ItemStack stack, String newName) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        tag.func_74778_a("PlayerName", newName);
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return super.func_77636_d(stack);
        }
        return tag.func_150297_b("PlayerUUID0", 4) && tag.func_150297_b("PlayerUUID1", 4);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack itemStackIn = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        if (playerIn.func_70093_af()) {
            this.bindToPlayer(itemStackIn, playerIn);
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("text.enderthing.ender_card.bound", new Object[0]));
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return super.func_77659_a(worldIn, playerIn, hand);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        IBlockState state = worldIn.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b != Enderthing.enderKeyChest || !((Boolean)state.func_177229_b((IProperty)BlockEnderKeyChest.PRIVATE)).booleanValue()) {
            return EnumActionResult.PASS;
        }
        int id = 0;
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEnderKeyChest) {
            id = ((TileEnderKeyChest)te).getInventoryId();
        }
        state = state.func_177226_a((IProperty)BlockEnderKeyChest.BOUND, (Comparable)Boolean.valueOf(true));
        worldIn.func_175656_a(pos, state);
        te = worldIn.func_175625_s(pos);
        if (te instanceof TileEnderKeyChest) {
            ItemStack stack = playerIn.func_184586_b(hand);
            UUID uuid = this.getBoundPlayerUniqueID(stack);
            TileEnderKeyChest chest = (TileEnderKeyChest)te;
            chest.setInventoryId(id);
            chest.bindToPlayer(uuid);
            String name = this.getBoundPlayerCachedName(stack);
            if (name == null || name.length() == 0) {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("text.enderthing.ender_chest.bound1", new Object[]{new TextComponentString(uuid.toString())}));
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("text.enderthing.ender_chest.bound2", new Object[]{new TextComponentString(uuid.toString()), new TextComponentString(name)}));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        UUID uuid;
        if (!worldIn.field_72995_K && (long)(stack.hashCode() % 120) == worldIn.func_82737_E() % 120L && (uuid = this.getBoundPlayerUniqueID(stack)) != null) {
            String name = this.getBoundPlayerCachedName(stack);
            String newName = Enderthing.proxy.queryNameFromUUID(uuid);
            if (newName != null && !newName.equals(name)) {
                this.setBoundPlayerCachedName(stack, newName);
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        tooltip.add(ChatFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.enderthing.ender_card.rightClick1", (Object[])new Object[0]));
        tooltip.add(ChatFormatting.ITALIC + I18n.func_135052_a((String)"tooltip.enderthing.ender_card.rightClick2", (Object[])new Object[0]));
        UUID uuid = this.getBoundPlayerUniqueID(stack);
        if (uuid == null) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.enderthing.ender_card.unbound", (Object[])new Object[0]));
            return;
        }
        String name = this.getBoundPlayerCachedName(stack);
        String uuidText = uuid.toString();
        if (!advanced && !Keyboard.isKeyDown((int)42)) {
            String uuidBegin = uuidText.substring(0, 4);
            String uuidEnd = uuidText.substring(uuidText.length() - 4);
            uuidText = uuidBegin + "..." + uuidEnd;
        }
        if (name == null || name.length() == 0) {
            tooltip.add(I18n.func_135052_a((String)"tooltip.enderthing.ender_card.bound1", (Object[])new Object[]{uuidText}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.enderthing.ender_card.bound2", (Object[])new Object[]{uuidText, name}));
        }
    }
}

