/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.shadow.common.state.client;

import com.google.common.collect.Maps;
import gigaherz.enderthing.shadow.common.state.IItemState;
import gigaherz.enderthing.shadow.common.state.IItemStateManager;
import gigaherz.enderthing.shadow.common.state.ItemStateful;
import java.util.Map;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;

public class ItemStateMapper
implements ItemMeshDefinition {
    public final Map<ItemStateful, ItemStateMapper> STATE_MAPPERS = Maps.newHashMap();
    final ItemStateful item;

    public ItemStateMapper(ItemStateful item) {
        this.item = item;
    }

    public void registerAllModelsExplicitly() {
        IItemStateManager manager = this.item.getStateManager();
        for (IItemState state : manager.getStateTable()) {
            ModelLoader.setCustomModelResourceLocation((Item)this.item, (int)state.getMetadata(), (ModelResourceLocation)this.getModelLocation(state));
        }
    }

    private ModelResourceLocation getModelLocation(IItemState state) {
        return new ModelResourceLocation(this.item.getRegistryName(), state.toString());
    }

    public ModelResourceLocation func_178113_a(ItemStack stack) {
        if (stack.func_77973_b() != this.item) {
            throw new IllegalArgumentException("The stack's item is not the expected item!");
        }
        IItemState state = IItemStateManager.lookup(stack);
        if (state == null) {
            state = this.item.getDefaultState();
        }
        return this.getModelLocation(state);
    }
}

