/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.storage;

import com.google.common.collect.Lists;
import gigaherz.enderthing.blocks.TileEnderKeyChest;
import gigaherz.enderthing.storage.IInventoryManager;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.ItemStackHandler;

public class EnderInventory
extends ItemStackHandler {
    public static final int SLOT_COUNT = 27;
    private final IInventoryManager manager;
    private final List<Reference<? extends TileEnderKeyChest>> listeners = Lists.newArrayList();
    private final ReferenceQueue<TileEnderKeyChest> deadListeners = new ReferenceQueue();

    public void addWeakListener(TileEnderKeyChest e) {
        this.listeners.add(new WeakReference<TileEnderKeyChest>(e, this.deadListeners));
    }

    public void removeWeakListener(TileEnderKeyChest e) {
        this.listeners.remove((Object)e);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        Reference<TileEnderKeyChest> ref = this.deadListeners.poll();
        while (ref != null) {
            this.listeners.remove(ref);
            ref = this.deadListeners.poll();
        }
        ArrayList dirty = Lists.newArrayList();
        Iterator<Reference<? extends TileEnderKeyChest>> it = this.listeners.iterator();
        while (it.hasNext()) {
            TileEnderKeyChest te = it.next().get();
            if (te == null || te.func_145837_r()) {
                it.remove();
                continue;
            }
            dirty.add(te);
        }
        dirty.forEach(TileEntity::func_70296_d);
        this.manager.setDirty();
    }

    EnderInventory(IInventoryManager manager) {
        super(27);
        this.setSize(27);
        this.manager = manager;
    }
}

