/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.blocks;

import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.enderthing.KeyUtils;
import gigaherz.enderthing.blocks.EnderKeyChestBlock;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class EnderKeyChestRenderer
extends TileEntityRenderer<EnderKeyChestTileEntity> {
    private static final ResourceLocation ENDER_CHEST_TEXTURE = new ResourceLocation("textures/entity/chest/ender.png");
    public static final EnderKeyChestRenderer INSTANCE = new EnderKeyChestRenderer();
    private final ChestModel chestModel = new ChestModel();

    private EnderKeyChestRenderer() {
    }

    public void renderFromItem(ItemStack stack) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ItemStack lock = KeyUtils.getLock(KeyUtils.getKey(stack), KeyUtils.isPrivate(stack), KeyUtils.getBound(stack));
        this.renderInternal(0.0, 0.0, 0.0, minecraft.func_184121_ak(), -1, 0, 0.0f, 0.0f, lock);
    }

    public void render(EnderKeyChestTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        int j = 0;
        if (te.func_145830_o()) {
            switch ((Direction)te.func_195044_w().func_177229_b((IProperty)EnderKeyChestBlock.FACING)) {
                case NORTH: {
                    j = 180;
                    break;
                }
                case SOUTH: {
                    j = 0;
                    break;
                }
                case WEST: {
                    j = 90;
                    break;
                }
                case EAST: {
                    j = -90;
                }
            }
        }
        ItemStack lock = KeyUtils.getLock(te.getKey(), te.isPrivate(), te.getPlayerBound());
        this.renderInternal(x, y, z, partialTicks, destroyStage, j, te.prevLidAngle, te.lidAngle, lock);
    }

    public void renderInternal(double x, double y, double z, float partialTicks, int destroyStage, int rotation, float prevLidAngle, float lidAngle, ItemStack lock) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            this.func_147499_a(ENDER_CHEST_TEXTURE);
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.translated((double)x, (double)(y + 1.0), (double)(z + 1.0));
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        float angle = prevLidAngle + (lidAngle - prevLidAngle) * partialTicks;
        angle = 1.0f - angle;
        angle = 1.0f - angle * angle * angle;
        this.chestModel.func_205058_b().field_78795_f = -(angle * 1.5707964f);
        this.chestModel.func_78231_a();
        GlStateManager.disableRescaleNormal();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotatef((float)(180 - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
        GlStateManager.translated((double)0.5, (double)0.35, (double)0.0375);
        float scale = 0.75f;
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(lock, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }
}

