/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing.gui;

import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import gigaherz.enderthing.gui.LockedSlot;
import gigaherz.enderthing.storage.InventoryManager;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ObjectHolder;

public class KeyContainer
extends Container {
    public static final Runnable NOOP = () -> {};
    @ObjectHolder(value="enderthing:key")
    public static ContainerType<KeyContainer> TYPE = null;
    private final Predicate<PlayerEntity> interactTest;
    private final Runnable onClose;

    private static boolean isUsableByPlayer(@Nullable TileEntity te, PlayerEntity p) {
        if (te == null) {
            return true;
        }
        return p.func_70092_e((double)te.func_174877_v().func_177958_n() + 0.5, (double)te.func_174877_v().func_177956_o() + 0.5, (double)te.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    private static IItemHandler getInventory(@Nullable World world, PlayerEntity user, boolean isPriv, long key, @Nullable UUID bound) {
        if (world == null) {
            return new ItemStackHandler(27);
        }
        InventoryManager inventoryManager = InventoryManager.get(world);
        InventoryManager mgr = isPriv ? inventoryManager.getPrivate(bound != null ? bound : user.func_110124_au()) : inventoryManager;
        return mgr.getInventory(key);
    }

    private static IItemHandler getInventory(EnderKeyChestTileEntity enderChest, PlayerEntity user) {
        boolean isPriv = enderChest.isPrivate();
        World world = enderChest.func_145831_w();
        UUID bound = enderChest.getPlayerBound();
        long key = enderChest.getKey();
        return KeyContainer.getInventory(world, user, isPriv, key, bound);
    }

    public KeyContainer(int windowId, PlayerInventory playerInv, PacketBuffer extraData) {
        this(windowId, playerInv, extraData.readInt(), (IItemHandler)new ItemStackHandler(27), p -> true, NOOP);
    }

    public KeyContainer(int windowId, PlayerInventory playerInventory, EnderKeyChestTileEntity keyChest) {
        this(windowId, playerInventory, -1, KeyContainer.getInventory(keyChest, playerInventory.field_70458_d), p -> KeyContainer.isUsableByPlayer(keyChest, p), keyChest::closeChest);
    }

    public KeyContainer(int windowId, PlayerInventory playerInventory, @Nullable TileEntity enderChest, boolean isPrivate, int slot, long id, @Nullable UUID bound) {
        this(windowId, playerInventory, slot, KeyContainer.getInventory(playerInventory.field_70458_d.field_70170_p, playerInventory.field_70458_d, isPrivate, id, bound), p -> KeyContainer.isUsableByPlayer(enderChest, p), NOOP);
    }

    public KeyContainer(int windowId, PlayerInventory playerInventory, int lockedSlot, IItemHandler inventory, @Nullable Predicate<PlayerEntity> interactTest, @Nullable Runnable onClose) {
        super(TYPE, windowId);
        this.interactTest = interactTest;
        this.onClose = onClose;
        for (int j = 0; j < 3; ++j) {
            for (int k = 0; k < 9; ++k) {
                this.func_75146_a((Slot)new SlotItemHandler(inventory, k + j * 9, 8 + k * 18, 18 + j * 18));
            }
        }
        this.bindPlayerInventory(playerInventory, lockedSlot);
    }

    private void bindPlayerInventory(PlayerInventory playerInventory, int lockedSlot) {
        for (int py = 0; py < 3; ++py) {
            for (int px = 0; px < 9; ++px) {
                int slot = px + py * 9 + 9;
                if (slot == lockedSlot) {
                    this.func_75146_a(new LockedSlot((IInventory)playerInventory, slot, 8 + px * 18, 103 + py * 18 - 18));
                    continue;
                }
                this.func_75146_a(new Slot((IInventory)playerInventory, slot, 8 + px * 18, 103 + py * 18 - 18));
            }
        }
        for (int slot = 0; slot < 9; ++slot) {
            if (slot == lockedSlot) {
                this.func_75146_a(new LockedSlot((IInventory)playerInventory, slot, 8 + slot * 18, 143));
                continue;
            }
            this.func_75146_a(new Slot((IInventory)playerInventory, slot, 8 + slot * 18, 143));
        }
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.onClose.run();
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.interactTest.test(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack stackCopy = stack.func_77946_l();
        if (index < 27 ? !this.func_75135_a(stack, 27, this.field_75151_b.size(), true) : !this.func_75135_a(stack, 0, 27, false)) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() == 0) {
            slot.func_75215_d(ItemStack.field_190927_a);
        } else {
            slot.func_75218_e();
        }
        return stackCopy;
    }
}

