/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gigaherz.enderthing.KeyUtils;
import gigaherz.enderthing.blocks.EnderKeyChestBlock;
import gigaherz.enderthing.blocks.EnderKeyChestBlockItem;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import gigaherz.enderthing.gui.KeyContainer;
import gigaherz.enderthing.gui.KeyScreen;
import gigaherz.enderthing.gui.PasscodeContainer;
import gigaherz.enderthing.gui.PasscodeScreen;
import gigaherz.enderthing.items.EnderCardItem;
import gigaherz.enderthing.items.EnderKeyItem;
import gigaherz.enderthing.items.EnderLockItem;
import gigaherz.enderthing.items.EnderPackItem;
import gigaherz.enderthing.network.SetItemKey;
import gigaherz.enderthing.recipes.AddLockRecipe;
import gigaherz.enderthing.recipes.MakeBoundRecipe;
import gigaherz.enderthing.recipes.MakePrivateRecipe;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.ILootConditionConsumer;
import net.minecraft.world.storage.loot.ILootFunctionConsumer;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.StandaloneLootEntry;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraft.world.storage.loot.functions.CopyName;
import net.minecraft.world.storage.loot.functions.CopyNbt;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="enderthing")
public class Enderthing {
    public static final String MODID = "enderthing";
    @ObjectHolder(value="enderthing:key_chest")
    public static EnderKeyChestBlock KEY_CHEST;
    @ObjectHolder(value="enderthing:key_chest")
    public static EnderKeyChestBlockItem KEY_CHEST_ITEM;
    @ObjectHolder(value="enderthing:key")
    public static EnderKeyItem KEY;
    @ObjectHolder(value="enderthing:lock")
    public static EnderLockItem LOCK;
    @ObjectHolder(value="enderthing:pack")
    public static EnderPackItem PACK;
    @ObjectHolder(value="enderthing:card")
    public static EnderCardItem CARD;
    public static Enderthing INSTANCE;
    public static ItemGroup ENDERTHING_GROUP;
    public static final Logger LOGGER;
    private static final String PROTOCOL_VERSION = "1.0";
    public static final SimpleChannel CHANNEL;

    public Enderthing() {
        INSTANCE = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Block.class, this::registerBlocks);
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addGenericListener(TileEntityType.class, this::registerTileEntities);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new EnderKeyChestBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(22.5f, 1000.0f).func_200947_a(SoundType.field_185851_d).func_200951_a(5)).setRegistryName("key_chest")});
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new EnderKeyChestBlockItem((Block)KEY_CHEST, new Item.Properties()).setRegistryName(KEY_CHEST.getRegistryName()), (Item)new EnderKeyItem(new Item.Properties().func_200916_a(ENDERTHING_GROUP)).setRegistryName("key"), (Item)new EnderLockItem(new Item.Properties().func_200916_a(ENDERTHING_GROUP)).setRegistryName("lock"), (Item)new EnderPackItem(new Item.Properties().func_200917_a(1).func_200916_a(ENDERTHING_GROUP)).setRegistryName("pack"), (Item)new EnderCardItem(new Item.Properties().func_200917_a(1).func_200916_a(ENDERTHING_GROUP)).setRegistryName("card")});
    }

    private void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{(TileEntityType)TileEntityType.Builder.func_223042_a(EnderKeyChestTileEntity::new, (Block[])new Block[]{KEY_CHEST}).func_206865_a(null).setRegistryName("key_chest")});
    }

    private void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)IForgeContainerType.create(KeyContainer::new).setRegistryName("key"), (ContainerType)IForgeContainerType.create(PasscodeContainer::new).setRegistryName("passcode")});
    }

    private void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new SpecialRecipeSerializer(MakePrivateRecipe::new).setRegistryName("make_private"), (IRecipeSerializer)new SpecialRecipeSerializer(AddLockRecipe::new).setRegistryName("add_lock"), (IRecipeSerializer)new SpecialRecipeSerializer(MakeBoundRecipe::new).setRegistryName("make_bound")});
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        CHANNEL.messageBuilder(SetItemKey.class, messageNumber++).encoder(SetItemKey::encode).decoder(SetItemKey::new).consumer(SetItemKey::handle).add();
        LOGGER.debug("Final message number: " + messageNumber);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(KeyContainer.TYPE, KeyScreen::new);
        ScreenManager.func_216911_a(PasscodeContainer.TYPE, PasscodeScreen::new);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeServer()) {
            gen.func_200390_a((IDataProvider)new Recipes(gen));
            gen.func_200390_a((IDataProvider)new LootTables(gen));
        }
        if (event.includeClient()) {
            // empty if block
        }
    }

    static {
        ENDERTHING_GROUP = new ItemGroup("enderthing.things"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)KEY);
            }
        };
        LOGGER = LogManager.getLogger((String)MODID);
        CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)KEY).func_200472_a("o  ").func_200472_a("eog").func_200472_a("nnn").func_200462_a(Character.valueOf('o'), (IItemProvider)Blocks.field_150343_Z).func_200462_a(Character.valueOf('g'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('n'), (IItemProvider)Items.field_191525_da).func_200465_a("has_gold", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151061_bv)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)LOCK).func_200472_a(" g ").func_200472_a("geg").func_200472_a("nnn").func_200462_a(Character.valueOf('g'), (IItemProvider)Items.field_151043_k).func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('n'), (IItemProvider)Items.field_191525_da).func_200465_a("has_gold", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151061_bv)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)PACK).func_200472_a("lel").func_200472_a("nnn").func_200472_a("lcl").func_200462_a(Character.valueOf('l'), (IItemProvider)Items.field_151116_aA).func_200462_a(Character.valueOf('c'), (IItemProvider)Blocks.field_150477_bB).func_200462_a(Character.valueOf('e'), (IItemProvider)Items.field_151061_bv).func_200462_a(Character.valueOf('n'), (IItemProvider)Items.field_191525_da).func_200465_a("has_gold", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151061_bv)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)CARD).func_200472_a("nnn").func_200472_a("ppp").func_200472_a("nnn").func_200462_a(Character.valueOf('n'), (IItemProvider)Items.field_151074_bl).func_200462_a(Character.valueOf('p'), (IItemProvider)Items.field_151121_aF).func_200465_a("has_gold", (ICriterionInstance)this.func_200403_a((IItemProvider)Items.field_151061_bv)).func_200464_a(consumer);
            CustomRecipeBuilder.func_218656_a(MakePrivateRecipe.SERIALIZER).func_200499_a(consumer, "enderthing:make_private");
            CustomRecipeBuilder.func_218656_a(AddLockRecipe.SERIALIZER).func_200499_a(consumer, "enderthing:add_lock");
            CustomRecipeBuilder.func_218656_a(MakeBoundRecipe.SERIALIZER).func_200499_a(consumer, "enderthing:make_bound");
        }
    }

    private static class LootTables
    extends LootTableProvider
    implements IDataProvider {
        private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.field_216267_h));

        public LootTables(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return this.tables;
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
            map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
        }

        public static class BlockTables
        extends BlockLootTables {
            protected void addTables() {
                this.func_218522_a((Block)KEY_CHEST, (Function<Block, LootTable.Builder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, func_218544_f(net.minecraft.block.Block ), (Lnet/minecraft/block/Block;)Lnet/minecraft/world/storage/loot/LootTable$Builder;)());
            }

            protected static LootTable.Builder dropping(Block block, ILootCondition.IBuilder condition, LootEntry.Builder<?> alternativeEntry) {
                return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(condition)).func_216080_a(alternativeEntry)));
            }

            protected static LootTable.Builder droppingWithContents(Block block) {
                return LootTable.func_216119_b().func_216040_a((LootPool.Builder)BlockTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(field_218573_a)).func_212841_b_((ILootFunction.IBuilder)CopyName.func_215893_a((CopyName.Source)CopyName.Source.BLOCK_ENTITY)).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Key", "BlockEntityTag.Key").func_216056_a("IsPrivate", "BlockEntityTag.IsPrivate").func_216056_a("Bound", "BlockEntityTag.Bound")).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)LOCK).func_212841_b_((ILootFunction.IBuilder)CopyNbt.func_215881_a((CopyNbt.Source)CopyNbt.Source.BLOCK_ENTITY).func_216056_a("Key", "Key").func_216056_a("IsPrivate", "IsPrivate").func_216056_a("Bound", "Bound")))))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a(BlockTables.withNoSilkTouchRandomly(block, (IItemProvider)Items.field_221655_bP, (IRandomRange)ConstantRange.func_215835_a((int)8))));
            }

            protected static LootEntry.Builder<?> withNoSilkTouchRandomly(Block block, IItemProvider item, IRandomRange range) {
                return ((StandaloneLootEntry.Builder)BlockTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)range)))).func_212840_b_(field_218574_b);
            }

            protected Iterable<Block> getKnownBlocks() {
                return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals(Enderthing.MODID)).collect(Collectors.toList());
            }
        }
    }

    public static class Client {
        public static void addStandardInformation(ItemStack stack, List<ITextComponent> tooltip) {
            long key;
            if (KeyUtils.isPrivate(stack)) {
                tooltip.add(new TranslationTextComponent("tooltip.enderthing.private", new Object[0]).func_211709_a(new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.BOLD}));
            }
            if ((key = KeyUtils.getKey(stack)) >= 0L) {
                tooltip.add(new TranslationTextComponent("tooltip.enderthing.key", new Object[]{key}).func_211708_a(TextFormatting.ITALIC));
            } else {
                tooltip.add(new TranslationTextComponent("tooltip.enderthing.key_missing", new Object[0]).func_211708_a(TextFormatting.ITALIC));
            }
        }
    }
}

