/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderthing;

import com.google.common.primitives.Longs;
import gigaherz.enderthing.Enderthing;
import gigaherz.enderthing.blocks.EnderKeyChestTileEntity;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class KeyUtils {
    public static long getKey(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IKeyHolder) {
            return ((IKeyHolder)item).getKey(stack);
        }
        return -1L;
    }

    public static ItemStack setKey(ItemStack stack, long key) {
        Item item = stack.func_77973_b();
        if (item instanceof IKeyHolder) {
            ((IKeyHolder)item).setKey(stack, key);
        }
        return stack;
    }

    public static boolean isPrivate(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IKeyHolder) {
            return ((IKeyHolder)item).isPrivate(stack);
        }
        return false;
    }

    public static ItemStack setPrivate(ItemStack stack, boolean priv) {
        Item item = stack.func_77973_b();
        if (item instanceof IKeyHolder) {
            ((IKeyHolder)item).setPrivate(stack, priv);
        }
        return stack;
    }

    public static boolean isBound(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IBindable) {
            return ((IBindable)item).isBound(stack);
        }
        return false;
    }

    @Nullable
    public static UUID getBound(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IBindable) {
            return ((IBindable)item).getBound(stack);
        }
        return null;
    }

    public static ItemStack setBound(ItemStack stack, @Nullable UUID uuid) {
        Item item = stack.func_77973_b();
        if (item instanceof IBindable) {
            ((IBindable)item).setBound(stack, uuid);
        }
        return stack;
    }

    public static long getKey(TileEntity te) {
        if (te instanceof EnderKeyChestTileEntity) {
            return ((EnderKeyChestTileEntity)te).getKey();
        }
        return -1L;
    }

    public static ItemStack getItem(IItemProvider itemProvider, long key, boolean priv) {
        ItemStack stack = new ItemStack(itemProvider);
        KeyUtils.setKey(stack, key);
        KeyUtils.setPrivate(stack, priv);
        return stack;
    }

    public static ItemStack getLock(long key, boolean priv) {
        return KeyUtils.getItem((IItemProvider)Enderthing.LOCK, key, priv);
    }

    public static ItemStack getLock(long key, boolean priv, @Nullable UUID bound) {
        ItemStack stack = KeyUtils.getItem((IItemProvider)Enderthing.LOCK, key, priv);
        if (bound != null) {
            KeyUtils.setBound(stack, bound);
        }
        return stack;
    }

    public static ItemStack getKeyChest(long key, boolean priv, @Nullable UUID bound) {
        ItemStack stack = KeyUtils.getItem((IItemProvider)Enderthing.KEY_CHEST_ITEM, key, priv);
        if (bound != null) {
            KeyUtils.setBound(stack, bound);
        }
        return stack;
    }

    @Nullable
    public static String queryNameFromUUID(UUID uuid) {
        MinecraftServer svr = ServerLifecycleHooks.getCurrentServer();
        if (svr == null) {
            return null;
        }
        PlayerList playerList = svr.func_184103_al();
        if (playerList == null) {
            return null;
        }
        ServerPlayerEntity player = playerList.func_177451_a(uuid);
        if (player != null) {
            return player.func_200200_C_().getString();
        }
        return null;
    }

    public static long getKeyFromPasscode(String passcode) {
        if (Strings.isNullOrEmpty((String)passcode)) {
            return -1L;
        }
        if (!passcode.startsWith("-")) {
            try {
                return Long.parseLong(passcode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passcode.getBytes());
            return Longs.fromByteArray((byte[])md.digest()) & Long.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public static long getKeyFromPasscode(List<ItemStack> passcode) {
        if (passcode.size() == 0) {
            return -1L;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            for (ItemStack st : passcode) {
                md.update(st.func_77973_b().getRegistryName().toString().getBytes());
                if (!st.func_82837_s()) continue;
                md.update(st.func_200301_q().func_150261_e().getBytes());
            }
            return Longs.fromByteArray((byte[])md.digest()) & Long.MAX_VALUE;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface IBindableKeyHolder
    extends IKeyHolder,
    IBindable {
        @Override
        default public boolean isBound(ItemStack stack) {
            if (!this.isPrivate(stack)) {
                return false;
            }
            return this.findHolderTag(stack).map(tag -> !Strings.isNullOrEmpty((String)tag.func_74779_i("Bound"))).orElse(false);
        }

        @Nullable
        default public String getBoundStr(ItemStack stack) {
            if (!this.isPrivate(stack)) {
                return null;
            }
            return this.findHolderTag(stack).map(tag -> tag.func_74779_i("Bound")).orElse(null);
        }

        @Override
        @Nullable
        default public UUID getBound(ItemStack stack) {
            if (!this.isPrivate(stack)) {
                return null;
            }
            return this.findHolderTag(stack).map(tag -> {
                if (!tag.func_150297_b("Bound", 8)) {
                    return null;
                }
                try {
                    return UUID.fromString(tag.func_74779_i("Bound"));
                }
                catch (IllegalArgumentException e) {
                    Enderthing.LOGGER.warn("Stack contained wrong UUID", (Throwable)e);
                    return null;
                }
            }).orElse(null);
        }

        @Override
        default public void setBound(ItemStack stack, @Nullable UUID uuid) {
            if (uuid == null) {
                this.findHolderTag(stack).ifPresent(blockTag -> blockTag.func_82580_o("Bound"));
            } else {
                this.getOrCreateHolderTag(stack).func_74778_a("Bound", uuid.toString());
            }
        }
    }

    public static interface IBindable {
        public Optional<CompoundNBT> findHolderTag(ItemStack var1);

        public CompoundNBT getOrCreateHolderTag(ItemStack var1);

        public boolean isBound(ItemStack var1);

        @Nullable
        public UUID getBound(ItemStack var1);

        public void setBound(ItemStack var1, @Nullable UUID var2);
    }

    public static interface IKeyHolder {
        public Optional<CompoundNBT> findHolderTag(ItemStack var1);

        public CompoundNBT getOrCreateHolderTag(ItemStack var1);

        default public boolean isPrivate(ItemStack stack) {
            return this.findHolderTag(stack).map(blockTag -> blockTag.func_74767_n("IsPrivate")).orElse(false);
        }

        default public void setPrivate(ItemStack stack, boolean priv) {
            this.getOrCreateHolderTag(stack).func_74757_a("IsPrivate", priv);
        }

        default public long getKey(ItemStack stack) {
            return this.findHolderTag(stack).map(blockTag -> blockTag.func_150297_b("Key", 4) ? blockTag.func_74763_f("Key") : -1L).orElse(-1L);
        }

        default public void setKey(ItemStack stack, long key) {
            this.getOrCreateHolderTag(stack).func_74772_a("Key", key);
        }
    }
}

